/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.security;

import com.sun.javacard.Logger;
import com.sun.javacard.cm.impl.ApplicationImpl;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.security.Principal;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javacard.framework.Shareable;
import javacardx.facilities.ServiceRegistry;
import javacardx.framework.Authenticator;
import javacardx.framework.JCSystem;
import javacardx.framework.SharedBioTemplateAuth;
import javacardx.framework.SharedPINAuth;
import javacardx.framework.SharedPasswordAuth;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.servlet.http.HttpDigestAuthentication;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.security.DigestAuthenticator;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.AbstractSessionManager;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class SIOUserRealm
implements UserRealm {
    private static final String GLOBAL_HOLDER_AUTH = "sio:///standard/auth/holder/global/";
    private static final String SESSION_HOLDER_AUTH = "sio:///standard/auth/holder/session/";
    private static final String SESSION_USER_AUTH = "sio:///standard/auth/user/session/";
    private static final String DEFAULT_REALM_NAME = "JCRealm";
    private static final String JC_AUTH_METHOD_PREFIX = "JC-";
    private String realmName;

    public SIOUserRealm(String name) {
        this.realmName = name;
    }

    public void setName(String name) {
        this.realmName = name;
    }

    @Override
    public String getName() {
        return this.realmName;
    }

    @Override
    public Principal getPrincipal(String username) {
        return null;
    }

    @Override
    public Principal authenticate(String username, Object credentials, Request request, String authMethod) {
        Logger.debug("authenticate");
        if (credentials != null) {
            Logger.debug("class is:" + credentials.getClass());
        }
        ServiceRegistry registry = ServiceRegistry.getServiceRegistry();
        String[] authSchemes = this.getSchemeNames(authMethod);
        if (authSchemes == null) {
            Logger.debug("Unsupported authentication method/scheme: " + authMethod);
            return null;
        }
        String authenticatorURI = this.getAuthenticatorURI(username, authSchemes, request);
        if (authenticatorURI == null) {
            Logger.debug("user not in role");
            return null;
        }
        if (authenticatorURI.startsWith("sio:///standard/auth/holder/") && !SIOUserRealm.isTrustedClient(request)) {
            Logger.debug("card holder cant be remote");
            return null;
        }
        Shareable authenticator = registry.lookup(authenticatorURI);
        if (authenticator == null) {
            Logger.debug("Could not lookup() authenticator URI: " + authenticatorURI);
            return null;
        }
        Logger.debug("authenticator:" + authenticator);
        if (JCSystem.getServerURI(authenticator) != null && JCSystem.isTransferable(credentials)) {
            JCSystem.transferOwnership(credentials, authenticator);
        }
        if (credentials instanceof DigestAuthenticator.Digest && authenticator instanceof HttpDigestAuthentication) {
            DigestAuthenticator.Digest digest = (DigestAuthenticator.Digest)credentials;
            if (JCSystem.getServerURI(authenticator) != null) {
                JCSystem.transferOwnership((Object)digest.username, authenticator);
                JCSystem.transferOwnership((Object)digest.realm, authenticator);
                JCSystem.transferOwnership((Object)digest.method, authenticator);
                JCSystem.transferOwnership((Object)digest.uri, authenticator);
                JCSystem.transferOwnership((Object)digest.nonce, authenticator);
                JCSystem.transferOwnership((Object)digest.nc, authenticator);
                JCSystem.transferOwnership((Object)digest.cnonce, authenticator);
                JCSystem.transferOwnership((Object)digest.qop, authenticator);
                JCSystem.transferOwnership((Object)digest.response, authenticator);
            }
            if (((HttpDigestAuthentication)authenticator).check(digest.username, digest.realm, digest.method, digest.uri, digest.nonce, digest.nc, digest.cnonce, digest.qop, digest.response)) {
                Logger.debug("valid");
                AuthenticatedUser kuser = new AuthenticatedUser(username, authenticatorURI);
                return kuser;
            }
        } else if (credentials instanceof String && authenticator instanceof SharedPINAuth) {
            byte[] pin = ((String)credentials).getBytes();
            if (((SharedPINAuth)authenticator).check(pin, (short)0, (byte)pin.length)) {
                Logger.debug("valid");
                AuthenticatedUser kuser = new AuthenticatedUser(username, authenticatorURI);
                return kuser;
            }
        } else if (credentials instanceof String && authenticator instanceof SharedPasswordAuth) {
            if (((SharedPasswordAuth)authenticator).check((String)credentials)) {
                Logger.debug("valid");
                AuthenticatedUser kuser = new AuthenticatedUser(username, authenticatorURI);
                return kuser;
            }
        } else if (credentials instanceof byte[] && authenticator instanceof SharedBioTemplateAuth) {
            byte[] template = (byte[])credentials;
            if (((SharedBioTemplateAuth)authenticator).initMatch(template, (short)0, (short)template.length) >= 16384) {
                Logger.debug("valid");
                AuthenticatedUser kuser = new AuthenticatedUser(username, authenticatorURI);
                return kuser;
            }
        } else if (credentials instanceof String && authenticator instanceof SharedBioTemplateAuth) {
            byte[] template = ((String)credentials).getBytes();
            if (((SharedBioTemplateAuth)authenticator).initMatch(template, (short)0, (short)template.length) >= 16384) {
                Logger.debug("valid");
                AuthenticatedUser kuser = new AuthenticatedUser(username, authenticatorURI);
                return kuser;
            }
        } else {
            Logger.debug("Authenticator " + authenticatorURI + "does not support authentication method: " + authMethod);
            return null;
        }
        Logger.debug("invalid");
        return null;
    }

    private String[] getSchemeNames(String authMethod) {
        if (authMethod.equals("BASIC") || authMethod.equals("DIGEST") || authMethod.equals("FORM")) {
            return new String[]{"pin", "password"};
        }
        if (authMethod.startsWith(JC_AUTH_METHOD_PREFIX)) {
            String authScheme = authMethod.substring(JC_AUTH_METHOD_PREFIX.length());
            return new String[]{authScheme};
        }
        return null;
    }

    private String getAuthenticatorURI(String userName, String[] authSchemes, Request request) {
        Hashtable<String, Vector<String>> role2uriMap = ApplicationImpl.getRole2URIMappingTable(request.getContextPath());
        Vector<String> authorizedRoles = request.getAuthorizedRoles();
        Logger.debug("SIORealm.getAuthenticatorURI: " + userName + "AuthSchems: " + authSchemes[0] + ", " + (authSchemes.length > 1 ? authSchemes[1] : " ") + "authorizedRoles: " + authorizedRoles);
        if (authorizedRoles != null && authorizedRoles.size() > 0) {
            Logger.debug("authorizedRoles" + authorizedRoles);
            for (String role : authorizedRoles) {
                Vector<String> authenticatorURIs = role2uriMap.get(role);
                if (authenticatorURIs == null || authenticatorURIs.size() <= 0) continue;
                for (String authenticatorURI : authenticatorURIs) {
                    int userIndex;
                    int schemeIndex;
                    int realmIndex = -1;
                    if (authenticatorURI.startsWith(GLOBAL_HOLDER_AUTH)) {
                        realmIndex = GLOBAL_HOLDER_AUTH.length() - 1;
                    } else if (authenticatorURI.startsWith(SESSION_HOLDER_AUTH)) {
                        realmIndex = SESSION_HOLDER_AUTH.length() - 1;
                    } else if (authenticatorURI.startsWith(SESSION_USER_AUTH)) {
                        realmIndex = SESSION_USER_AUTH.length() - 1;
                    }
                    if (realmIndex == -1 || (schemeIndex = authenticatorURI.lastIndexOf(47)) == -1 || (userIndex = authenticatorURI.lastIndexOf(47, schemeIndex - 1)) == -1 || (userIndex - realmIndex != 0 || !this.realmName.equals(DEFAULT_REALM_NAME)) && (this.realmName.length() != userIndex - realmIndex - 1 || !authenticatorURI.regionMatches(false, realmIndex + 1, this.realmName, 0, this.realmName.length())) || userName.length() != schemeIndex - userIndex - 1 || !authenticatorURI.regionMatches(false, userIndex + 1, userName, 0, userName.length())) continue;
                    for (String authScheme : authSchemes) {
                        if (!authenticatorURI.regionMatches(false, schemeIndex + 1, authScheme, 0, authScheme.length()) || authScheme.length() != authenticatorURI.length() - schemeIndex - 1) continue;
                        return authenticatorURI;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGloballyAuthenticated(Request request, String role) {
        boolean bl;
        Iterator<String> i$;
        byte currentAppId;
        short currentContext;
        block12: {
            currentContext = NativeMethods.getCurrentContext();
            currentAppId = NativeMethods.getCurrentAppId();
            NativeMethods.switchContext(0, 0);
            if (SIOUserRealm.isTrustedClient(request)) break block12;
            boolean bl2 = false;
            NativeMethods.switchContext(currentContext, currentAppId);
            return bl2;
        }
        Hashtable<String, Vector<String>> role2uriMap = ApplicationImpl.getRole2URIMappingTable(request.getContextPath());
        Logger.debug("role2uri is:" + role2uriMap);
        ServiceRegistry registry = ServiceRegistry.getServiceRegistry();
        Vector<String> authenticatorURIs = role2uriMap.get(role);
        if (authenticatorURIs != null && authenticatorURIs.size() > 0) {
            i$ = authenticatorURIs.iterator();
        } else {
            try {
                Logger.debug("No global card holder user permitted to access the resource.");
                boolean bl3 = false;
                return bl3;
            }
            finally {
                NativeMethods.switchContext(currentContext, currentAppId);
            }
        }
        while (i$.hasNext()) {
            block13: {
                block14: {
                    String authenticatorURI = i$.next();
                    if (!authenticatorURI.startsWith(GLOBAL_HOLDER_AUTH)) continue;
                    if (authenticatorURI == null) break block13;
                    Shareable authenticator = null;
                    authenticator = registry.lookup(authenticatorURI);
                    if (authenticator == null || !(authenticator instanceof Authenticator) || !((Authenticator)authenticator).isValidated()) break block14;
                    Logger.debug("Global card holder user (permitted to access the resource) already authenticated.");
                    boolean bl4 = true;
                    {
                        catch (Exception ex) {
                            ex.printStackTrace();
                            continue;
                        }
                    }
                    NativeMethods.switchContext(currentContext, currentAppId);
                    return bl4;
                }
                boolean bl5 = false;
                NativeMethods.switchContext(currentContext, currentAppId);
                return bl5;
            }
        }
        {
            Logger.debug("No global card holder user (permitted to access the resource) already authenticated.");
            bl = false;
        }
        NativeMethods.switchContext(currentContext, currentAppId);
        return bl;
    }

    public boolean isAccessibleFromClient(Request request) {
        if (!SIOUserRealm.isTrustedClient(request)) {
            Vector<String> cardHolderAuthorizationURIs = ApplicationImpl.getCardHolderRolesRequiredForAuthorization(request.getContextPath());
            return cardHolderAuthorizationURIs != null && cardHolderAuthorizationURIs.size() > 0;
        }
        return true;
    }

    public boolean isCardHolderAuthorized(Request request) {
        Logger.debug("global authorization");
        ServiceRegistry serviceRegistry = ServiceRegistry.getServiceRegistry();
        Hashtable<String, Vector<String>> role2uriMap = ApplicationImpl.getRole2URIMappingTable(request.getContextPath());
        if (!SIOUserRealm.isTrustedClient(request)) {
            AbstractSessionManager.Session session = (AbstractSessionManager.Session)request.getSession();
            Logger.debug("Session is:" + session);
            if (!session.isSessionAuthorized()) {
                Logger.debug("Session was not prev. authorized, need to check authorization");
                Vector<String> cardHolderAuthorizationRoles = ApplicationImpl.getCardHolderRolesRequiredForAuthorization(request.getContextPath());
                Logger.debug("Card holder authorized roles:" + cardHolderAuthorizationRoles);
                if (cardHolderAuthorizationRoles != null) {
                    boolean authorized = false;
                    if (cardHolderAuthorizationRoles.size() > 0) {
                        for (String cardHolderAuthorizationRole : cardHolderAuthorizationRoles) {
                            Vector<String> authenticatorURIs = role2uriMap.get(cardHolderAuthorizationRole);
                            if (authenticatorURIs != null) {
                                for (String authenticatorURI : authenticatorURIs) {
                                    Shareable authenticator = serviceRegistry.lookup(authenticatorURI);
                                    Logger.debug("authenticator" + authenticator);
                                    if (authenticator instanceof Authenticator) {
                                        Logger.debug("authenticator" + authenticator);
                                        if (!((Authenticator)authenticator).isValidated()) continue;
                                        authorized = true;
                                        break;
                                    }
                                    Logger.debug("no authenticator" + authenticator);
                                }
                            }
                            if (!authorized) continue;
                            break;
                        }
                    }
                    if (!authorized) {
                        Logger.debug("Not authorized.");
                        return false;
                    }
                } else {
                    Logger.debug("Not remotely accessible. Not authorized.");
                    return false;
                }
            }
            session.setSessionAuthorized(true);
        }
        Logger.debug("Authorized.");
        return true;
    }

    private static boolean isTrustedClient(Request request) {
        String trustedIPAddress;
        String clientIP = request.getHeader("JC-MyIP");
        if (clientIP == null) {
            clientIP = request.getRemoteAddr();
        }
        assert (clientIP != null) : "Expected non-null client IP address.";
        if ("YES".equals(SIOUserRealm.getSystemProperty("trusted.localhost", "YES"))) {
            String headerValue;
            return clientIP.equals(request.getLocalAddr()) && ((headerValue = new String(request.getHeader("User-Agent"))).indexOf(SIOUserRealm.getSystemProperty("trusted.useragent.includes", "Firefox")) >= 0 || headerValue.indexOf("httpunit") >= 0) && headerValue.indexOf(SIOUserRealm.getSystemProperty("trusted.useragent.excludes", "MSIE")) < 0;
        }
        int i = 0;
        while ((trustedIPAddress = System.getProperty("trusted.ip" + i)) != null) {
            if (clientIP.equals(trustedIPAddress.trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String getSystemProperty(String name, String defaultValue) {
        String str = System.getProperty(name);
        if (str != null && (str = str.trim()).length() <= 0) {
            str = null;
        }
        if (str == null) {
            Logger.debug("str was null");
            str = defaultValue;
        }
        Logger.debug("trusted client is=" + str);
        return str;
    }

    @Override
    public void disassociate(Principal user) {
    }

    @Override
    public Principal pushRole(Principal user, String role) {
        return user;
    }

    @Override
    public Principal popRole(Principal user) {
        return user;
    }

    @Override
    public boolean reauthenticate(Principal user) {
        return ((User)user).isAuthenticated();
    }

    @Override
    public boolean isUserInRole(Principal user, String roleName, Request request) {
        if (user == null || !(user instanceof User) || ((User)user).getUserRealm() != this) {
            return false;
        }
        Hashtable<String, Vector<String>> role2uriMap = ApplicationImpl.getRole2URIMappingTable(request.getContextPath());
        Vector<String> authenticatorURIs = role2uriMap.get(roleName);
        if (authenticatorURIs != null) {
            return authenticatorURIs.contains(((User)user).getAuthenticatorURI());
        }
        return false;
    }

    @Override
    public void logout(Principal user) {
    }

    public class ForbiddenUser
    extends User {
        @Override
        public String getName() {
            return "forbidden";
        }
    }

    public class AuthenticatedUser
    extends User {
        private String userName;
        private String authenticatorURI;

        AuthenticatedUser(String name, String authURI) {
            this.userName = name;
            this.authenticatorURI = authURI;
        }

        @Override
        public String getName() {
            if (this.userName != null) {
                String str = new String(this.userName);
                NativeMethods.transferOwnershipToPreviousContext(str);
                return str;
            }
            return this.userName;
        }

        @Override
        public String getAuthenticatorURI() {
            return this.authenticatorURI;
        }

        @Override
        public boolean isAuthenticated() {
            return true;
        }
    }

    public class User
    implements Principal {
        User() {
            NativeMethods.setJCREentry(this, false);
        }

        UserRealm getUserRealm() {
            return SIOUserRealm.this;
        }

        @Override
        public String getName() {
            return "Anonymous";
        }

        public boolean isAuthenticated() {
            return false;
        }

        public String getAuthenticatorURI() {
            return null;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

