/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.URIUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;

    private Connector() {
    }

    public static Connection open(String name) throws IOException {
        return Connector.open(name, 3);
    }

    public static Connection open(String name, int mode) throws IOException {
        return Connector.open(name, mode, false);
    }

    public static Connection open(String name, int mode, boolean timeouts) throws IOException {
        return Connector.openPrim(name, mode, timeouts);
    }

    private static Connection openPrim(String name, int mode, boolean timeouts) throws IllegalArgumentException, ConnectionNotFoundException, IOException, SecurityException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (!URIUtils.isAbsolute(name)) {
            throw new IllegalArgumentException();
        }
        if (!(name.startsWith("http:") || name.startsWith("https:") || name.startsWith("ssl:") || name.startsWith("socket:") || name.startsWith("file:"))) {
            throw new ConnectionNotFoundException();
        }
        int colon = name.indexOf(58);
        if (colon < 1) {
            throw new IllegalArgumentException("no ':' in URL");
        }
        String protocol = "";
        try {
            protocol = name.substring(0, colon);
            name = name.substring(colon + 1);
            protocol = protocol.replace('-', '_');
            byte currentAppId = NativeMethods.getCurrentAppId();
            short currentContext = NativeMethods.getCurrentContext();
            NativeMethods.switchContext(0, 0);
            Class<?> clazz = Class.forName("com.sun.midp.io.j2me." + protocol + ".Protocol");
            NativeMethods.switchContext(currentContext, currentAppId);
            ConnectionBaseInterface uc = (ConnectionBaseInterface)clazz.newInstance();
            Connector.storeConnection(uc);
            return uc.openPrim(name, mode, timeouts);
        }
        catch (InstantiationException x) {
            throw new IOException(x.toString());
        }
        catch (IllegalAccessException x) {
            throw new IOException(x.toString());
        }
        catch (ClassCastException x) {
            throw new IOException(x.toString());
        }
        catch (ClassNotFoundException x) {
            throw new ConnectionNotFoundException("The requested protocol '" + protocol + ":' does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataInputStream openDataInputStream(String name) throws IOException {
        InputConnection con = (InputConnection)Connector.open(name, 1);
        try {
            DataInputStream dataInputStream = con.openDataInputStream();
            return dataInputStream;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataOutputStream openDataOutputStream(String name) throws IOException {
        OutputConnection con = (OutputConnection)Connector.open(name, 2);
        try {
            DataOutputStream dataOutputStream = con.openDataOutputStream();
            return dataOutputStream;
        }
        finally {
            con.close();
        }
    }

    public static InputStream openInputStream(String name) throws IOException {
        return Connector.openDataInputStream(name);
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        return Connector.openDataOutputStream(name);
    }

    public static native void storeConnection(Object var0);
}

