/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import com.sun.javacard.ClassLoader;
import com.sun.javacard.cm.impl.ApplicationBundleImpl;
import com.sun.javacard.cm.impl.ApplicationImpl;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.spi.cardmgmt.Application;
import java.io.IOException;
import java.util.Iterator;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.io.TLSSecurityInfo;
import javax.microedition.io.SecureConnection;
import javax.microedition.io.SecurityInfo;
import javax.microedition.pki.Certificate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.security.ServletSSL;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.util.LazyList;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ContextHandlerCollection
extends HandlerCollection {
    private PathMap<LazyList<Handler>> contextMap;
    private Class<ContextHandler> contextClass = ContextHandler.class;

    public void mapContexts() {
        this.contextMap = null;
        LazyList<Handler> handlers = this.getHandlers();
        if (handlers != null && LazyList.size(handlers) > 0) {
            PathMap<LazyList<Handler>> contextMap = new PathMap<LazyList<Handler>>();
            LazyList<Handler> list = null;
            for (Handler element : handlers) {
                list = this.expandHandler(element, list, ContextHandler.class);
                if (list == null) continue;
                Iterator<Handler> iter = LazyList.iterator(list);
                while (iter.hasNext()) {
                    Handler handler = iter.next();
                    String contextPath = ((ContextHandler)handler).getContextPath();
                    if (contextPath == null || contextPath.indexOf(44) >= 0 || contextPath.startsWith("*")) {
                        throw new IllegalArgumentException("Illegal context spec:" + contextPath);
                    }
                    if (!contextPath.startsWith("/")) {
                        contextPath = '/' + contextPath;
                    }
                    if (contextPath.length() > 1) {
                        if (contextPath.endsWith("/")) {
                            contextPath = contextPath + "*";
                        } else if (!contextPath.endsWith("/*")) {
                            contextPath = contextPath + "/*";
                        }
                    }
                    LazyList<Handler> contexts = (LazyList<Handler>)contextMap.match(contextPath);
                    contexts = LazyList.add(contexts, element);
                    contextMap.put(contextPath, contexts);
                }
            }
            this.contextMap = contextMap;
        }
    }

    @Override
    public void setHandlers(LazyList<Handler> handlers) {
        this.contextMap = null;
        super.setHandlers(handlers);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.mapContexts();
        super.doStart();
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        LazyList<Handler> handlers = this.getHandlers();
        if (handlers == null || LazyList.size(handlers) == 0) {
            response.sendError(500);
            return;
        }
        Request base_request = HttpConnection.getCurrentConnection().getRequest();
        PathMap<LazyList<Handler>> map = this.contextMap;
        if (map != null && target != null && target.startsWith("/")) {
            LazyList<PathMap.Entry<LazyList<Handler>>> contexts = map.getLazyMatches(target);
            for (int i = 0; i < LazyList.size(contexts); ++i) {
                PathMap.Entry<LazyList<Handler>> entry = LazyList.get(contexts, i);
                LazyList<Handler> list = entry.getValue();
                for (int j = 0; j < LazyList.size(list); ++j) {
                    ContextHandler handler = (ContextHandler)LazyList.get(list, j);
                    if (target.equals(handler.getContextPath()) || target.startsWith(handler.getContextPath())) {
                        this.invokeContext(target, request, response, dispatch, handler);
                    }
                    if (!base_request.isHandled()) continue;
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeContext(String target, HttpServletRequest request, HttpServletResponse response, int dispatch, ContextHandler handler) throws IOException, ServletException {
        Request base_request = HttpConnection.getCurrentConnection().getRequest();
        base_request.extractParameters();
        ((Request)request).extractParameters();
        ContextHandler.Context context = handler.getContext();
        boolean new_context = false;
        ContextHandler.Context old_context = base_request.getContext();
        String old_context_path = null;
        String old_servlet_path = null;
        String old_path_info = null;
        ClassLoader old_classloader = null;
        String newContextPath = handler.getContextPath();
        ApplicationImpl app = (ApplicationImpl)Application.lookup(newContextPath);
        int firewallId = ((ApplicationBundleImpl)app.getApplicationGroup()).getFirewallId();
        int appId = app.getApplicationId();
        try {
            SecureConnection conn;
            if (old_context != context) {
                new_context = true;
            }
            old_context_path = base_request.getContextPath();
            old_servlet_path = base_request.getServletPath();
            old_path_info = base_request.getPathInfo();
            old_classloader = ClassLoader.getCurrentClassLoader();
            NativeMethods.transferOwnershiptoContext(target, firewallId, appId);
            NativeMethods.transferOwnershiptoContext(request, firewallId, appId);
            NativeMethods.transferOwnershiptoContext(response, firewallId, appId);
            if (request.isSecure() && (conn = (SecureConnection)HttpConnection.getCurrentConnection().getSocketConnection()) != null) {
                SecurityInfo secInfo = conn.getSecurityInfo();
                String cipher = secInfo.getCipherSuite();
                int keyLen = ServletSSL.deduceKeyLength(cipher);
                Certificate clientCert = null;
                String pskID = null;
                if (secInfo instanceof TLSSecurityInfo) {
                    TLSSecurityInfo tlsInfo = (TLSSecurityInfo)secInfo;
                    clientCert = tlsInfo.getClientCertificate();
                    pskID = tlsInfo.getPSKIdentity();
                    if (clientCert != null) {
                        request.setAttribute("javacardx.servlet.request.X509Certificate", clientCert);
                    }
                    if (pskID != null) {
                        request.setAttribute("javacardx.servlet.request.PSKIdentity", pskID);
                    }
                }
                request.setAttribute("javax.servlet.request.cipher_suite", cipher);
                request.setAttribute("javax.servlet.request.key_size", keyLen);
            }
            handler.handle(target, request, response, dispatch);
            if (!new_context) return;
        }
        catch (Throwable throwable) {
            if (!new_context) throw throwable;
            ClassLoader.setCurrentClassLoader(old_classloader);
            base_request.setContext(old_context);
            base_request.setContextPath(old_context_path);
            base_request.setServletPath(old_servlet_path);
            base_request.setPathInfo(old_path_info);
            throw throwable;
        }
        ClassLoader.setCurrentClassLoader(old_classloader);
        base_request.setContext(old_context);
        base_request.setContextPath(old_context_path);
        base_request.setServletPath(old_servlet_path);
        base_request.setPathInfo(old_path_info);
    }

    public Class<ContextHandler> getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(Class<ContextHandler> contextClass) {
        if (contextClass == null || !ContextHandler.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException();
        }
        this.contextClass = contextClass;
    }
}

