/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import com.sun.javacard.impl.NativeMethods;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.util.LazyList;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Constraint {
    public static final String BASIC_AUTH = "BASIC";
    public static final String FORM_AUTH = "FORM";
    public static final String DIGEST_AUTH = "DIGEST";
    public static final String[] JC_AUTH = new String[]{"JC-pin", "JC-fingerprint", "JC-bio-password", "JC-password"};
    public static final String CERT_AUTH = "CLIENT_CERT";
    public static final String CERT_AUTH2 = "CLIENT-CERT";
    public static final int DC_UNSET = -1;
    public static final int DC_NONE = 0;
    public static final int DC_INTEGRAL = 1;
    public static final int DC_CONFIDENTIAL = 2;
    public static final String NONE = "NONE";
    public static final String ANY_ROLE = "*";
    private String name;
    private LazyList<String> roles;
    private int dataConstraint = -1;
    private boolean anyRole = false;
    private boolean authenticate = false;

    public Constraint() {
    }

    public Constraint(String name, String role) {
        this.setName(name);
        this.roles = LazyList.array2List(new String[]{role});
    }

    public Constraint duplicate() {
        Constraint nc = new Constraint();
        nc.name = this.name;
        nc.roles = null;
        if (this.roles != null) {
            nc.roles = null;
            for (int i = 0; i < LazyList.size(this.roles); ++i) {
                nc.roles = LazyList.add(nc.roles, LazyList.get(this.roles, i));
            }
        }
        nc.dataConstraint = this.dataConstraint;
        nc.anyRole = this.anyRole;
        nc.authenticate = this.authenticate;
        return nc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoles(LazyList<String> roles) {
        this.roles = roles;
        this.anyRole = false;
        if (roles != null) {
            int i = LazyList.size(roles);
            while (!this.anyRole && i-- > 0) {
                this.anyRole = ANY_ROLE.equals(LazyList.get(roles, i));
            }
        }
    }

    public boolean isAnyRole() {
        return this.anyRole;
    }

    public LazyList<String> getRoles() {
        return this.roles;
    }

    public boolean hasRole(String role) {
        if (this.anyRole) {
            return true;
        }
        if (this.roles != null) {
            int i = LazyList.size(this.roles);
            while (i-- > 0) {
                if (!role.equals(LazyList.get(this.roles, i))) continue;
                return true;
            }
        }
        return false;
    }

    public void setAuthenticate(boolean authenticate) {
        this.authenticate = authenticate;
    }

    public boolean getAuthenticate() {
        return this.authenticate;
    }

    public boolean isForbidden() {
        return this.authenticate && !this.anyRole && (this.roles == null || LazyList.size(this.roles) == 0);
    }

    public void setDataConstraint(int c) {
        if (c < 0 || c > 2) {
            throw new IllegalArgumentException("Constraint out of range");
        }
        this.dataConstraint = c;
    }

    public int getDataConstraint() {
        return this.dataConstraint;
    }

    public boolean hasDataConstraint() {
        return this.dataConstraint >= 0;
    }

    public String toString() {
        return "SC{" + this.name + "," + (this.anyRole ? ANY_ROLE : (this.roles == null ? "-" : this.roles.toString())) + "," + (this.dataConstraint == -1 ? "DC_UNSET}" : (this.dataConstraint == 0 ? "NONE}" : (this.dataConstraint == 1 ? "INTEGRAL}" : "CONFIDENTIAL}")));
    }

    public static int getIndex(String[] a, String m) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(m)) continue;
            return i;
        }
        return -1;
    }

    static {
        NativeMethods.setGloballyAccessible(JC_AUTH);
    }
}

