/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import com.sun.javacard.Logger;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.security.JCAuthenticator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.UnavailableException;
import org.mortbay.jetty.WebServer;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.BasicAuthenticator;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.DigestAuthenticator;
import org.mortbay.jetty.security.FormAuthenticator;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.xml.XmlParser;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class WebXmlConfiguration
implements Configuration {
    protected WebAppContext context;
    protected LazyList<FilterHolder> filters;
    protected LazyList<FilterMapping> filterMappings;
    protected LazyList<ServletHolder> servlets;
    protected LazyList<ServletMapping> servletMappings;
    protected LazyList<String> welcomeFiles;
    protected LazyList<ConstraintMapping> constraintMappings;
    protected LazyList<EventListener> listeners;
    protected Hashtable<String, String> errorPages;
    protected boolean hasJSP;
    protected String jspServletName;
    protected boolean defaultWelcomeFileList;
    private final String DEFAULT_WEB_XML_STRING = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<web-app xmlns=\"http://java.sun.com/xml/ns/javaee\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\"\n         version=\"2.4\">\n    <description>\n        Default web.xml file. This file is applied to a Web application before it's own WEB_INF/web.xml file\n    </description>\n    <servlet>\n        <servlet-name>____container_default____</servlet-name>\n        <servlet-class>javacardx.servlet.http.DefaultServlet</servlet-class>\n        <init-param>\n            <param-name>acceptRanges</param-name>\n            <param-value>true</param-value>\n        </init-param>\n        <init-param>\n            <param-name>dirAllowed</param-name>\n            <param-value>false</param-value>\n        </init-param>\n        <init-param>\n            <param-name>redirectWelcome</param-name>\n            <param-value>true</param-value>\n        </init-param>\n        <init-param>\n            <param-name>maxCacheSize</param-name>\n            <param-value>2000000</param-value>\n        </init-param>\n        <init-param>\n            <param-name>maxCachedFileSize</param-name>\n            <param-value>254000</param-value>\n        </init-param>\n        <init-param>\n            <param-name>maxCachedFiles</param-name>\n            <param-value>1000</param-value>\n        </init-param>\n        <init-param>\n            <param-name>useFileMappedBuffer</param-name>\n            <param-value>true</param-value>\n        </init-param> \n        <load-on-startup>0</load-on-startup>\n    </servlet>\n    <servlet-mapping>\n        <servlet-name>____container_default____</servlet-name>\n        <url-pattern>/</url-pattern>\n    </servlet-mapping>\n    <session-config>\n        <session-timeout>30</session-timeout>\n    </session-config>\n    <welcome-file-list>\n        <welcome-file>index.html</welcome-file>\n        <welcome-file>index.htm</welcome-file>\n    </welcome-file-list>\n</web-app>\n";

    @Override
    public void setWebAppContext(WebAppContext context) {
        this.context = context;
    }

    @Override
    public WebAppContext getWebAppContext() {
        return this.context;
    }

    public void configureClassLoader() throws Exception {
    }

    @Override
    public void configureDefaults() throws Exception {
        if (this.context.isStarted()) {
            Logger.debug("Cannot configure webapp after it is started");
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<web-app xmlns=\"http://java.sun.com/xml/ns/javaee\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\"\n         version=\"2.4\">\n    <description>\n        Default web.xml file. This file is applied to a Web application before it's own WEB_INF/web.xml file\n    </description>\n    <servlet>\n        <servlet-name>____container_default____</servlet-name>\n        <servlet-class>javacardx.servlet.http.DefaultServlet</servlet-class>\n        <init-param>\n            <param-name>acceptRanges</param-name>\n            <param-value>true</param-value>\n        </init-param>\n        <init-param>\n            <param-name>dirAllowed</param-name>\n            <param-value>false</param-value>\n        </init-param>\n        <init-param>\n            <param-name>redirectWelcome</param-name>\n            <param-value>true</param-value>\n        </init-param>\n        <init-param>\n            <param-name>maxCacheSize</param-name>\n            <param-value>2000000</param-value>\n        </init-param>\n        <init-param>\n            <param-name>maxCachedFileSize</param-name>\n            <param-value>254000</param-value>\n        </init-param>\n        <init-param>\n            <param-name>maxCachedFiles</param-name>\n            <param-value>1000</param-value>\n        </init-param>\n        <init-param>\n            <param-name>useFileMappedBuffer</param-name>\n            <param-value>true</param-value>\n        </init-param> \n        <load-on-startup>0</load-on-startup>\n    </servlet>\n    <servlet-mapping>\n        <servlet-name>____container_default____</servlet-name>\n        <url-pattern>/</url-pattern>\n    </servlet-mapping>\n    <session-config>\n        <session-timeout>30</session-timeout>\n    </session-config>\n    <welcome-file-list>\n        <welcome-file>index.html</welcome-file>\n        <welcome-file>index.htm</welcome-file>\n    </welcome-file-list>\n</web-app>\n".getBytes());
        this.configure(bais);
        this.defaultWelcomeFileList = this.welcomeFiles != null;
    }

    @Override
    public void configureWebApp() throws Exception {
        if (this.context.isStarted()) {
            Logger.debug("Cannot configure webapp after it is started");
            return;
        }
        Resource webxml = Resource.newResource(this.findWebXml());
        if (webxml != null) {
            this.configure(webxml.getInputStream());
        }
    }

    protected String findWebXml() throws IOException {
        Resource web_inf = this.getWebAppContext().getWebInf();
        if (web_inf != null && web_inf.isDirectory()) {
            Resource web = web_inf.addPath("web.xml");
            if (web.exists()) {
                return web.getURL();
            }
            Logger.debug("No WEB-INF/web.xml in " + this.getWebAppContext().getWar() + ". Serving files and default/dynamic servlets only");
        }
        return null;
    }

    public void configure(InputStream webXml) throws Exception {
        XmlParser.Node config = null;
        config = new XmlParser().parse(webXml);
        this.initialize(config);
    }

    @Override
    public void deconfigureWebApp() throws Exception {
        ServletHandler servlet_handler = this.getWebAppContext().getServletHandler();
        servlet_handler.setFilters(null);
        servlet_handler.setFilterMappings(null);
        servlet_handler.setServlets(null);
        servlet_handler.setServletMappings(null);
        this.getWebAppContext().setEventListeners(null);
        this.getWebAppContext().setWelcomeFiles(null);
        if (this.getWebAppContext().getSecurityHandler() != null) {
            this.getWebAppContext().getSecurityHandler().setConstraintMappings(null);
        }
        if (this.getWebAppContext().getErrorHandler() instanceof WebAppContext.WebAppErrorHandler) {
            ((WebAppContext.WebAppErrorHandler)this.getWebAppContext().getErrorHandler()).setErrorPages(null);
        }
    }

    protected void initialize(XmlParser.Node config) throws ClassNotFoundException, UnavailableException {
        ServletHandler servlet_handler = this.getWebAppContext().getServletHandler();
        this.filters = servlet_handler.getFilters();
        this.filterMappings = servlet_handler.getFilterMappings();
        this.servlets = servlet_handler.getServlets();
        this.servletMappings = servlet_handler.getServletMappings();
        this.listeners = this.getWebAppContext().getEventListeners();
        this.welcomeFiles = this.getWebAppContext().getWelcomeFiles();
        this.constraintMappings = this.getWebAppContext().getSecurityHandler().getConstraintMappings();
        this.errorPages = this.getWebAppContext().getErrorHandler() instanceof WebAppContext.WebAppErrorHandler ? ((WebAppContext.WebAppErrorHandler)this.getWebAppContext().getErrorHandler()).getErrorPages() : null;
        Iterator<Object> iter = config.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            try {
                Object o = iter.next();
                if (!(o instanceof XmlParser.Node)) continue;
                node = (XmlParser.Node)o;
                String name = node.getTag();
                this.initWebXmlElement(name, node);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.debug("Configuration problem at " + node, e);
                throw new UnavailableException("Configuration problem");
            }
        }
        servlet_handler.setFilters(this.filters);
        servlet_handler.setFilterMappings(this.filterMappings);
        servlet_handler.setServlets(this.servlets);
        servlet_handler.setServletMappings(this.servletMappings);
        this.getWebAppContext().setEventListeners(this.listeners);
        this.getWebAppContext().setWelcomeFiles(this.welcomeFiles);
        this.getWebAppContext().getSecurityHandler().setConstraintMappings(this.constraintMappings);
        if (this.errorPages != null && this.getWebAppContext().getErrorHandler() instanceof WebAppContext.WebAppErrorHandler) {
            ((WebAppContext.WebAppErrorHandler)this.getWebAppContext().getErrorHandler()).setErrorPages(this.errorPages);
        }
    }

    protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
        if ("display-name".equals(element)) {
            this.initDisplayName(node);
        } else if (!"description".equals(element)) {
            if ("context-param".equals(element)) {
                this.initContextParam(node);
            } else if ("servlet".equals(element)) {
                this.initServlet(node);
            } else if ("servlet-mapping".equals(element)) {
                this.initServletMapping(node);
            } else if ("session-config".equals(element)) {
                this.initSessionConfig(node);
            } else if ("mime-mapping".equals(element)) {
                this.initMimeConfig(node);
            } else if ("welcome-file-list".equals(element)) {
                this.initWelcomeFileList(node);
            } else if ("locale-encoding-mapping-list".equals(element)) {
                this.initLocaleEncodingList(node);
            } else if ("error-page".equals(element)) {
                this.initErrorPage(node);
            } else if ("taglib".equals(element)) {
                this.initTagLib(node);
            } else if ("jsp-config".equals(element)) {
                Logger.debug("No implementation: " + node);
            } else if ("resource-ref".equals(element)) {
                Logger.debug("No implementation: " + node);
            } else if ("security-constraint".equals(element)) {
                this.initSecurityConstraint(node);
            } else if ("login-config".equals(element)) {
                this.initLoginConfig(node);
            } else if ("security-role".equals(element)) {
                this.initSecurityRole(node);
            } else if ("filter".equals(element)) {
                this.initFilter(node);
            } else if ("filter-mapping".equals(element)) {
                this.initFilterMapping(node);
            } else if ("listener".equals(element)) {
                this.initListener(node);
            } else if ("distributable".equals(element)) {
                this.initDistributable(node);
            } else {
                Logger.debug(this.getClass(), "Element {} not handled in {}" + element);
                Logger.debug(node.toString());
            }
        }
    }

    protected void initDisplayName(XmlParser.Node node) {
        this.getWebAppContext().setDisplayName(node.toString(false, true));
    }

    protected void initContextParam(XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        Logger.debug("ContextParam: " + name + "=" + value);
        if (this.getWebAppContext().getInitParams().get(name) == null) {
            this.getWebAppContext().getInitParams().put(name, value);
        }
    }

    protected void initFilter(XmlParser.Node node) {
        FilterHolder holder = this.newFilterHolder();
        holder.setName(node.getString("filter-name", false, true));
        holder.setClassName(node.getString("filter-class", false, true));
        Iterator<XmlParser.Node> iter = node.iterator("init-param");
        while (iter.hasNext()) {
            XmlParser.Node paramNode = iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.setInitParameter(pname, pvalue);
        }
        this.filters = LazyList.add(this.filters, holder);
    }

    protected void initFilterMapping(XmlParser.Node node) {
        String filter_name = node.getString("filter-name", false, true);
        FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(filter_name);
        Vector<String> paths = new Vector<String>();
        Iterator<XmlParser.Node> iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = iter.next().toString(false, true);
            paths.addElement(p);
        }
        Object[] tmpPathSpecs = new String[paths.size()];
        paths.copyInto(tmpPathSpecs);
        mapping.setPathSpecs((String[])tmpPathSpecs);
        Vector<String> names = new Vector<String>();
        iter = node.iterator("servlet-name");
        while (iter.hasNext()) {
            String n = iter.next().toString(false, true);
            names.addElement(n);
        }
        Object[] tmpServletNames = new String[names.size()];
        if (names.size() > 0) {
            names.copyInto(tmpServletNames);
        }
        mapping.setServletNames((String[])tmpServletNames);
        int dispatcher = 0;
        iter = node.iterator("dispatcher");
        while (iter.hasNext()) {
            String d = iter.next().toString(false, true);
            dispatcher |= Dispatcher.type(d);
        }
        mapping.setDispatches(dispatcher);
        this.filterMappings = LazyList.add(this.filterMappings, mapping);
    }

    protected void initServlet(XmlParser.Node node) throws IOException {
        String roleName;
        String id = node.getAttribute("id");
        String servlet_name = node.getString("servlet-name", false, true);
        String servlet_class = node.getString("servlet-class", false, true);
        ServletHolder holder = this.newServletHolder();
        holder.setName(servlet_name);
        Iterator<XmlParser.Node> iParamsIter = node.iterator("init-param");
        while (iParamsIter.hasNext()) {
            XmlParser.Node paramNode = iParamsIter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.setInitParameter(pname, pvalue);
        }
        if (id != null && id.equals("jsp")) {
            this.jspServletName = servlet_name;
            try {
                Loader.loadClass(this.getClass(), servlet_class, this.getWebAppContext().getClassLoader());
                this.hasJSP = true;
            }
            catch (ClassNotFoundException e) {
                Logger.debug(servlet_class + " NO JSP Support for {}, did not find {}" + this.context.getContextPath());
                this.hasJSP = false;
                servlet_class = "org.mortbay.servlet.NoJspServlet";
            }
            if (holder.getInitParameter("scratchdir") == null) {
                FileConnection tmp = this.getWebAppContext().getTempDirectory();
                FileConnection scratch = new FileConnection(tmp, "jsp");
                if (!scratch.exists()) {
                    scratch.mkdirs();
                }
                holder.setInitParameter("scratchdir", scratch.getAbsolutePath());
            }
        }
        holder.setClassName(servlet_class);
        String jsp_file = node.getString("jsp-file", false, true);
        holder.setForcedPath(jsp_file);
        XmlParser.Node startup = node.get("load-on-startup");
        if (startup != null) {
            String s = startup.toString(false, true).toLowerCase();
            if (s.startsWith("t")) {
                Logger.debug("Deprecated boolean load-on-startup.  Please use integer");
                holder.setInitOrder(1);
            } else {
                int order = 0;
                try {
                    if (s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    Logger.debug("Cannot parse load-on-startup " + s + ". Please use integer");
                    Logger.debug(e);
                }
                holder.setInitOrder(order);
            }
        }
        Iterator<XmlParser.Node> sRefsIter = node.iterator("security-role-ref");
        while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                Logger.debug("link role " + roleName + " to " + roleLink + " for " + this);
                holder.setUserRoleLink(roleName, roleLink);
                continue;
            }
            Logger.debug("Ignored invalid security-role-ref element: servlet-name=" + holder.getName() + ", " + securityRef);
        }
        XmlParser.Node run_as = node.get("run-as");
        if (run_as != null && (roleName = run_as.getString("role-name", false, true)) != null) {
            holder.setRunAs(roleName);
        }
        this.servlets = LazyList.add(this.servlets, holder);
    }

    protected void initServletMapping(XmlParser.Node node) {
        String servlet_name = node.getString("servlet-name", false, true);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName(servlet_name);
        Vector<String> paths = new Vector<String>();
        Iterator<XmlParser.Node> iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = iter.next().toString(false, true);
            paths.addElement(p);
        }
        Object[] tmpPathSpecs = new String[paths.size()];
        paths.copyInto(tmpPathSpecs);
        mapping.setPathSpecs((String[])tmpPathSpecs);
        this.servletMappings = LazyList.add(this.servletMappings, mapping);
    }

    protected void initListener(XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        EventListener listener = null;
        try {
            Class<?> listenerClass = this.getWebAppContext().loadClass(className);
            if (!EventListener.class.isAssignableFrom(listenerClass)) {
                Logger.debug("Not an EventListener: " + listener);
                return;
            }
            listener = (EventListener)listenerClass.newInstance();
            this.listeners = LazyList.add(this.listeners, listener);
        }
        catch (Exception e) {
            Logger.debug("Could not instantiate listener " + className, e);
            return;
        }
    }

    protected void initDistributable(XmlParser.Node node) {
        WebAppContext wac = this.getWebAppContext();
        if (!wac.isDistributable()) {
            wac.setDistributable(true);
        }
    }

    protected void initSessionConfig(XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            this.getWebAppContext().getSessionHandler().getSessionManager().setMaxInactiveInterval(timeout * 60);
        }
    }

    protected void initMimeConfig(XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        this.getWebAppContext().getMimeTypes().addMimeMapping(extension, mimeType);
    }

    protected void initWelcomeFileList(XmlParser.Node node) {
        if (this.defaultWelcomeFileList) {
            this.welcomeFiles = null;
        }
        this.defaultWelcomeFileList = false;
        Iterator<XmlParser.Node> iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = iter.next();
            String welcome = indexNode.toString(false, true);
            this.welcomeFiles = LazyList.add(this.welcomeFiles, welcome);
        }
        this.welcomeFiles = LazyList.add(this.welcomeFiles, "index.html");
        this.welcomeFiles = LazyList.add(this.welcomeFiles, "index.htm");
    }

    protected void initLocaleEncodingList(XmlParser.Node node) {
        Iterator<XmlParser.Node> iter = node.iterator("locale-encoding-mapping");
        while (iter.hasNext()) {
            XmlParser.Node mapping = iter.next();
            String locale = mapping.getString("locale", false, true);
            String encoding = mapping.getString("encoding", false, true);
            this.getWebAppContext().addLocaleEncoding(locale, encoding);
        }
    }

    protected void initErrorPage(XmlParser.Node node) {
        String error = node.getString("error-code", false, true);
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
        }
        String location = node.getString("location", false, true);
        if (this.errorPages == null) {
            this.errorPages = new Hashtable();
        }
        this.errorPages.put(error, location);
    }

    protected void initTagLib(XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
        this.getWebAppContext().setResourceAlias(uri, location);
    }

    protected void initSecurityConstraint(XmlParser.Node node) {
        XmlParser.Node data;
        Constraint scBase = new Constraint();
        XmlParser.Node auths = node.get("auth-constraint");
        if (auths != null) {
            scBase.setAuthenticate(true);
            Iterator<XmlParser.Node> iter = auths.iterator("role-name");
            LazyList<String> roles = null;
            while (iter.hasNext()) {
                String role = iter.next().toString(false, true);
                roles = LazyList.add(roles, role);
            }
            scBase.setRoles(roles);
        }
        if ((data = node.get("user-data-constraint")) != null) {
            String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
            if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                scBase.setDataConstraint(0);
            } else if ("INTEGRAL".equals(guarantee)) {
                scBase.setDataConstraint(1);
            } else if ("CONFIDENTIAL".equals(guarantee)) {
                scBase.setDataConstraint(2);
            } else {
                Logger.debug("Unknown user-data-constraint:" + guarantee);
                scBase.setDataConstraint(2);
            }
        }
        Iterator<XmlParser.Node> iter = node.iterator("web-resource-collection");
        while (iter.hasNext()) {
            XmlParser.Node collection = iter.next();
            String name = collection.getString("web-resource-name", false, true);
            Constraint sc = scBase.duplicate();
            sc.setName(name);
            Iterator<XmlParser.Node> iter2 = collection.iterator("url-pattern");
            while (iter2.hasNext()) {
                String url = iter2.next().toString(false, true);
                Iterator<XmlParser.Node> iter3 = collection.iterator("http-method");
                if (iter3.hasNext()) {
                    while (iter3.hasNext()) {
                        String method = iter3.next().toString(false, true);
                        ConstraintMapping mapping = new ConstraintMapping();
                        mapping.setMethod(method);
                        mapping.setPathSpec(url);
                        mapping.setConstraint(sc);
                        this.constraintMappings = LazyList.add(this.constraintMappings, mapping);
                    }
                    continue;
                }
                ConstraintMapping mapping = new ConstraintMapping();
                mapping.setPathSpec(url);
                mapping.setConstraint(sc);
                this.constraintMappings = LazyList.add(this.constraintMappings, mapping);
            }
        }
    }

    protected void initLoginConfig(XmlParser.Node node) {
        XmlParser.Node formConfig;
        XmlParser.Node name;
        XmlParser.Node method = node.get("auth-method");
        FormAuthenticator _formAuthenticator = null;
        JCAuthenticator jcAuthenticator = null;
        if (method != null) {
            Authenticator authenticator = null;
            String m = method.toString(false, true);
            Logger.debug("m is= " + m);
            if ("FORM".equals(m)) {
                authenticator = _formAuthenticator = new FormAuthenticator();
            } else if ("BASIC".equals(m)) {
                authenticator = new BasicAuthenticator();
            } else if ("DIGEST".equals(m)) {
                authenticator = new DigestAuthenticator();
            } else if (Constraint.getIndex(Constraint.JC_AUTH, m) != -1) {
                jcAuthenticator = new JCAuthenticator(m);
                authenticator = jcAuthenticator;
            } else {
                Logger.debug("UNKNOWN AUTH METHOD: " + m);
            }
            this.getWebAppContext().getSecurityHandler().setAuthenticator(authenticator);
        }
        if ((name = node.get("realm-name")) != null) {
            String realm_name = name.toString(false, true);
            LazyList<UserRealm> realms = WebServer.getWebServer().getUserRealms();
            UserRealm realm = this.getWebAppContext().getSecurityHandler().getUserRealm();
            if (realm == null) {
                realm = WebServer.getWebServer().getUserRealmForName(realm_name);
            }
            if (realm == null) {
                String msg = "Unknown realm: " + realm_name;
                Logger.debug(msg);
            } else {
                this.getWebAppContext().getSecurityHandler().setUserRealm(realm);
            }
        }
        if ((formConfig = node.get("form-login-config")) != null) {
            String ep;
            XmlParser.Node errorPage;
            XmlParser.Node loginPage;
            if (_formAuthenticator != null) {
                loginPage = formConfig.get("form-login-page");
                if (loginPage != null) {
                    _formAuthenticator.setLoginPage(loginPage.toString(false, true));
                }
                if ((errorPage = formConfig.get("form-error-page")) != null) {
                    ep = errorPage.toString(false, true);
                    _formAuthenticator.setErrorPage(ep);
                }
            } else if (jcAuthenticator != null) {
                loginPage = formConfig.get("form-login-page");
                if (loginPage != null) {
                    jcAuthenticator.setLoginPage(loginPage.toString(false, true));
                }
                if ((errorPage = formConfig.get("form-error-page")) != null) {
                    ep = errorPage.toString(false, true);
                    jcAuthenticator.setErrorPage(ep);
                }
            } else {
                Logger.debug("FORM Authentication miss-configured");
            }
        }
    }

    protected void initSecurityRole(XmlParser.Node node) {
    }

    protected ServletHolder newServletHolder() {
        return new ServletHolder();
    }

    protected FilterHolder newFilterHolder() {
        return new FilterHolder();
    }
}

