/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.Writer;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class MultiPartWriter
extends Writer {
    private static final String CRLF = "\r\n";
    private static final String DASHDASH = "--";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final String MULTIPART_X_MIXED_REPLACE = "multipart/x-mixed-replace";
    private String boundary;
    private boolean inPart = false;
    private final Writer out;

    public MultiPartWriter(Writer out) {
        this.out = out;
        this.boundary = "jetty" + System.identityHashCode(this) + Long.toString(System.currentTimeMillis(), 36);
        this.inPart = false;
    }

    @Override
    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(CRLF);
        }
        this.out.write(DASHDASH);
        this.out.write(this.boundary);
        this.out.write(DASHDASH);
        this.out.write(CRLF);
        this.inPart = false;
        this.out.close();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public void startPart(String contentType) throws IOException {
        if (this.inPart) {
            this.out.write(CRLF);
        }
        this.out.write(DASHDASH);
        this.out.write(this.boundary);
        this.out.write(CRLF);
        this.out.write("Content-Type: ");
        this.out.write(contentType);
        this.out.write(CRLF);
        this.out.write(CRLF);
        this.inPart = true;
    }

    public void endPart() throws IOException {
        if (this.inPart) {
            this.out.write(CRLF);
        }
        this.inPart = false;
    }

    public void startPart(String contentType, String[] headers) throws IOException {
        if (this.inPart) {
            this.out.write(CRLF);
        }
        this.out.write(DASHDASH);
        this.out.write(this.boundary);
        this.out.write(CRLF);
        this.out.write("Content-Type: ");
        this.out.write(contentType);
        this.out.write(CRLF);
        for (int i = 0; headers != null && i < headers.length; ++i) {
            this.out.write(headers[i]);
            this.out.write(CRLF);
        }
        this.out.write(CRLF);
        this.inPart = true;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(char[] ac, int i, int j) throws IOException {
        this.out.write(ac, i, j);
    }
}

