/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.ConstantPool;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.SortableVector;
import com.sun.javacard.jcasm.SymbolTable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCPackage {
    protected String inputSpec;
    protected PackageIdentifier packageIdentifier;
    protected String name;
    protected int line;
    protected Vector importVector;
    protected Vector appletVector;
    protected ConstantPool constantPool;
    protected SortableVector classVector;
    public Hashtable symbolTable;
    protected boolean usesIntegers;
    protected Hashtable descriptorTable;

    public JCPackage(String name, PackageIdentifier packageId, int line) {
        Assert.PreCondition(name != null, "name != null");
        Assert.PreCondition(packageId != null, "packageId != null");
        this.name = name;
        this.packageIdentifier = packageId;
        this.line = line;
        this.classVector = new SortableVector();
        this.importVector = new Vector();
        this.appletVector = new Vector();
        this.constantPool = new ConstantPool(this);
        this.symbolTable = new Hashtable();
        this.descriptorTable = new Hashtable();
    }

    protected void addApplet(AppletDeclarator applet) {
        this.appletVector.addElement(applet);
    }

    public void addClass(JCClass jcClass) {
        Assert.PreCondition(jcClass != null, "jcClass != null");
        String name = jcClass.getName();
        if (this.symbolTable.containsKey(name)) {
            Object[] arguments = new Object[]{name, this.name};
            Msg.error("package.0", arguments);
            return;
        }
        ClassIdentifier cid = jcClass.getClassIdentifier();
        if (this.symbolTable.containsKey(cid)) {
            Object[] arguments = new Object[]{new Integer(cid.getClassToken()), this.name};
            Msg.error("package.1", arguments);
            return;
        }
        jcClass.sortFields();
        this.symbolTable.put(name, jcClass);
        this.symbolTable.put(cid, jcClass);
        this.classVector.addElement(jcClass);
    }

    public void addConstantPoolEntry(Info info) {
        this.constantPool.addConstantPoolEntry(info);
    }

    public void addDescriptor(String name, int packageToken, int classToken) {
        this.descriptorTable.put(name, new Descriptor(name, packageToken, classToken));
    }

    protected void addImport(PackageIdentifier importPackage) {
        this.importVector.addElement(importPackage);
    }

    public int appletCount() {
        return this.appletVector.size();
    }

    public Enumeration appletElements() {
        return this.appletVector.elements();
    }

    public Enumeration classElements() {
        return this.classVector.elements();
    }

    public Enumeration constantPoolElements() {
        return this.constantPool.elements();
    }

    public byte[] getAppletTableByteArray(byte pkgSlot) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        int i = 0;
        while (i < this.appletVector.size()) {
            try {
                dos.writeByte(pkgSlot);
                AppletDeclarator ad = (AppletDeclarator)this.appletVector.elementAt(i);
                byte[] adByteArray = ad.toByteArray();
                if (adByteArray == null) {
                    return null;
                }
                dos.write(adByteArray);
                dos.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            ++i;
        }
        return bos.toByteArray();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Info getConstantPoolEntry(int i) {
        return this.constantPool.getConstantPoolEntry(i);
    }

    public int getDescriptorClassToken(String name) {
        Descriptor desc = (Descriptor)this.descriptorTable.get(name);
        if (desc != null) {
            return desc.getClassToken();
        }
        JCClass c = (JCClass)this.symbolTable.get(String.valueOf(this.name) + "/" + name);
        if (c == null) {
            c = (JCClass)this.symbolTable.get(name);
        }
        if (c != null) {
            int addr = c.getRelocAddr();
            return addr & 0xFF;
        }
        Object[] arguments = new Object[]{name};
        Msg.error("package.4", arguments);
        return 0;
    }

    public int getDescriptorPackageToken(String name) {
        Descriptor desc = (Descriptor)this.descriptorTable.get(name);
        if (desc != null) {
            return desc.getPackageToken() | 0x80;
        }
        JCClass c = (JCClass)this.symbolTable.get(String.valueOf(this.name) + "/" + name);
        if (c == null) {
            c = (JCClass)this.symbolTable.get(name);
        }
        if (c != null) {
            int addr = c.getRelocAddr();
            return addr >> 8 & 0xFF;
        }
        Object[] arguments = new Object[]{name};
        Msg.error("package.3", arguments);
        return 0;
    }

    public PackageIdentifier getIdentifier() {
        return this.packageIdentifier;
    }

    public PackageIdentifier getIdentifier(int token) {
        Assert.PreCondition(token >= 0, "token >= 0");
        if (token >= this.importVector.size()) {
            return null;
        }
        return (PackageIdentifier)this.importVector.elementAt(token);
    }

    public String getName() {
        return this.name;
    }

    public int getPackageToken(PackageIdentifier p) {
        int size = this.importVector.size();
        int i = 0;
        while (i < size) {
            PackageIdentifier match = (PackageIdentifier)this.importVector.elementAt(i);
            if (p.equals(match)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Enumeration importElements() {
        return this.importVector.elements();
    }

    public void resolveAppletInstallAddrs(SymbolTable mst) {
        int i = 0;
        while (i < this.appletVector.size()) {
            AppletDeclarator ad = (AppletDeclarator)this.appletVector.elementAt(i);
            String instName = ad.getInstallMethodName();
            ad.setInstallMethodAddr((short)((JCMethod)mst.get(instName)).getRelocAddr());
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(".package " + this.name + " {" + Msg.eol);
        sb.append(".version " + this.packageIdentifier.getMajorVersion() + "." + this.packageIdentifier.getMinorVersion() + " ;" + Msg.eol);
        sb.append(".aid " + this.packageIdentifier.getAid() + " ;" + Msg.eol);
        sb.append(".imports {" + Msg.eol);
        Enumeration e = this.importVector.elements();
        while (e.hasMoreElements()) {
            PackageIdentifier p = (PackageIdentifier)e.nextElement();
            sb.append(String.valueOf(String.valueOf(p)) + ";" + Msg.eol);
        }
        sb.append("}" + Msg.eol);
        sb.append(String.valueOf(this.constantPool.toString()) + Msg.eol);
        Enumeration e2 = this.classVector.elements();
        while (e2.hasMoreElements()) {
            JCClass c = (JCClass)e2.nextElement();
            sb.append(c);
        }
        sb.append("}" + Msg.eol);
        return sb.toString();
    }

    public boolean usesIntegers() {
        return this.usesIntegers;
    }

    protected void usesIntegers(boolean value) {
        if (!this.usesIntegers) {
            this.usesIntegers = value;
        }
    }

    static class Descriptor {
        private int packageToken;
        private int classToken;

        Descriptor(String name, int packageToken, int classToken) {
            this.packageToken = packageToken;
            this.classToken = classToken;
        }

        int getClassToken() {
            return this.classToken;
        }

        int getPackageToken() {
            return this.packageToken;
        }
    }
}

