/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DirectoryComponent
extends Component {
    protected final int basicCount = 11;
    protected int customCount = 0;
    protected Component[] component;
    protected byte[] debugCompInfo;

    DirectoryComponent(JCPackage p, HeaderComponent header, AppletComponent applet, ImportComponent imports, ConstantPoolComponent constantPool, ClassComponent classes, MethodComponent methods, StaticFieldComponent staticFields, ReferenceLocationComponent referenceLocation, ExportComponent export, DescriptorComponent descriptor) {
        super(p);
        if (header == null || imports == null || constantPool == null || classes == null || methods == null || staticFields == null || referenceLocation == null) {
            throw new IllegalArgumentException();
        }
        this.component = new Component[12];
        this.component[1] = header;
        this.component[2] = this;
        this.component[3] = applet;
        this.component[4] = imports;
        this.component[5] = constantPool;
        this.component[6] = classes;
        this.component[7] = methods;
        this.component[8] = staticFields;
        this.component[9] = referenceLocation;
        this.component[10] = export;
        this.component[11] = descriptor;
    }

    public void addDebugComponent(DebugComponent dc) {
        if (dc != null) {
            this.debugCompInfo = dc.getDebugCompInfo();
            ++this.customCount;
        }
    }

    public int dataSize() {
        if (this.debugCompInfo != null) {
            return 31 + this.debugCompInfo.length;
        }
        return 31;
    }

    protected byte[] getCustomComponentInfo() {
        return this.debugCompInfo;
    }

    protected byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            int i = 1;
            while (i < this.component.length) {
                if (this.component[i] == null) {
                    dos.writeShort(0);
                } else {
                    dos.writeShort(this.component[i].dataSize());
                }
                ++i;
            }
            dos.writeShort(((StaticFieldComponent)this.component[8]).getImageSize());
            dos.writeShort(((StaticFieldComponent)this.component[8]).getArrayInitCount());
            dos.writeShort(((StaticFieldComponent)this.component[8]).getArrayInitSize());
            dos.writeByte(((ImportComponent)this.component[4]).count());
            if (this.component[3] != null) {
                dos.writeByte(((AppletComponent)this.component[3]).count());
            } else {
                dos.writeByte(0);
            }
            dos.writeByte(this.customCount);
            if (this.debugCompInfo != null) {
                dos.write(this.getCustomComponentInfo());
            }
            dos.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
        return bos.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("Component Sizes:");
        int i = 1;
        while (i < this.component.length) {
            if (this.component[i] == null) {
                sb.append(" 0");
            } else {
                sb.append(" " + this.component[i].dataSize());
            }
            ++i;
        }
        sb.append(Msg.eol);
        StaticFieldComponent staticField = (StaticFieldComponent)this.component[8];
        sb.append("Image Size: " + staticField.getImageSize() + Msg.eol);
        sb.append("Array Init Count: " + staticField.getArrayInitCount() + Msg.eol);
        sb.append("Array Init Size: " + staticField.getArrayInitSize() + Msg.eol);
        sb.append("Import Count: " + ((ImportComponent)this.component[4]).count() + Msg.eol);
        AppletComponent applet = (AppletComponent)this.component[3];
        sb.append("Applet Count: " + (applet != null ? applet.count() : 0) + Msg.eol);
        sb.append("Custom Count: " + this.customCount + Msg.eol);
        return sb.toString();
    }
}

