/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cli;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

public class JcBasicParser
extends BasicParser {
    private static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/cli/messages");
    private Options options;

    public CommandLine parse(Options opts, String[] arguments, boolean stopAtNonOption) throws ParseException {
        this.options = opts;
        List<String> tokenList = Arrays.asList(this.flatten(opts, arguments, stopAtNonOption));
        ListIterator<String> iterator = tokenList.listIterator();
        while (iterator.hasNext()) {
            String t = iterator.next();
            if (!t.startsWith("-") || this.options.hasOption(t)) continue;
            throw new UnrecognizedOptionException(MessageFormat.format(messages.getString("option.unrecognized"), t));
        }
        return super.parse(opts, arguments, stopAtNonOption);
    }

    public void processArgs(Option opt, ListIterator iter) throws ParseException {
        while (iter.hasNext()) {
            String var = (String)iter.next();
            if (this.options.hasOption(var) && var.startsWith("-")) {
                iter.previous();
                break;
            }
            if (opt.addValue(var)) continue;
            iter.previous();
            break;
        }
        if (opt.getValues() == null && !opt.hasOptionalArg()) {
            throw new MissingArgumentException(MessageFormat.format(messages.getString("argument.missed"), opt.getOpt(), opt.getLongOpt()));
        }
    }
}

