/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstantInfo;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Utf8;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;

public class EfConstant_Package
extends EfConstantInfo {
    public short flags;
    int nameIndex;
    public short minorVersion;
    public short majorVersion;
    short AID_length;
    public byte[] AID;

    EfConstant_Package(ExportFile ef) {
        super(ef);
    }

    @Override
    void read() throws IOException {
        this.flags = (short)this.ef.in.readUnsignedByte();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.minorVersion = (short)this.ef.in.readUnsignedByte();
        this.majorVersion = (short)this.ef.in.readUnsignedByte();
        this.AID_length = (short)this.ef.in.readUnsignedByte();
        this.AID = new byte[this.AID_length];
        this.ef.in.read(this.AID);
    }

    @Override
    void validate() {
        this.ef.checkUtf8Index(this.nameIndex);
        String pkgname = ((EfConstant_Utf8)this.ef.constantPool[this.nameIndex]).contents;
        if (!EfNames.validPackageName(pkgname)) {
            throw new VerifierError("EfConstant_Package.1", pkgname);
        }
        if (this.AID_length < 5 || this.AID_length > 16) {
            throw new VerifierError("EfConstant_Package.2", this.AID_length);
        }
        if ((this.flags & 0xFFFFFFFE) != 0) {
            throw new VerifierError("EfConstant_Package.3", this.flags);
        }
    }

    public String getPkgName() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.nameIndex]).contents;
    }

    void compareTo(EfConstant_Package pkg) {
        this.compareCommon(pkg);
    }

    void checkEquality(EfConstant_Package pkg) {
        if (this.flags != pkg.flags) {
            throw new VerifierError("RevisionError.36");
        }
        this.compareCommon(pkg);
    }

    void compareCommon(EfConstant_Package pkg) {
        if (this.AID_length != pkg.AID_length) {
            throw new VerifierError("RevisionError.1");
        }
        for (int i = 0; i < this.AID_length; ++i) {
            if (this.AID[i] == pkg.AID[i]) continue;
            throw new VerifierError("RevisionError.1");
        }
    }
}

