/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.util.Diagnostics;
import java.util.Vector;

public abstract class PackageItem {
    private Vector<String> errors = new Vector();
    private Vector<String> warnings = new Vector();
    protected boolean proceed = true;
    private PackageItem parent;
    protected Vector<PackageItem> items = new Vector();

    public PackageItem() {
        this(null);
    }

    public PackageItem(PackageItem parent) {
        this.parent = parent;
    }

    public abstract String getItemDisplayName();

    public abstract void initialize();

    public final void process() {
        if (this.canProceed()) {
            this.processInternal();
        }
    }

    public final boolean canProceed() {
        return this.proceed;
    }

    protected abstract void processInternal();

    public final Vector<String> getErrors() {
        return this.errors;
    }

    public final Vector<String> getWarnings() {
        return this.warnings;
    }

    public final Vector<? extends PackageItem> getItems() {
        return this.items;
    }

    public final void addError(ErrorKey key, Object ... params) {
        this.errors.addElement(key.getMessage(params));
    }

    public final void addWarning(ErrorKey key, Object ... params) {
        this.warnings.addElement(key.getMessage(params));
    }

    public final void addItem(PackageItem item) {
        item.setParent(this);
        this.items.addElement(item);
    }

    public final void gatherDiagnostics(Diagnostics diagnostics) {
        if (this.warnings.size() > 0) {
            diagnostics.addWarnings(this.getItemDisplayName().trim(), this.warnings);
        }
        if (this.errors.size() > 0) {
            diagnostics.addErrors(this.getItemDisplayName().trim(), this.errors);
        }
        for (PackageItem item : this.items) {
            item.gatherDiagnostics(diagnostics);
        }
    }

    public final boolean isOk() {
        return this.isOk(true);
    }

    public final boolean isOk(boolean recursive) {
        boolean ok = true;
        boolean bl = ok = this.errors.size() <= 0;
        if (recursive && ok) {
            for (PackageItem item : this.items) {
                ok = item.isOk(recursive);
                if (ok) continue;
                return false;
            }
        }
        return ok;
    }

    public final int countErrors() {
        int ec = this.errors.size();
        for (PackageItem item : this.items) {
            ec += item.countErrors();
        }
        return ec;
    }

    public final int countWarnings() {
        int ec = this.warnings.size();
        for (PackageItem item : this.items) {
            ec += item.countWarnings();
        }
        return ec;
    }

    public PackageItem getParent() {
        return this.parent;
    }

    public void setParent(PackageItem parent) {
        this.parent = parent;
    }
}

