/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrLookupSwitch;
import com.sun.javacard.classfile.instructions.JInstrTableSwitch;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.instructions.JcInstrLookupSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrTableSwitch;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrSwitchConverter
extends InstructionConverter {
    public InstrSwitchConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    @Override
    public JcInstruction convert() throws Exception {
        int java_opcode = this.java_instr.getOpcode();
        if (java_opcode == 170) {
            int jc_opcode;
            JInstrTableSwitch java_switch_instr = (JInstrTableSwitch)this.java_instr;
            int low_value = java_switch_instr.getLowValue();
            int high_value = java_switch_instr.getHighValue();
            OperandStackEntry index_entry = this.operand_stack.pop();
            if (index_entry.hasOverflowPotential()) {
                if (this.method_converter.isIntSupported()) {
                    index_entry.rollBack();
                } else {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.21", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
            }
            if ((jc_opcode = index_entry.getType() == 3 || DataType.getType(low_value) == 3 || DataType.getType(high_value) == 3 ? 116 : 115) == 116) {
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.8", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.8", this.method_converter.getClassName().replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                if (index_entry.getType() != 3) {
                    index_entry.rollBack();
                }
            }
            int default_label = this.getBranchLabel(java_switch_instr.getDefaultBranchOffset());
            int[] branch_offsets = java_switch_instr.getBranchOffsets();
            int[] branch_labels = new int[branch_offsets.length];
            for (int i = 0; i < branch_offsets.length; ++i) {
                branch_labels[i] = this.getBranchLabel(branch_offsets[i]);
            }
            this.jc_instr = new JcInstrTableSwitch(jc_opcode, default_label, low_value, high_value, branch_labels);
            return this.jc_instr;
        }
        if (java_opcode == 171) {
            JInstrLookupSwitch java_lookup_instr = (JInstrLookupSwitch)this.java_instr;
            int default_branch_offset = java_lookup_instr.getDefaultBranchOffset();
            int default_branch_label = this.getBranchLabel(default_branch_offset);
            int[] match_offsets = java_lookup_instr.getMatchOffsets();
            int[] match_values = java_lookup_instr.getMatchValues();
            int num_pairs = match_offsets.length;
            OperandStackEntry key_entry = this.operand_stack.pop();
            if (key_entry.hasOverflowPotential()) {
                if (this.method_converter.isIntSupported()) {
                    key_entry.rollBack();
                } else {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.21", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
            }
            boolean int_type = false;
            if (key_entry.getType() == 3) {
                int_type = true;
            }
            for (int element : match_values) {
                if (DataType.getType(element) != 3) continue;
                int_type = true;
            }
            if (int_type) {
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.8", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.8", this.method_converter.getClassName().replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                if (key_entry.getType() != 3) {
                    key_entry.rollBack();
                }
            }
            int jc_opcode = int_type ? 118 : 117;
            int[] match_labels = new int[num_pairs];
            for (int i = 0; i < num_pairs; ++i) {
                match_labels[i] = this.getBranchLabel(match_offsets[i]);
            }
            this.jc_instr = new JcInstrLookupSwitch(jc_opcode, default_branch_label, match_values, match_labels);
            return this.jc_instr;
        }
        throw new ConverterInternalError();
    }

    private int getBranchLabel(int offset) {
        int target_pc = this.java_instr.getPC() + offset;
        for (InstrContainer cur_instr_container = this.method_converter.getInstrContainers(); cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            if (cur_instr_container.getJInstr().getPC() != target_pc) continue;
            if (cur_instr_container.getLabel() == -1) {
                throw new ConverterInternalError();
            }
            return cur_instr_container.getLabel();
        }
        throw new ConverterInternalError();
    }
}

