/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.EfNames;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.Type;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.TypeArray;
import com.sun.javacard.jcbytecodeprofiler.cryptoanalyzer.TypeClass;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCMethod
extends Member {
    public static final int ACC_REMOTE = 32;
    protected MethodIdentifier methodIdentifier;
    protected JCClass parentClass;
    protected Vector<Statement> statementVector = new Vector();
    protected ExceptionTable exceptionTable;
    public int stack;
    public int locals;
    private Hashtable<String, Integer> symbolTable = new Hashtable();
    private int relPc;
    private int size;
    private boolean abstractError;
    private boolean nativeError;
    private boolean sizeError;
    public short nativeToken;
    private int headerSize;

    public JCMethod(JCClass parentClass, int attributes, String name, int line) {
        super(attributes, name, line, 0);
        this.parentClass = parentClass;
        this.checkForInts(name);
        this.headerSize = 0;
    }

    public JCMethod(JCClass parentClass, int attributes, String name, MethodIdentifier id, int line) {
        this(parentClass, attributes, name, line);
        this.methodIdentifier = id;
        this.headerSize = 0;
    }

    public MethodIdentifier getMethodIdentifier() {
        return this.methodIdentifier;
    }

    public JCClass getParentClass() {
        return this.parentClass;
    }

    public void addExceptionTableEntry(ExceptionTableEntry entry) {
        if (this.exceptionTable == null) {
            this.exceptionTable = new ExceptionTable(this);
        }
        this.exceptionTable.addExceptionEntry(entry);
    }

    public ExceptionTable getExceptionTable() {
        return this.exceptionTable;
    }

    public Enumeration<Statement> statementElements() {
        return this.statementVector.elements();
    }

    public Vector<Statement> getStatements() {
        return this.statementVector;
    }

    protected void setStack(int stack) {
        this.stack = stack;
    }

    protected void setLocals(int locals) {
        this.locals = locals;
    }

    public String getFormattedMethod() {
        String s = this.getName();
        String className = this.parentClass.getName();
        int classIndex = className.length() + 1;
        String methodName = (s = s.substring(classIndex)).substring(0, s.indexOf("("));
        if (methodName.equals("<init>")) {
            methodName = className.substring(className.lastIndexOf("/") + 1);
        }
        String methodDescr = s.substring(s.indexOf("("));
        int a = this.getAttributes();
        String attributeString = Modifier.toString(a);
        return attributeString + " " + EfNames.prettyMethod(methodName, methodDescr);
    }

    public int getParams() {
        char c;
        int params = Modifier.isStatic(this.attributes) ? 0 : 1;
        int index = 0;
        while (this.name.charAt(index++) != '(') {
        }
        block11: while ((c = this.name.charAt(index++)) != ')') {
            switch (c) {
                case 'B': 
                case 'S': 
                case 'Z': {
                    ++params;
                    continue block11;
                }
                case 'I': {
                    params += 2;
                    continue block11;
                }
                case '[': {
                    c = this.name.charAt(index++);
                    switch (c) {
                        case 'L': {
                            while (this.name.charAt(index++) != ';') {
                            }
                        }
                        case 'B': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            ++params;
                            continue block11;
                        }
                    }
                    assert (false) : "getParams()";
                    continue block11;
                }
                case 'L': {
                    while (this.name.charAt(index++) != ';') {
                    }
                    ++params;
                    continue block11;
                }
            }
            assert (false) : "getParams()";
        }
        return params;
    }

    public Type getMethodReturnType() {
        StringBuffer returnType = new StringBuffer();
        int nameSize = this.name.length();
        int index = 0;
        while (this.name.charAt(index++) != ')') {
        }
        while (index < nameSize) {
            returnType.append(this.name.charAt(index++));
        }
        String typeStr = returnType.toString();
        if (typeStr.startsWith("I")) {
            return Type.Int;
        }
        if (typeStr.startsWith("B")) {
            return Type.Byte;
        }
        if (typeStr.startsWith("S")) {
            return Type.Short;
        }
        if (typeStr.startsWith("Z")) {
            return Type.Boolean;
        }
        if (typeStr.startsWith("V")) {
            return Type.Void;
        }
        return Type.Reference;
    }

    public void setMethodLocals(Type[] locals) {
        char c;
        int i = 0;
        if (!Modifier.isStatic(this.attributes)) {
            locals[i++] = new TypeClass(0);
        }
        int index = 0;
        while (this.name.charAt(index++) != '(') {
        }
        block16: while ((c = this.name.charAt(index++)) != ')') {
            switch (c) {
                case 'B': {
                    locals[i++] = Type.Byte;
                    continue block16;
                }
                case 'S': {
                    locals[i++] = Type.Short;
                    continue block16;
                }
                case 'Z': {
                    locals[i++] = Type.Boolean;
                    continue block16;
                }
                case 'I': {
                    locals[i++] = Type.Int;
                    locals[i++] = Type.Int2;
                    continue block16;
                }
                case '[': {
                    c = this.name.charAt(index++);
                    switch (c) {
                        case 'L': {
                            while (this.name.charAt(index++) != ';') {
                            }
                            locals[i++] = new TypeArray(new TypeClass(0));
                            continue block16;
                        }
                        case 'B': {
                            locals[i++] = Type.ByteArray;
                            continue block16;
                        }
                        case 'S': {
                            locals[i++] = Type.ShortArray;
                            continue block16;
                        }
                        case 'Z': {
                            locals[i++] = Type.BooleanArray;
                            continue block16;
                        }
                        case 'I': {
                            locals[i++] = Type.IntArray;
                            continue block16;
                        }
                    }
                    assert (false) : "getParamTypes()";
                    continue block16;
                }
                case 'L': {
                    while (this.name.charAt(index++) != ';') {
                    }
                    locals[i++] = new TypeClass(0);
                    continue block16;
                }
            }
            assert (false) : "getParamTypes()";
        }
    }

    public boolean isInit() {
        String s = this.getName();
        String className = this.parentClass.getName();
        int classIndex = className.length() + 1;
        s = s.substring(classIndex);
        String methodName = s.substring(0, s.indexOf("("));
        return methodName.equals("<init>");
    }

    public byte[] getMethodHeader() {
        if (Modifier.isInterface(this.parentClass.getAttributes()) && Modifier.isAbstract(this.getAttributes())) {
            return new byte[0];
        }
        int params = this.getParams();
        byte[] header = this.stack > 15 || params > 15 || this.locals > 15 ? new byte[]{-128, (byte)this.stack, (byte)params, (byte)this.locals} : new byte[]{(byte)(this.stack & 0xF), (byte)(params << 4 | this.locals & 0xF)};
        if (Modifier.isAbstract(this.attributes)) {
            header[0] = (byte)(header[0] | 0x40);
        }
        if (Modifier.isNative(this.attributes)) {
            byte[] header2 = new byte[]{header[0]};
            header2[0] = (byte)(header2[0] | 0x20);
            return header2;
        }
        return header;
    }

    protected void addStatement(Statement s) {
        if (Modifier.isAbstract(this.attributes) && !this.abstractError) {
            Object[] args = new Object[]{this.name};
            Msg.error("method.1", args);
            this.abstractError = true;
            return;
        }
        if (Modifier.isNative(this.attributes) && !this.nativeError) {
            Object[] args = new Object[]{this.name};
            Msg.error("method.2", args);
            this.nativeError = true;
            return;
        }
        this.statementVector.addElement(s);
        if (s.label != null) {
            String key = s.label.toLowerCase();
            if (this.symbolTable.containsKey(key)) {
                Object[] arguments = new Object[]{key, new Integer(s.lineNumber)};
                Msg.error("method.0", arguments);
            }
            this.symbolTable.put(key, new Integer(this.relPc));
        }
        s.relPc = this.relPc;
        this.relPc += s.size();
        this.size += s.size();
        if (this.size > Short.MAX_VALUE && !this.sizeError) {
            Object[] args = new Object[]{this.name};
            Msg.error("method.3", args);
            this.sizeError = true;
        }
    }

    public int size() {
        if (Modifier.isInterface(this.parentClass.getAttributes()) && Modifier.isAbstract(this.getAttributes())) {
            return 0;
        }
        if (Modifier.isNative(this.attributes)) {
            return this.size + 1;
        }
        int params = this.getParams();
        if (this.stack > 15 || params > 15 || this.locals > 15) {
            return this.size + 4;
        }
        return this.size + 2;
    }

    protected void methodFixup() {
        if (this.symbolTable == null) {
            return;
        }
        for (Statement s : this.statementVector) {
            s.methodFixup(this.symbolTable);
        }
        if (this.exceptionTable != null) {
            this.exceptionTable.fixup(this.symbolTable);
        }
        if (!Globals.debug) {
            this.symbolTable = null;
        }
    }

    public void setNativeToken(short tk) {
        this.nativeToken = tk;
    }

    public short getNativeToken() {
        return this.nativeToken;
    }

    private void checkForInts(String name) {
        char c;
        int index = 0;
        while (name.charAt(index++) != '(') {
        }
        block5: while ((c = name.charAt(index++)) != ')') {
            switch (c) {
                case 'I': {
                    this.parentClass.getParentPackage().usesIntegers(true);
                    continue block5;
                }
                case 'L': {
                    while (name.charAt(index++) != ';') {
                    }
                    continue block5;
                }
            }
        }
    }

    public byte[] toByteArray() {
        if (this.size() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] methodHeader = this.getMethodHeader();
            dos.write(methodHeader, 0, methodHeader.length);
            for (Statement smt : this.statementVector) {
                byte[] array = smt.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        assert (this.size() == bos.size()) : "size() != bos.size()";
        return bos.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(".method " + super.toString());
        if (this.methodIdentifier != null) {
            sb.append(" <" + this.methodIdentifier + ">");
        }
        sb.append(" {" + Msg.eol);
        sb.append("method_header: " + Msg.toHexString(this.getMethodHeader()) + Msg.eol);
        for (Statement c : this.statementVector) {
            sb.append(c);
        }
        if (this.exceptionTable != null) {
            sb.append(this.exceptionTable + Msg.eol);
        }
        if (Globals.debug && this.symbolTable != null) {
            sb.append("// " + this.symbolTable + Msg.eol);
        }
        sb.append("}" + Msg.eol);
        return sb.toString();
    }

    boolean isRemote() {
        return (this.getAttributes() & 0x20) != 0;
    }

    public int getHeaderSize() {
        if (this.headerSize == 0) {
            this.headerSize = this.getMethodHeader().length;
        }
        return this.headerSize;
    }

    public boolean isGRTCandidate() {
        return false;
    }
}

