/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

public enum Kind {
    SingleStep(1),
    BreakPoint(2),
    FramePop(3),
    Exception(4),
    UserDefined(5),
    ThreadStart(6),
    ThreadEnd(7),
    ClassPrepared(8),
    ClassUnloaded(9),
    ClassLoaded(10),
    FieldAccess(20),
    FieldModification(21),
    ExceptionCatch(30),
    MethodEntry(40),
    MethodExit(41),
    VMInit(90),
    VMDeath(99),
    Unknown(255);

    private byte code;

    private Kind(int code) {
        this.code = (byte)code;
    }

    public byte code() {
        return this.code;
    }

    public static Kind find(int kind) {
        kind &= 0xFF;
        for (Kind c : Kind.values()) {
            if ((c.code() & 0xFF) != kind) continue;
            return c;
        }
        return Unknown;
    }
}

