/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.VmState;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.classic.handlers.FixedDataHandler;
import com.sun.javacard.debugproxy.classic.handlers.UnsupportedOperationHandler;
import com.sun.javacard.debugproxy.types.Location;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ThreadConverters {
    public static final String THREAD_ID_KEY = "thread-id";

    static void registerThreadGroupConverters(ClassicProxyProtocol proxy) {
        proxy.addConverter(11, 5, new FixedDataHandler(-32));
        proxy.addConverter(11, 1, new FixedDataHandler("JavaCard_System"));
        proxy.addConverter(11, 4, new ThreadPacketHandler(){

            @Override
            public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
                ThreadConverters.checkVMThread(state);
                VmState.State vmState = this.proxy.state().getState();
                if (vmState == VmState.State.SUSPENDED) {
                    state.out.writeInt(1);
                    state.out.writeInt(1);
                } else {
                    state.out.writeInt(1);
                    state.out.writeInt(0);
                }
            }
        });
        proxy.addConverter(11, 12, new ThreadPacketHandler(){

            @Override
            public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
                ThreadConverters.checkVMThread(state);
                int count = this.proxy.state().getSuspendCount();
                state.out.writeInt(count);
            }
        });
        FixedDataHandler error = new FixedDataHandler(13);
        error.setError(true);
        proxy.addConverter(11, 7, new ThreadPacketHandler(){

            @Override
            public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
                ThreadConverters.checkVMThread(state);
                try {
                    state.out.writeInt(this.proxy.state().getStack().length);
                }
                catch (IllegalStateException e) {
                    throw new InvalidRequestException(13, "VM is not suspended");
                }
            }
        });
        proxy.addConverter(11, 6, new ThreadPacketHandler(){

            @Override
            protected ClassicPacketHandler.DeliveryType handleVMThread(HandlerState state, DataInputStream fromIde, DataOutputStream toVm) throws IOException {
                state.args.put("start", fromIde.readInt());
                state.args.put("count", fromIde.readInt());
                return ClassicPacketHandler.DeliveryType.NONE;
            }

            @Override
            public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
                int start;
                Location[] stack;
                ThreadConverters.checkVMThread(state);
                try {
                    stack = this.proxy.state().getStack();
                }
                catch (IllegalStateException e) {
                    throw new InvalidRequestException(13, "VM is not suspended");
                }
                int count = (Integer)state.args.get("count");
                int upTo = count < 0 ? stack.length : start + count;
                state.out.writeInt(upTo - start);
                for (start = ((Integer)state.args.get("start")).intValue(); start < upTo; ++start) {
                    if (stack[start] == null) continue;
                    state.out.writeInt(start);
                    stack[start].write(state.out);
                }
            }
        });
        proxy.addConverter(11, 8, new UnsupportedOperationHandler(99));
        proxy.addConverter(11, 9, new UnsupportedOperationHandler(99));
        proxy.addConverter(11, 10, new UnsupportedOperationHandler(10));
        proxy.addConverter(11, 11, new UnsupportedOperationHandler(10));
        proxy.addConverter(12, 1, new FixedDataHandler("JavaCard_System"));
        proxy.addConverter(12, 2, new FixedDataHandler(0));
        proxy.addConverter(12, 3, new ThreadPacketHandler(VMPacketHandler.CommandCode.NONE){

            @Override
            public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
                Log.LOGN(3, "ThreadGroup: children");
                if (ThreadConverters.isVMThreadGroup(state)) {
                    state.out.writeInt(1);
                    state.out.writeInt(-31);
                } else {
                    state.out.writeInt(0);
                }
                state.out.writeInt(0);
            }

            @Override
            protected ClassicPacketHandler.DeliveryType handleOtherThread(HandlerState state, DataInputStream fromIde, DataOutputStream toVm) throws Exception {
                return ClassicPacketHandler.DeliveryType.NONE;
            }
        });
    }

    public static int readThreadId(HandlerState state) throws Exception {
        int threadId = state.in.readInt();
        state.args.put(THREAD_ID_KEY, new Integer(threadId));
        return threadId;
    }

    public static void checkVMThread(HandlerState state) {
        if (!ThreadConverters.isVMThread(state)) {
            throw new InvalidRequestException(10);
        }
    }

    public static boolean isVMThread(HandlerState state) {
        Integer val = (Integer)state.args.get(THREAD_ID_KEY);
        return val != null && val == -31;
    }

    public static boolean isVMThreadGroup(HandlerState state) {
        Integer val = (Integer)state.args.get(THREAD_ID_KEY);
        return val != null && val == -32;
    }

    public static class ThreadPacketHandler
    extends ClassicPacketHandlerImpl {
        public ThreadPacketHandler(VMPacketHandler.CommandCode code) {
            super(code);
        }

        public ThreadPacketHandler() {
            super(VMPacketHandler.CommandCode.NONE);
        }

        @Override
        public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
            Log.LOGN(3, "ThreadGroup: children");
            int threadId = ThreadConverters.readThreadId(state);
            if (threadId == -31) {
                return this.handleVMThread(state, state.in, toVm);
            }
            return this.handleOtherThread(state, state.in, toVm);
        }

        protected ClassicPacketHandler.DeliveryType handleVMThread(HandlerState state, DataInputStream fromIde, DataOutputStream toVm) throws Exception {
            return ClassicPacketHandler.DeliveryType.NONE;
        }

        protected ClassicPacketHandler.DeliveryType handleOtherThread(HandlerState state, DataInputStream fromIde, DataOutputStream toVm) throws Exception {
            throw new InvalidRequestException(10);
        }
    }
}

