/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.DirectoryComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;

public class CapWriter {
    private static final Attributes.Name TIMESTAMP = new Attributes.Name("Java-Card-CAP-Creation-Time");
    private static final Attributes.Name CAP_FILE_VERSION = new Attributes.Name("Java-Card-CAP-File-Version");
    private static final Attributes.Name CONVERTER_VERSION = new Attributes.Name("Java-Card-Converter-Version");
    private static final Attributes.Name CONVERTER_PROVIDER = new Attributes.Name("Java-Card-Converter-Provider");
    private static final Attributes.Name PACKAGE_VERSION = new Attributes.Name("Java-Card-Package-Version");
    private static final Attributes.Name PACKAGE_NAME = new Attributes.Name("Java-Card-Package-Name");
    private static final Attributes.Name PACKAGE_AID = new Attributes.Name("Java-Card-Package-AID");
    private static final Attributes.Name INTEGER_SUPPORT = new Attributes.Name("Java-Card-Integer-Support-Required");
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    protected File file;
    protected String packageName;
    protected long timeStamp;

    public CapWriter(File file, String packageName) {
        this.file = file;
        this.packageName = packageName;
        this.timeStamp = System.currentTimeMillis();
    }

    public void publish(HeaderComponent header, DirectoryComponent directory, AppletComponent applet, ImportComponent imports, ConstantPoolComponent constantPool, ClassComponent classes, MethodComponent methods, StaticFieldComponent staticFields, ReferenceLocationComponent referenceLocation, ExportComponent export, DescriptorComponent descriptor, DebugComponent debugCmp) throws IOException {
        JarOutputStream jos = null;
        try {
            jos = new JarOutputStream((OutputStream)new FileOutputStream(this.file), this.getJarManifest(header.getParentPackage()));
        }
        catch (IOException e) {
            Object[] arguments = new Object[]{this.file.getAbsolutePath()};
            Msg.error("capWriter.1", arguments);
            return;
        }
        jos.setMethod(0);
        this.addJarEntry(jos, "Header.cap", header);
        this.addJarEntry(jos, "Directory.cap", directory);
        if (applet != null) {
            this.addJarEntry(jos, "Applet.cap", applet);
        }
        this.addJarEntry(jos, "Import.cap", imports);
        this.addJarEntry(jos, "ConstantPool.cap", constantPool);
        this.addJarEntry(jos, "Class.cap", classes);
        this.addJarEntry(jos, "Method.cap", methods);
        this.addJarEntry(jos, "StaticField.cap", staticFields);
        this.addJarEntry(jos, "RefLocation.cap", referenceLocation);
        if (export != null) {
            this.addJarEntry(jos, "Export.cap", export);
        }
        if (descriptor != null) {
            this.addJarEntry(jos, "Descriptor.cap", descriptor);
        }
        if (debugCmp != null) {
            byte[] debugData = this.mergeDebugOffsets(classes, methods, staticFields);
            this.addJarEntry(jos, "Debug.cap", debugData);
        }
        jos.close();
    }

    private Manifest getJarManifest(JCPackage jcPkg) throws IOException {
        Manifest mf = new Manifest();
        Attributes mfa = mf.getMainAttributes();
        String entryName = jcPkg.getName();
        Attributes entryAttributes = new Attributes();
        mfa.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mfa.put(CREATED_BY, System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        Date d = new Date(this.timeStamp);
        entryAttributes.put(TIMESTAMP, d.toString());
        entryAttributes.put(CONVERTER_VERSION, ToolsVersion.getVersion(1));
        entryAttributes.put(CONVERTER_PROVIDER, "Sun Microsystems Inc.");
        if (jcPkg.is22Package()) {
            entryAttributes.put(CAP_FILE_VERSION, "2.2");
        } else {
            entryAttributes.put(CAP_FILE_VERSION, "2.1");
        }
        entryAttributes.put(PACKAGE_VERSION, jcPkg.getIdentifier().getMajorVersion() + "." + jcPkg.getIdentifier().getMinorVersion());
        entryAttributes.put(PACKAGE_NAME, jcPkg.getName().replace('/', '.'));
        entryAttributes.put(PACKAGE_AID, jcPkg.getIdentifier().getAid().toString());
        int i = 1;
        Enumeration f = jcPkg.appletElements();
        while (f.hasMoreElements()) {
            AppletDeclarator ad = (AppletDeclarator)f.nextElement();
            entryAttributes.put(new Attributes.Name("Java-Card-Applet-" + i + "-Name"), ad.getName());
            entryAttributes.put(new Attributes.Name("Java-Card-Applet-" + i + "-AID"), ad.getAid().toString());
            ++i;
        }
        i = 1;
        f = jcPkg.importElements();
        while (f.hasMoreElements()) {
            PackageIdentifier pi = (PackageIdentifier)f.nextElement();
            entryAttributes.put(new Attributes.Name("Java-Card-Imported-Package-" + i + "-AID"), pi.getAid().toString());
            entryAttributes.put(new Attributes.Name("Java-Card-Imported-Package-" + i + "-Version"), pi.getMajorVersion() + "." + pi.getMinorVersion());
            ++i;
        }
        if (jcPkg.usesIntegers()) {
            entryAttributes.put(INTEGER_SUPPORT, "TRUE");
        } else {
            entryAttributes.put(INTEGER_SUPPORT, "FALSE");
        }
        mf.getEntries().put(entryName, entryAttributes);
        return mf;
    }

    private void addJarEntry(JarOutputStream jos, String name, Component component) throws IOException {
        byte[] data = component.toByteArray();
        if (data == null) {
            throw new NullPointerException("Bad Component:" + name);
        }
        JarEntry je = new JarEntry(this.packageName + "/javacard/" + name);
        je.setSize(data.length);
        je.setTime(this.timeStamp);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        je.setCrc(crc.getValue());
        jos.putNextEntry(je);
        jos.write(data, 0, data.length);
    }

    private void addJarEntry(JarOutputStream jos, String name, byte[] data) throws IOException {
        JarEntry je = new JarEntry(this.packageName + "/javacard/" + name);
        je.setSize(data.length);
        je.setTime(this.timeStamp);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        je.setCrc(crc.getValue());
        jos.putNextEntry(je);
        jos.write(data, 0, data.length);
    }

    private byte[] mergeDebugOffsets(ClassComponent classes, MethodComponent methods, StaticFieldComponent staticFields) {
        Hashtable offsets = new Hashtable();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        classes.getDebugOffsets(offsets);
        methods.getDebugOffsets(offsets);
        staticFields.getDebugOffsets(offsets);
        try {
            if (Globals.outputDebugData != null) {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(Globals.outputDebugData));
                this.mergeDebugComponent(dis, dos, offsets);
            }
            bos.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    private void mergeDebugComponent(DataInputStream dis, DataOutputStream dos, Map offsets) throws IOException {
        dos.writeByte(dis.readUnsignedByte());
        dos.writeShort(dis.readUnsignedShort());
        int string_count = dis.readUnsignedShort();
        dos.writeShort(string_count);
        String[] strings = new String[string_count];
        for (int s = 0; s < string_count; ++s) {
            strings[s] = dis.readUTF();
            dos.writeUTF(strings[s]);
        }
        dos.writeShort(dis.readUnsignedShort());
        int class_count = dis.readUnsignedShort();
        dos.writeShort(class_count);
        for (int c = 0; c < class_count; ++c) {
            this.mergeClassDebugInfo(dis, dos, strings, offsets);
        }
    }

    private void mergeClassDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map offsets) throws IOException {
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        dos.writeShort(dis.readUnsignedShort());
        dis.readUnsignedShort();
        String name = strings[name_index];
        Integer offset = (Integer)offsets.get(name);
        dos.writeShort(offset);
        dos.writeShort(dis.readUnsignedShort());
        dos.writeShort(dis.readUnsignedShort());
        int interface_count = dis.readUnsignedByte();
        dos.writeByte(interface_count);
        int field_count = dis.readUnsignedShort();
        dos.writeShort(field_count);
        int method_count = dis.readUnsignedShort();
        dos.writeShort(method_count);
        for (int i = 0; i < interface_count; ++i) {
            dos.writeShort(dis.readUnsignedShort());
        }
        for (int f = 0; f < field_count; ++f) {
            this.mergeFieldDebugInfo(dis, dos, strings, offsets, name);
        }
        for (int m = 0; m < method_count; ++m) {
            this.mergeMethodDebugInfo(dis, dos, strings, offsets, name);
        }
    }

    private void mergeMethodDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map offsets, String className) throws IOException {
        int ACC_ABSTRACT = 1024;
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        int descriptor_index = dis.readUnsignedShort();
        dos.writeShort(descriptor_index);
        int access_flags = dis.readUnsignedShort();
        dos.writeShort(access_flags);
        boolean isAbstract = (access_flags & 0x400) != 0;
        dis.readUnsignedShort();
        if (isAbstract) {
            dos.writeShort(0);
        } else {
            String name = strings[name_index];
            String descriptor = strings[descriptor_index];
            String signature = className + "/" + name + descriptor;
            Integer offset = (Integer)offsets.get(signature);
            dos.writeShort(offset);
        }
        dos.writeByte(dis.readUnsignedByte());
        dos.writeShort(dis.readUnsignedShort());
        int variable_count = dis.readUnsignedShort();
        dos.writeShort(variable_count);
        int line_count = dis.readUnsignedShort();
        dos.writeShort(line_count);
        for (int v = 0; v < variable_count; ++v) {
            dos.writeByte(dis.readUnsignedByte());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
        }
        for (int k = 0; k < line_count; ++k) {
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
        }
    }

    private void mergeFieldDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map offsets, String className) throws IOException {
        int ACC_STATIC = 8;
        int ACC_FINAL = 16;
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        int descriptor_index = dis.readUnsignedShort();
        dos.writeShort(descriptor_index);
        int access_flags = dis.readUnsignedShort();
        dos.writeShort(access_flags);
        boolean isStatic = (access_flags & 8) != 0;
        boolean isFinal = (access_flags & 0x10) != 0;
        boolean isPrimitive = strings[descriptor_index].length() == 1;
        if (isStatic & !(isFinal & isPrimitive)) {
            dos.writeShort(dis.readUnsignedShort());
            dis.readUnsignedShort();
            String name = className + "/" + strings[name_index];
            Integer offset = (Integer)offsets.get(name);
            dos.writeShort(offset);
        } else {
            dos.writeInt(dis.readInt());
        }
    }
}

