/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JSourceFileAttr;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class JClassFile
extends ClassDefinition {
    private int magic;
    private int major_version;
    private int minor_version;
    private int this_class_index;
    private int super_class_index;
    private JConstantPool constant_pool;
    private int[] interface_indexes;
    private JField[] fields;
    private JMethod[] methods;
    private JAttribute[] attributes;
    private String[] interface_names;

    public int getMagic() {
        return this.magic;
    }

    public int getMajorVersion() {
        return this.major_version;
    }

    public int getMinorVersion() {
        return this.minor_version;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public JField[] getFields() {
        return this.fields;
    }

    public JMethod[] getMethods() {
        return this.methods;
    }

    public JConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public void resolve() {
        this.constant_pool.resolve();
        this.class_name = this.constant_pool.getConstantClass(this.this_class_index).getClassName();
        this.super_class_name = this.super_class_index != 0 ? this.constant_pool.getConstantClass(this.super_class_index).getClassName() : null;
        this.interface_names = new String[this.interface_indexes.length];
        int i = 0;
        while (i < this.interface_names.length) {
            this.interface_names[i] = this.constant_pool.getConstantClass(this.interface_indexes[i]).getClassName();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.attributes.length) {
            this.attributes[i2].resolve();
            if (this.attributes[i2] instanceof JSourceFileAttr) {
                this.source_file_name = ((JSourceFileAttr)this.attributes[i2]).getFileName();
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.fields.length) {
            this.fields[i3].resolve();
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.methods.length) {
            this.methods[i4].resolve();
            ++i4;
        }
    }

    public void parse(DataInputStream dis) throws IOException {
        this.magic = dis.readInt();
        this.minor_version = dis.readUnsignedShort();
        this.major_version = dis.readUnsignedShort();
        this.constant_pool = new JConstantPool(dis.readUnsignedShort());
        this.constant_pool.parse(dis);
        this.access_flags = dis.readUnsignedShort();
        this.this_class_index = dis.readUnsignedShort();
        this.super_class_index = dis.readUnsignedShort();
        this.interface_indexes = new int[dis.readUnsignedShort()];
        int i = 0;
        while (i < this.interface_indexes.length) {
            this.interface_indexes[i] = dis.readUnsignedShort();
            ++i;
        }
        this.fields = new JField[dis.readUnsignedShort()];
        int i2 = 0;
        while (i2 < this.fields.length) {
            this.fields[i2] = new JField(this.constant_pool);
            this.fields[i2].parse(dis);
            ++i2;
        }
        this.methods = new JMethod[dis.readUnsignedShort()];
        int i3 = 0;
        while (i3 < this.methods.length) {
            this.methods[i3] = new JMethod(this.constant_pool);
            this.methods[i3].parse(dis);
            ++i3;
        }
        this.attributes = new JAttribute[dis.readUnsignedShort()];
        int i4 = 0;
        while (i4 < this.attributes.length) {
            int index = dis.readUnsignedShort();
            this.attributes[i4] = JAttribute.create(this.constant_pool, index);
            this.attributes[i4].parse(dis);
            ++i4;
        }
    }

    public JField getField(String name, String descriptor) {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].getFieldName().equals(name) && this.fields[i].getFieldDescriptor().equals(descriptor)) {
                return this.fields[i];
            }
            ++i;
        }
        return null;
    }

    public JMethod getMethod(String name, String descriptor) {
        int i = 0;
        while (i < this.methods.length) {
            if (this.methods[i].getMethodName().equals(name) && this.methods[i].getMethodDescriptor().equals(descriptor)) {
                return this.methods[i];
            }
            ++i;
        }
        return null;
    }

    public void addMethod(JMethod jm) {
        JMethod[] new_methods = new JMethod[this.methods.length + 1];
        System.arraycopy(this.methods, 0, new_methods, 0, this.methods.length);
        new_methods[this.methods.length] = jm;
        this.methods = new_methods;
    }
}

