/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;
import org.mortbay.io.Portable;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ByteArrayBuffer
extends AbstractBuffer {
    private byte[] bytes;

    public ByteArrayBuffer(byte[] bytes) {
        this(bytes, 0, bytes.length, 2);
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length) {
        this(bytes, index, length, 2);
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length, int access) {
        super(2, false);
        this.bytes = bytes;
        this.setPutIndex(index + length);
        this.setGetIndex(index);
        this.accessType = access;
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length, int access, boolean isVolatile) {
        super(2, isVolatile);
        this.bytes = bytes;
        this.setPutIndex(index + length);
        this.setGetIndex(index);
        this.accessType = access;
    }

    public ByteArrayBuffer(int size) {
        this(new byte[size], 0, size, 2);
        this.setPutIndex(0);
    }

    public ByteArrayBuffer(String value) {
        super(2, false);
        this.bytes = Portable.getBytes(value);
        this.setGetIndex(0);
        this.setPutIndex(this.bytes.length);
        this.accessType = 0;
        this.string = value;
    }

    @Override
    public byte[] array() {
        return this.bytes;
    }

    @Override
    public int capacity() {
        return this.bytes.length;
    }

    @Override
    public byte get() {
        return this.bytes[this.readIndex++];
    }

    @Override
    public byte peek(int index) {
        return this.bytes[index];
    }

    @Override
    public int peek(int index, byte[] b, int offset, int length) {
        int l = length;
        if (index + l > this.capacity()) {
            l = this.capacity() - index;
        }
        if (l <= 0) {
            return -1;
        }
        Portable.arraycopy(this.bytes, index, b, offset, l);
        return l;
    }

    @Override
    public void poke(int index, byte b) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index<0: " + index + "<0");
        }
        if (index > this.capacity()) {
            throw new IllegalArgumentException("index>capacity(): " + index + ">" + this.capacity());
        }
        this.bytes[index] = b;
    }

    public void wrap(byte[] b, int off, int len) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (this.isImmutable()) {
            throw new IllegalStateException("IMMUTABLE");
        }
        this.bytes = b;
        this.clear();
        this.setGetIndex(off);
        this.setPutIndex(off + len);
    }

    public void wrap(byte[] b) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (this.isImmutable()) {
            throw new IllegalStateException("IMMUTABLE");
        }
        this.bytes = b;
        this.setGetIndex(0);
        this.setPutIndex(b.length);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytes, this.getReadIndex(), this.length());
        this.clear();
    }

    @Override
    public int readFrom(InputStream in, int max) throws IOException {
        int p;
        int len;
        if (max > this.space()) {
            max = this.space();
        }
        if ((len = in.read(this.bytes, p = this.getWriteIndex(), max)) > 0) {
            this.setPutIndex(p + len);
        }
        return len;
    }

    static class CaseInsensitive
    extends ByteArrayBuffer
    implements Buffer.CaseInsensitve {
        public CaseInsensitive(String s) {
            super(s);
        }

        public CaseInsensitive(byte[] b, int o, int l, int rw) {
            super(b, o, l, rw);
        }
    }
}

