/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import com.sun.javacard.Logger;
import com.sun.javacard.file.FileConnection;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.resource.Resource;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class DeployedDescriptor
implements Attributes {
    private Attributes attributes = new AttributesMap();

    public DeployedDescriptor(Resource r) {
        StringBuffer sb = new StringBuffer();
        try {
            Resource m = r.addPath("META-INF/MANIFEST.MF");
            FileConnection manifest = m.getFile();
            if (!manifest.exists()) {
                Logger.debug("MANIFEST.MF file does not exist !!!!");
                throw new IllegalArgumentException("No such MANIFEST.MF file ");
            }
            InputStream is = manifest.openInputStream();
            int ch = 0;
            while ((ch = is.read()) > 0) {
                sb.append((char)ch);
            }
        }
        catch (Exception e) {
            Logger.debug("Open MANIFEST.MF file failed " + e);
        }
        StringTokenizer st = new StringTokenizer(sb.toString(), "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.startsWith("#") || line.startsWith("\r")) continue;
            String name = line.substring(0, line.indexOf(58));
            String value = line.substring(line.indexOf(58) + 1);
            if (value.startsWith(" ")) {
                value = value.substring(1);
            }
            if (value.endsWith("\r")) {
                value = value.substring(0, value.length() - 1);
            }
            this.setAttribute(name, value);
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    @Override
    public void clearAttributes() {
        this.attributes.clearAttributes();
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.removeAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }
}

