/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import com.sun.javacard.Logger;
import java.io.IOException;
import java.io.OutputStream;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.util.StringUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class MultiPartOutputStream
extends OutputStream {
    private static byte[] CRLF;
    private static byte[] DASHDASH;
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final String MULTIPART_X_MIXED_REPLACE = "multipart/x-mixed-replace";
    private static boolean OK;
    private String boundary;
    private byte[] boundaryBytes;
    private boolean inPart = false;
    private final OutputStream out;

    public MultiPartOutputStream(OutputStream out) throws IOException {
        if (!OK) {
            throw new IOException("MultiPartOutputStream.java - static initializer error");
        }
        this.out = out;
        try {
            this.boundary = "jetty" + System.identityHashCode(this) + Long.toString(System.currentTimeMillis(), 36);
            this.boundaryBytes = this.boundary.getBytes(StringUtil.ISO_8859_1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("MultiPartOutputStream.java");
        }
        this.inPart = false;
    }

    @Override
    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(CRLF);
        }
        this.out.write(DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(DASHDASH);
        this.out.write(CRLF);
        this.inPart = false;
        this.out.close();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void startPart(String contentType) throws IOException {
        if (this.inPart) {
            this.out.write(CRLF);
        }
        this.inPart = true;
        this.out.write(DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(StringUtil.ISO_8859_1));
        this.out.write(CRLF);
        this.out.write(CRLF);
    }

    public void startPart(String contentType, String[] headers) throws IOException {
        if (this.inPart) {
            this.out.write(CRLF);
        }
        this.inPart = true;
        this.out.write(DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(StringUtil.ISO_8859_1));
        this.out.write(CRLF);
        for (int i = 0; headers != null && i < headers.length; ++i) {
            this.out.write(headers[i].getBytes(StringUtil.ISO_8859_1));
            this.out.write(CRLF);
        }
        this.out.write(CRLF);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    static {
        OK = false;
        Logger.debug("org.mortbay.jetty.MultiPart.STATIC() -> ");
        try {
            CRLF = "\r\n".getBytes(StringUtil.ISO_8859_1);
            DASHDASH = "--".getBytes(StringUtil.ISO_8859_1);
            OK = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

