/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

class RefLocComponent
extends Safeptr {
    RefLocComponent(byte[] byArray) {
        super(byArray, "ReferenceLocation");
    }

    int byteIndexCount() {
        return this.u2(0);
    }

    Safeptr offsetsToByteIndices() {
        return this.offset(2);
    }

    int byte2_indexCount() {
        return this.u2(2 + this.byteIndexCount());
    }

    Safeptr offsetsToByte2Indices() {
        return this.offset(4 + this.byteIndexCount());
    }

    void verify() {
        int n;
        if (Verifier.verbose >= 2) {
            Messages.println("RefLocComponent.100");
        }
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        this.addReflocs(vector, this.byteIndexCount(), this.offsetsToByteIndices());
        this.addReflocs(vector2, this.byte2_indexCount(), this.offsetsToByte2Indices());
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        ClassDescriptor classDescriptor = Cap.Descriptor.firstClassDescriptor();
        for (n = Cap.Descriptor.classCount(); n > 0; --n) {
            if ((classDescriptor.flags() & 0x40) == 0) {
                for (int i = 0; i < classDescriptor.methodCount(); ++i) {
                    MethodDescriptor methodDescriptor = classDescriptor.methodDescr(i);
                    this.addReferencesInMethod(treeSet, treeSet2, methodDescriptor);
                }
            }
            classDescriptor.next();
        }
        for (n = 0; n < Cap.Method.handlerCount(); ++n) {
            ExnHandlerInfo exnHandlerInfo = Cap.Method.exceptionHandler(n);
            if (exnHandlerInfo.catchType() == 0) continue;
            treeSet2.add(new Integer(exnHandlerInfo.ofs + 6));
        }
        this.checkReflocEqual(vector, treeSet, 1);
        this.checkReflocEqual(vector2, treeSet2, 2);
        if (4 + this.byteIndexCount() + this.byte2_indexCount() != Cap.ReferenceLocation.size()) {
            throw new VerifierError("RefLocComponent.1");
        }
    }

    private void addReflocs(Vector<Integer> vector, int n, Safeptr safeptr) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = safeptr.u1(i);
            n2 += n3;
            if (n3 == 255) continue;
            vector.add(new Integer(n2));
        }
    }

    private void addReferencesInMethod(TreeSet<Integer> treeSet, TreeSet<Integer> treeSet2, MethodDescriptor methodDescriptor) {
        MethodInfo methodInfo = Cap.Method.methodInfo(methodDescriptor.methodOffset());
        int n = methodInfo.flags();
        if ((n & 4) != 0) {
            return;
        }
        Safeptr safeptr = (n & 8) == 0 ? methodInfo.bytecodeCompact() : methodInfo.bytecodeExtended();
        int n2 = safeptr.ofs + methodDescriptor.bytecodeCount();
        while (safeptr.ofs < n2) {
            Instr instr = Instr.instrAt(safeptr);
            switch (instr.opcode) {
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 145: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    treeSet2.add(new Integer(safeptr.ofs + 1));
                    break;
                }
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 181: 
                case 182: 
                case 183: 
                case 184: {
                    treeSet.add(new Integer(safeptr.ofs + 1));
                    break;
                }
                case 142: {
                    treeSet2.add(new Integer(safeptr.ofs + 2));
                    break;
                }
                case 148: 
                case 149: {
                    switch (safeptr.u1(1)) {
                        case 0: 
                        case 14: {
                            treeSet2.add(new Integer(safeptr.ofs + 2));
                        }
                    }
                }
            }
            safeptr.advance(instr.length());
        }
    }

    private void checkReflocEqual(Vector<Integer> vector, TreeSet<Integer> treeSet, int n) {
        Enumeration<Integer> enumeration = vector.elements();
        Iterator<Integer> iterator = treeSet.iterator();
        while (enumeration.hasMoreElements() && iterator.hasNext()) {
            int n2;
            int n3 = enumeration.nextElement();
            if (n3 < (n2 = iterator.next().intValue())) {
                throw new VerifierError("RefLocComponent.2", n, n3);
            }
            if (n3 <= n2) continue;
            throw new VerifierError("RefLocComponent.3", n, n2);
        }
        if (enumeration.hasMoreElements()) {
            throw new VerifierError("RefLocComponent.4", n);
        }
        if (iterator.hasNext()) {
            throw new VerifierError("RefLocComponent.5", n);
        }
    }
}

