/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.PackageProfile;
import com.sun.javacard.converter.util.ClassFileNameFilter;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class OptionParser {
    String[] argv;
    ConversionProfile cp;

    public OptionParser(String[] argv, ConversionProfile cp) {
        this.argv = argv;
        this.cp = cp;
    }

    private void checkOptions() {
        try {
            if (this.cp.package_profile == null) {
                OptionParser.usage();
                System.exit(1);
            }
            if (this.cp.class_root == null) {
                this.cp.class_root = new String(System.getProperty("user.dir"));
            }
            this.enumerateClasses();
            if (this.cp.output == 0) {
                this.cp.output |= 1;
                this.cp.output |= 2;
                this.cp.output |= 4;
            }
            if (this.cp.output_dir == null) {
                this.cp.output_dir = this.cp.class_root;
            }
            if (this.cp.export_path == null) {
                String path = System.getProperty("java.class.path");
                this.cp.export_path = Strings.toStrings(path, File.pathSeparator);
            }
            if (this.cp.applets_profile == null) {
                this.cp.applets_profile = new AppletProfile[0];
            }
            if (this.cp.mask && (this.cp.output & 1) != 0) {
                Notifier.error("profile.7");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            OptionParser.usage();
            System.exit(1);
        }
    }

    private void enumerateClasses() {
        File class_dir;
        String package_name = this.cp.package_profile.package_name.replace('/', File.separatorChar);
        File class_root_dir = new File(this.cp.class_root);
        if (!class_root_dir.exists()) {
            Notifier.error("profile.3", this.cp.class_root);
            OptionParser.usage();
            System.exit(1);
        }
        if (!(class_dir = new File(class_root_dir, package_name)).exists()) {
            Notifier.error("profile.5", String.valueOf(this.cp.class_root) + File.separatorChar + package_name);
            OptionParser.usage();
            System.exit(1);
        }
        Object[] class_names = class_dir.list(new ClassFileNameFilter());
        Arrays.sort(class_names);
        if (class_names == null) {
            Notifier.error("profile.6");
            OptionParser.usage();
            System.exit(1);
        }
        this.cp.classes = new File[class_names.length];
        int i = 0;
        while (i < class_names.length) {
            this.cp.classes[i] = new File(class_dir, (String)class_names[i]);
            ++i;
        }
    }

    public void parse() {
        try {
            if (this.argv == null || this.argv.length == 0) {
                OptionParser.usage();
                System.exit(1);
            }
            if (this.argv[0].equals("-config")) {
                this.parseOptionsFromFile(this.argv);
            } else {
                this.parseOptionsFromCommandLine(this.argv);
            }
        }
        catch (Exception exception) {
            OptionParser.usage();
            System.exit(1);
        }
        this.checkOptions();
    }

    private void parseOptionsFromCommandLine(String[] argv) {
        Vector<AppletProfile> applet_vector = new Vector<AppletProfile>();
        int i = 0;
        while (i < argv.length) {
            block46: {
                if (argv[i].equals("-i")) {
                    this.cp.int_supported = true;
                } else if (argv[i].equals("-classdir")) {
                    this.cp.class_root = argv[++i];
                } else if (argv[i].equals("-exportpath")) {
                    this.cp.export_path = argv[++i].indexOf("/") != -1 ? Strings.toStrings(argv[i], ":") : Strings.toStrings(argv[i], File.pathSeparator);
                } else if (argv[i].equals("-exportmap")) {
                    this.cp.this_exp_provided = true;
                } else if (argv[i].equals("-applet")) {
                    AppletProfile applet_profile = new AppletProfile();
                    byte[] aid = null;
                    try {
                        aid = Strings.toByteArray(argv[++i], ":");
                    }
                    catch (Exception exception) {
                        Notifier.error("profile.4", argv[i]);
                        OptionParser.usage();
                        System.exit(1);
                    }
                    if (aid.length > 16 || aid.length < 5) {
                        Notifier.error("profile.1", argv[i]);
                        OptionParser.usage();
                        System.exit(1);
                    }
                    applet_profile.aid = aid;
                    applet_profile.install_class = argv[++i].replace('.', '/');
                    applet_vector.addElement(applet_profile);
                } else {
                    String version;
                    if (argv[i].equals("-out")) {
                        while (true) {
                            if (argv[i + 1].equals("JCA")) {
                                this.cp.output |= 4;
                                this.cp.deleteJCA = false;
                                ++i;
                                continue;
                            }
                            if (argv[i + 1].equals("CAP")) {
                                this.cp.output |= 1;
                                this.cp.output |= 4;
                                ++i;
                                continue;
                            }
                            if (argv[i + 1].equals("EXP")) {
                                this.cp.output |= 2;
                                ++i;
                                continue;
                            }
                            break block46;
                            break;
                        }
                    }
                    if (argv[i].equals("-d")) {
                        this.cp.output_dir = argv[++i];
                    } else if (argv[i].equals("-verbose")) {
                        Notifier.setVerboseFlag(true);
                    } else if (argv[i].equals("-v")) {
                        Notifier.setVerboseFlag(true);
                    } else if (argv[i].equals("-version")) {
                        version = new String(String.valueOf(String.valueOf(1)) + "." + String.valueOf(2));
                        Notifier.out("converter.version", version);
                        Notifier.out("converter.copyright");
                        System.exit(0);
                    } else if (argv[i].equals("-V")) {
                        version = new String(String.valueOf(String.valueOf(1)) + "." + String.valueOf(2));
                        Notifier.out("converter.version", version);
                        Notifier.out("converter.copyright");
                        System.exit(0);
                    } else if (argv[i].equals("-help")) {
                        OptionParser.usage();
                        System.exit(0);
                    } else if (argv[i].equals("-debug")) {
                        this.cp.debug = true;
                    } else if (argv[i].equals("-mask")) {
                        this.cp.mask = true;
                    } else if (argv[i].equals("-nowarn")) {
                        Notifier.setNoWarningFlag(true);
                    } else if (argv[i].equals("-nobanner")) {
                        Notifier.setNoBannerFlag(true);
                    } else {
                        if (argv[i].startsWith("-")) {
                            Notifier.error("profile.0", argv[i]);
                            OptionParser.usage();
                            System.exit(1);
                        }
                        this.cp.package_profile = new PackageProfile();
                        this.cp.package_profile.package_name = argv[i].replace('.', '/');
                        byte[] aid = null;
                        try {
                            aid = Strings.toByteArray(argv[++i], ":");
                        }
                        catch (Exception exception) {
                            Notifier.error("profile.4", argv[i]);
                            OptionParser.usage();
                            System.exit(1);
                        }
                        if (aid.length < 5 || aid.length > 16) {
                            Notifier.error("profile.1", argv[i]);
                            OptionParser.usage();
                            System.exit(1);
                        }
                        this.cp.package_profile.aid = aid;
                        byte[] versions = null;
                        try {
                            versions = Strings.toByteArray(argv[++i], ".");
                        }
                        catch (Exception exception) {
                            Notifier.error("profile.2", argv[i]);
                            OptionParser.usage();
                            System.exit(1);
                        }
                        if (versions.length != 2) {
                            Notifier.error("profile.2", argv[i]);
                            OptionParser.usage();
                            System.exit(1);
                        }
                        this.cp.package_profile.major_version = versions[0];
                        this.cp.package_profile.minor_version = versions[1];
                    }
                }
            }
            ++i;
        }
        this.cp.applets_profile = new AppletProfile[applet_vector.size()];
        applet_vector.copyInto(this.cp.applets_profile);
    }

    private void parseOptionsFromFile(String[] argv) {
        boolean i = false;
        String file_name = argv[1];
        Vector<String> tokens = new Vector<String>(20);
        try {
            String a_line;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(new FileInputStream(file_name)));
            while ((a_line = reader.readLine()) != null) {
                StringTokenizer parser = new StringTokenizer(a_line);
                while (parser.hasMoreTokens()) {
                    tokens.addElement(parser.nextToken());
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Notifier.error("converter.0", file_name);
            OptionParser.usage();
            System.exit(1);
        }
        catch (IOException iOException) {
            Notifier.error("converter.1", file_name);
            OptionParser.usage();
            System.exit(1);
        }
        Object[] arguments = new String[tokens.size()];
        tokens.copyInto(arguments);
        this.parseOptionsFromCommandLine((String[])arguments);
    }

    public static void usage() {
        int i = 0;
        while (i < 27) {
            Notifier.out("allusage." + i);
            ++i;
        }
    }
}

