/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.nbtasks.JCPackagerTask;
import com.sun.javacard.nbtasks.JCTask;
import com.sun.javacard.nbtasks.JCToolTask;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class ProxyTask
extends JCTask {
    public void execute() throws BuildException {
        if (!this.isClassicApplication() && !this.isClassicLibrary()) {
            return;
        }
        ProxyGenTask proxyGenTask = null;
        if (this.isClassicApplication() || this.isClassicLibrary()) {
            proxyGenTask = new ProxyGenTask(this.isClassicApplication());
            proxyGenTask.setProject(this.getProject());
            ((JCToolTask)proxyGenTask).execute();
        }
    }

    private static class ProxyGenTask
    extends JCPackagerTask {
        private final boolean classicApp;

        ProxyGenTask(boolean bl) {
            this.classicApp = bl;
        }

        protected void setAdditionalArguments() throws BuildException {
            if (this.classicApp) {
                this.setAdditionalArgumentsClassicApp();
            } else {
                this.setAdditionalArgumentsClassicLib();
            }
        }

        protected void setAdditionalArgumentsClassicApp() throws BuildException {
            this.createArg().setValue("--keepproxysource");
            File file = this.getProxyGenerationDir();
            this.log("Generating proxies to " + file.getAbsolutePath());
            this.createArg().setFile(file);
        }

        protected void setAdditionalArgumentsClassicLib() throws BuildException {
            this.createArg().setValue("--keepproxysource");
            this.createArg().setFile(this.getProxyGenerationDir());
        }

        private File getProxyGenerationDir() {
            File file = null;
            if (file == null) {
                file = this.getFileProp("proxy.generation.dir", false);
            }
            if (file == null) {
                file = new File(this.getProject().getBaseDir(), "dist" + File.separatorChar + "generated_proxies_src");
                this.log("Neither src.proxy.dir nor proxy.generation.dir set.  Defaulting to " + file.getAbsolutePath());
            }
            if (!file.exists()) {
                file.mkdirs();
            } else if (!file.isDirectory()) {
                throw new BuildException(file.getAbsolutePath() + " is not a folder");
            }
            return file;
        }
    }
}

