/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassComponent;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ImplementedInterface;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.util.Vector;

class RemoteInfo
extends Safeptr {
    int hashCollisionStringLength = -1;
    int nameOffset = -1;
    int HCSOffset = -1;
    int irio = -1;

    RemoteInfo(Safeptr p) {
        super(p);
    }

    int getRemoteMethodCount() {
        return this.u1(0);
    }

    Safeptr getRemoteMethodInfo(int n) {
        return this.offset(1 + 5 * n);
    }

    int getHCSOffset() {
        if (this.HCSOffset == -1) {
            this.HCSOffset = 1 + 5 * this.getRemoteMethodCount();
        }
        return this.HCSOffset;
    }

    int getHCSLength() {
        if (this.hashCollisionStringLength == -1) {
            this.hashCollisionStringLength = this.u1(this.getHCSOffset());
        }
        return this.hashCollisionStringLength;
    }

    int getClassNameOffset() {
        if (this.nameOffset == -1) {
            this.nameOffset = 1 + this.getHCSOffset() + this.getHCSLength();
        }
        return this.nameOffset;
    }

    int getClassNameLength() {
        return this.u1(this.getClassNameOffset());
    }

    Safeptr getName(int o) {
        return this.offset(o);
    }

    int getIRIO() {
        if (this.irio == -1) {
            this.irio = this.getClassNameOffset() + this.getClassNameLength() + 1;
        }
        return this.irio;
    }

    int getRemoteInterfaceCount() {
        return this.u1(this.getIRIO());
    }

    int findImplementedRemoteInterface(int remoteInterfaceRef) {
        int remoteInterfaceCount = this.getRemoteInterfaceCount();
        int infoOffset = this.getIRIO() + 1;
        for (int i = 0; i < remoteInterfaceCount; ++i) {
            int j = this.u2(infoOffset + i * 2);
            if (j != remoteInterfaceRef) continue;
            return i;
        }
        return -1;
    }

    int getRemoteDataLength() {
        int dataLength = 0;
        dataLength = 1 + 5 * this.getRemoteMethodCount();
        dataLength += 1 + this.getHCSLength();
        dataLength += 1 + this.getClassNameLength();
        return dataLength += 1 + 2 * this.getRemoteInterfaceCount();
    }

    void verifyRemoteInfo(ClassDescriptor cdesc, ClassInfo cinfo) {
        String hcsString = null;
        PackageInfo pkg = Cap.Header.thisPackage();
        ExportFile exportfile = ImportComponent.findExportByAidAndVersion(pkg);
        if (this.getHCSLength() > 0) {
            Safeptr hcsBuffer = this.offset(this.getHCSOffset() + 1);
            byte[] stringBytes = new byte[this.getHCSLength()];
            for (int i = 0; i < this.getHCSLength(); ++i) {
                stringBytes[i] = (byte)hcsBuffer.u1(i);
            }
            hcsString = new String(stringBytes);
        }
        this.verifyRemoteMethodInfo(cinfo);
        this.verifyClassName(cinfo);
        this.verifyRemoteInterfacesForClass(cdesc);
    }

    EfClass findClassByName(String name) {
        for (int i = 0; i < Cap.Import.importedPackages.size(); ++i) {
            ExportFile ef = Cap.Import.importedPackages.get(i);
            EfClass theClass = ef.findClassByName(name);
            if (theClass == null) continue;
            return theClass;
        }
        return null;
    }

    boolean isExternalMethodRemote(EfClass ec, EfMethod method) {
        int i;
        Vector<EfClass> interfacesList = new Vector<EfClass>();
        for (i = 0; i < ec.interfaces.length; ++i) {
            EfClass theClass = this.findClassByName(ec.interfaceName(i));
            if (theClass == null) continue;
            interfacesList.add(theClass);
        }
        for (i = 0; i < interfacesList.size(); ++i) {
            EfClass intrfc = (EfClass)interfacesList.elementAt(i);
            for (EfMethod element : intrfc.methods) {
                if (!element.name().equals(method.name()) || !element.sig().equals(method.sig())) continue;
                return (intrfc.accessFlag & 0x1000) != 0;
            }
        }
        return false;
    }

    void getMethodsFromExternalSuper(int superRef, Vector<Integer> methodList) {
        int pkgToken = Classref.packageToken(superRef);
        ExportFile ef = Cap.Import.exportfileForPackageToken(pkgToken);
        EfClass ec = Classref.checkExternal(superRef);
        for (EfMethod element : ec.methods) {
            if (!this.isExternalMethodRemote(ec, element)) continue;
            methodList.add(new Integer(element.token));
        }
    }

    Vector<Integer> makeMasterRemoteMethodList(ClassInfo cinfo) {
        Vector<Integer> methodList = new Vector<Integer>();
        int superRef = cinfo.superclass();
        while (superRef != 65535) {
            if (Classref.isExternal(superRef)) {
                this.getMethodsFromExternalSuper(superRef, methodList);
                break;
            }
            ClassInfo superClassInfo = Cap.Class.infoOfs(superRef);
            methodList.addAll(this.makeMasterRemoteMethodList(superClassInfo));
            superRef = superClassInfo.superclass();
        }
        ImplementedInterface intf = cinfo.firstImplementedInterface();
        for (int i = 0; i < cinfo.interfaceCount(); ++i) {
            boolean isInterfaceRemote = false;
            int intfRef = intf.interfaceImpl();
            if (!Classref.isExternal(intfRef)) {
                ClassInfo interfaceInfo = Cap.Class.infoOfs(intf.interfaceImpl());
                if ((interfaceInfo.flags() & 2) > 0) {
                    isInterfaceRemote = true;
                }
            } else {
                EfClass ec = Classref.checkExternal(intf.interfaceImpl());
                if ((ec.accessFlag & 0x1000) > 0) {
                    isInterfaceRemote = true;
                }
            }
            if (isInterfaceRemote) {
                int interfaceIndex;
                if (intfRef != Classref.Remote && (interfaceIndex = this.findImplementedRemoteInterface(intfRef)) < 0) {
                    throw new VerifierError("RemoteInfoError.42");
                }
                for (int j = 0; j < intf.count(); ++j) {
                    int tokenValue = intf.indexMethod(j);
                    if (this.findMethodWithToken(methodList, tokenValue) >= 0) continue;
                    methodList.add(new Integer(tokenValue));
                }
            }
            intf.next();
        }
        return methodList;
    }

    int findMethodWithToken(Vector<Integer> methodList, int token) {
        for (int i = 0; i < methodList.size(); ++i) {
            int tokenValue = methodList.elementAt(i);
            if (tokenValue != token) continue;
            return i;
        }
        return -1;
    }

    void verifyRemoteMethodInfo(ClassInfo cinfo) {
        Vector<Integer> masterMethodList = this.makeMasterRemoteMethodList(cinfo);
        int oldHash = 0;
        int remoteMethodCount = this.getRemoteMethodCount();
        if (remoteMethodCount > 128 || remoteMethodCount < 0) {
            throw new VerifierError("RemoteInfoError.12");
        }
        Vector<Integer> hashes = new Vector<Integer>(remoteMethodCount);
        for (int i = 0; i < remoteMethodCount; ++i) {
            Safeptr p = this.getRemoteMethodInfo(i);
            Integer methodHash = new Integer(p.u2(0));
            if (oldHash > methodHash) {
                throw new VerifierError("RemoteInfoError.15");
            }
            if (hashes.indexOf(methodHash) != -1) {
                throw new VerifierError("RemoteInfoError.13");
            }
            oldHash = methodHash;
            hashes.add(methodHash);
            int typeDescriptorOffset = p.u2(2);
            RemoteInfo.verifyRemoteMethodTypeDescr(Cap.Class.signaturePool.offset(typeDescriptorOffset));
            int token = p.u1(4);
            MethodTypeAndFlags mtyf = Methodref.findByToken(cinfo.ofs, token, false);
            this.checkIfMethodIsRemote(Cap.Class.signaturePool.offset(typeDescriptorOffset), token, cinfo);
            int tokenIndex = this.findMethodWithToken(masterMethodList, token);
            if (tokenIndex < 0) {
                throw new VerifierError("RemoteInfoError.43");
            }
            masterMethodList.remove(tokenIndex);
        }
        if (masterMethodList.size() > 0) {
            throw new VerifierError("RemoteInfoError.44");
        }
    }

    void checkIfMethodIsRemote(Safeptr typtr, int methodToken, ClassInfo cinfo) {
        while (cinfo != null) {
            int count = cinfo.interfaceCount();
            ImplementedInterface intf = cinfo.firstImplementedInterface();
            for (int i = 0; i < count; ++i) {
                for (int intfToken = 0; intfToken < intf.count(); ++intfToken) {
                    int implToken = intf.indexMethod(intfToken);
                    if (implToken != methodToken) continue;
                    if (!Classref.isExternal(intf.interfaceImpl())) {
                        this.checkInternalInterface(intfToken, typtr, intf);
                    } else {
                        this.checkExternalInterface(intfToken, typtr, intf, cinfo);
                    }
                    return;
                }
                intf.next();
            }
            int superRef = cinfo.superclass();
            if (superRef == 65535) {
                cinfo = null;
                continue;
            }
            if (Classref.isExternal(superRef)) {
                this.checkExternalClass(superRef, methodToken);
                break;
            }
            cinfo = Cap.Class.infoOfs(superRef);
        }
    }

    private void checkInternalInterface(int intfToken, Safeptr typtr, ImplementedInterface intf) {
        ClassInfo interfaceInfo = Cap.Class.infoOfs(intf.interfaceImpl());
        ClassDescriptor cdesc = Classref.checkInternal(intf.interfaceImpl());
        if (!Classref.extendsInterface(cdesc.thisClass(), Classref.Remote) && (interfaceInfo.flags() & 2) != 0) {
            throw new VerifierError("RemoteInfoError.26");
        }
        for (int i = 0; i < cdesc.methodCount(); ++i) {
            MethodDescriptor md = cdesc.methodDescr(i);
            if (md.token() != intfToken) continue;
            int typeOffset = md.type();
            Safeptr td = Cap.TypeDescr.at(typeOffset);
            if (this.matchDescriptors(typtr, td)) {
                return;
            }
            throw new VerifierError("RemoteInfoError.40");
        }
    }

    private void checkExternalInterface(int intfToken, Safeptr typtr, ImplementedInterface intf, ClassInfo cinfo) {
        EfClass ec = Classref.checkExternal(intf.interfaceImpl());
        if ((ec.accessFlag & 0x1000) == 0) {
            throw new VerifierError("RemoteInfoError.26");
        }
        for (EfMethod m : ec.methods) {
            if (m.token != intfToken) continue;
            boolean isStatic = (m.accessFlag & 8) != 0 || m.name().equals("<init>");
            MethodTypeAndFlags mtyf = Methodref.findByToken(cinfo.ofs, m.token, isStatic);
            if (mtyf == null) {
                throw new VerifierError("ExportComponent.38");
            }
            TypeMethod typeInExport = TypeMethod.parseExport(m.sig());
            TypeMethod typeInSP = TypeMethod.parseCap(typtr);
            if (!typeInSP.equals(typeInExport)) continue;
            return;
        }
        throw new VerifierError("RemoteInfoError.27");
    }

    private void checkExternalClass(int superRef, int implToken) {
        EfClass ec;
        String methodName = null;
        String methodDescriptor = null;
        boolean found = false;
        int superCount = 0;
        int pkgToken = Classref.packageToken(superRef);
        ExportFile ef = Cap.Import.exportfileForPackageToken(pkgToken);
        EfClass mainSuper = ec = Classref.checkExternal(superRef);
        do {
            for (EfMethod m : ec.methods) {
                if (m.token != implToken) continue;
                methodName = m.name();
                methodDescriptor = m.sig();
                found = true;
                break;
            }
            if (found) {
                for (int i = 0; i < ec.interfaces.length; ++i) {
                    EfClass requiredInterface = ef.findClassByName(ec.interfaceName(i));
                    if (requiredInterface == null) continue;
                    for (EfMethod m : requiredInterface.methods) {
                        if (!methodName.equals(m.name()) || !methodDescriptor.equals(m.sig())) continue;
                        if ((requiredInterface.accessFlag & 0x1000) == 0) {
                            throw new VerifierError("RemoteInfoError.26");
                        }
                        return;
                    }
                }
            }
            if (mainSuper.supers.length <= superCount) {
                throw new VerifierError("RemoteInfoError.4");
            }
            ec = ef.findClassByName(ec.superName(superCount++));
        } while (ec != null);
    }

    private boolean matchDescriptors(Safeptr td1, Safeptr td2) {
        int nc2;
        int nc1 = td1.u1(0);
        if (nc1 != (nc2 = td2.u1(0))) {
            return false;
        }
        for (int i = 2; i <= nc1 + 1; ++i) {
            if (td1.nibble(i) == td2.nibble(i)) continue;
            return false;
        }
        return true;
    }

    static void verifyRemoteMethodTypeDescr(Safeptr typtr) {
        int i;
        int nibbleCount = typtr.u1(0);
        boolean refReturn = false;
        if (nibbleCount >= 5) {
            Safeptr ref = typtr.offset(1);
            int refNibble = ref.nibble(nibbleCount - 5);
            if (refNibble == 6) {
                int tokenValue = 0;
                for (int i2 = 1; i2 <= 4; ++i2) {
                    tokenValue = tokenValue << 4 | ref.nibble(nibbleCount - 5 + i2);
                }
                if (!Classref.isExternal(tokenValue)) {
                    ClassInfo cinfo = Cap.Class.infoOfs(tokenValue);
                    if ((cinfo.flags() & 2) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                    if ((cinfo.flags() & 8) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                } else {
                    EfClass ec = Classref.checkExternal(tokenValue);
                    if ((ec.accessFlag & 0x1000) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                    if ((ec.accessFlag & 0x200) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                }
                nibbleCount -= 5;
                refReturn = true;
            } else if (refNibble == 14) {
                throw new VerifierError("RemoteInfoError.19");
            }
        }
        Safeptr p = typtr.offset(1);
        if (nibbleCount == 0 && !refReturn) {
            throw new VerifierError("RemoteInfoError.25");
        }
        block5: for (i = 0; i < nibbleCount; ++i) {
            switch (p.nibble(i)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    continue block5;
                }
                case 6: 
                case 14: {
                    throw new VerifierError("RemoteInfoError.20", null);
                }
            }
            throw new VerifierError("RemoteInfoError.22", p.nibble(i), (Object)typtr);
        }
        if (i > nibbleCount) {
            throw new VerifierError("RemoteInfoError.23", typtr);
        }
        if (refReturn) {
            nibbleCount += 5;
        }
        if ((nibbleCount & 1) == 1 && p.nibble(nibbleCount) != 0) {
            throw new VerifierError("RemoteInfoError.24");
        }
    }

    void verifyClassName(ClassInfo cinfo) {
        String className;
        int classNameOffset = this.getClassNameOffset() + 1;
        Safeptr nameBytes = this.getName(classNameOffset);
        int nameLength = this.getClassNameLength();
        if (nameLength > 0) {
            className = ClassInfo.getStringFromBytes(nameLength, nameBytes);
            if (className.indexOf("/") > -1 || !EfNames.validClassName(className)) {
                throw new VerifierError("RemoteInfoError.11", className);
            }
            if (ClassComponent.classNamesVector.contains(className)) {
                throw new VerifierError("RemoteInfoError.14", className);
            }
        } else {
            throw new VerifierError("RemoteInfoError.10");
        }
        ClassComponent.classNamesVector.add(className);
    }

    void verifyRemoteInterfacesForClass(ClassDescriptor cdesc) {
        int remoteInterfaceCount = this.getRemoteInterfaceCount();
        if (remoteInterfaceCount > 128 || remoteInterfaceCount < 0) {
            throw new VerifierError("RemoteInfoError.30");
        }
        int infoOffset = this.getIRIO() + 1;
        for (int i = 0; i < remoteInterfaceCount; ++i) {
            int j = this.u2(infoOffset + i * 2);
            if (!Classref.isExternal(j)) {
                ClassInfo interfaceInfo = Cap.Class.infoOfs(j);
                if ((interfaceInfo.flags() & 2) == 0) {
                    throw new VerifierError("RemoteInfoError.45");
                }
            } else {
                EfClass ec = Classref.checkExternal(j);
                if ((ec.accessFlag & 0x1000) == 0) {
                    throw new VerifierError("RemoteInfoError.45");
                }
            }
            if (ClassComponent.classInfoImplementsInterface(cdesc.thisClass(), j)) continue;
            throw new VerifierError("RemoteInfoError.31");
        }
    }

    static void verifyRemoteInterface(ClassDescriptor cdesc) {
        if ((cdesc.flags() & 1) != 1) {
            throw new VerifierError("RemoteInfoError.41");
        }
        int methodCount = cdesc.methodCount();
        for (int i = 0; i < methodCount; ++i) {
            int methodTypeDescOffset = cdesc.methodDescr(i).type();
            Safeptr td = Cap.TypeDescr.at(methodTypeDescOffset);
            RemoteInfo.verifyRemoteMethodTypeDescr(td);
        }
    }
}

