/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.DirectoryComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CapWriter {
    protected File file;
    protected String packageName;
    protected long timeStamp;

    public CapWriter(File file, String packageName) {
        this.file = file;
        this.packageName = packageName;
        this.timeStamp = System.currentTimeMillis();
    }

    private void addZipEntry(ZipOutputStream zos, String name, Component component) throws IOException {
        byte[] data = component.toByteArray();
        ZipEntry ze = new ZipEntry(String.valueOf(this.packageName) + "/javacard/" + name);
        ze.setSize(data.length);
        ze.setTime(this.timeStamp);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        ze.setCrc(crc.getValue());
        zos.putNextEntry(ze);
        zos.write(data, 0, data.length);
    }

    private void addZipEntry(ZipOutputStream zos, String name, byte[] data) throws IOException {
        ZipEntry ze = new ZipEntry(String.valueOf(this.packageName) + "/javacard/" + name);
        ze.setSize(data.length);
        ze.setTime(this.timeStamp);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        ze.setCrc(crc.getValue());
        zos.putNextEntry(ze);
        zos.write(data, 0, data.length);
    }

    private void mergeClassDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map offsets) throws IOException {
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        dos.writeShort(dis.readUnsignedShort());
        dis.readUnsignedShort();
        String name = strings[name_index];
        Integer offset = (Integer)offsets.get(name);
        dos.writeShort(offset);
        dos.writeShort(dis.readUnsignedShort());
        dos.writeShort(dis.readUnsignedShort());
        int interface_count = dis.readUnsignedByte();
        dos.writeByte(interface_count);
        int field_count = dis.readUnsignedShort();
        dos.writeShort(field_count);
        int method_count = dis.readUnsignedShort();
        dos.writeShort(method_count);
        int i = 0;
        while (i < interface_count) {
            dos.writeShort(dis.readUnsignedShort());
            ++i;
        }
        int f = 0;
        while (f < field_count) {
            this.mergeFieldDebugInfo(dis, dos, strings, offsets, name);
            ++f;
        }
        int m = 0;
        while (m < method_count) {
            this.mergeMethodDebugInfo(dis, dos, strings, offsets, name);
            ++m;
        }
    }

    private void mergeDebugComponent(DataInputStream dis, DataOutputStream dos, Map offsets) throws IOException {
        dos.writeByte(dis.readUnsignedByte());
        dos.writeShort(dis.readUnsignedShort());
        int AID_length = dis.readUnsignedByte();
        dos.writeByte(AID_length);
        byte[] component_AID = new byte[AID_length];
        dis.read(component_AID);
        dos.write(component_AID, 0, AID_length);
        dos.writeByte(dis.readUnsignedByte());
        dos.writeByte(dis.readUnsignedByte());
        int string_count = dis.readUnsignedShort();
        dos.writeShort(string_count);
        String[] strings = new String[string_count];
        int s = 0;
        while (s < string_count) {
            strings[s] = dis.readUTF();
            dos.writeUTF(strings[s]);
            ++s;
        }
        dos.writeShort(dis.readUnsignedShort());
        int class_count = dis.readUnsignedShort();
        dos.writeShort(class_count);
        int c = 0;
        while (c < class_count) {
            this.mergeClassDebugInfo(dis, dos, strings, offsets);
            ++c;
        }
    }

    private byte[] mergeDebugOffsets(ClassComponent classes, MethodComponent methods, StaticFieldComponent staticFields) {
        Hashtable offsets = new Hashtable();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        classes.getDebugOffsets(offsets);
        methods.getDebugOffsets(offsets);
        staticFields.getDebugOffsets(offsets);
        try {
            if (Globals.outputDebugData != null) {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(Globals.outputDebugData));
                this.mergeDebugComponent(dis, dos, offsets);
            }
            bos.flush();
        }
        catch (IOException iOException) {}
        return bos.toByteArray();
    }

    private void mergeFieldDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map offsets, String className) throws IOException {
        boolean isPrimitive;
        int ACC_STATIC = 8;
        int ACC_FINAL = 16;
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        int descriptor_index = dis.readUnsignedShort();
        dos.writeShort(descriptor_index);
        int access_flags = dis.readUnsignedShort();
        dos.writeShort(access_flags);
        boolean isStatic = (access_flags & 8) != 0;
        boolean isFinal = (access_flags & 0x10) != 0;
        boolean bl = isPrimitive = strings[descriptor_index].length() == 1;
        if (isStatic & (isFinal & isPrimitive ^ true)) {
            dos.writeShort(dis.readUnsignedShort());
            dis.readUnsignedShort();
            String name = String.valueOf(className) + "/" + strings[name_index];
            Integer offset = (Integer)offsets.get(name);
            dos.writeShort(offset);
        } else {
            dos.writeInt(dis.readInt());
        }
    }

    private void mergeMethodDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map offsets, String className) throws IOException {
        int ACC_ABSTRACT = 1024;
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        int descriptor_index = dis.readUnsignedShort();
        dos.writeShort(descriptor_index);
        int access_flags = dis.readUnsignedShort();
        dos.writeShort(access_flags);
        boolean isAbstract = (access_flags & 0x400) != 0;
        dis.readUnsignedShort();
        if (isAbstract) {
            dos.writeShort(0);
        } else {
            String name = strings[name_index];
            String descriptor = strings[descriptor_index];
            String signature = String.valueOf(className) + "/" + name + descriptor;
            Integer offset = (Integer)offsets.get(signature);
            dos.writeShort(offset);
        }
        dos.writeByte(dis.readUnsignedByte());
        dos.writeShort(dis.readUnsignedShort());
        int variable_count = dis.readUnsignedShort();
        dos.writeShort(variable_count);
        int line_count = dis.readUnsignedShort();
        dos.writeShort(line_count);
        int v = 0;
        while (v < variable_count) {
            dos.writeByte(dis.readUnsignedByte());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            ++v;
        }
        int k = 0;
        while (k < line_count) {
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            ++k;
        }
    }

    public void publish(HeaderComponent header, DirectoryComponent directory, AppletComponent applet, ImportComponent imports, ConstantPoolComponent constantPool, ClassComponent classes, MethodComponent methods, StaticFieldComponent staticFields, ReferenceLocationComponent referenceLocation, ExportComponent export, DescriptorComponent descriptor) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(this.file));
        }
        catch (IOException iOException) {
            Object[] arguments = new Object[]{this.file.getAbsolutePath()};
            Msg.error("capWriter.1", arguments);
            return;
        }
        zos.setMethod(0);
        this.addZipEntry(zos, "Header.cap", header);
        this.addZipEntry(zos, "Directory.cap", directory);
        if (applet != null) {
            this.addZipEntry(zos, "Applet.cap", applet);
        }
        this.addZipEntry(zos, "Import.cap", imports);
        this.addZipEntry(zos, "ConstantPool.cap", constantPool);
        this.addZipEntry(zos, "Class.cap", classes);
        this.addZipEntry(zos, "Method.cap", methods);
        this.addZipEntry(zos, "StaticField.cap", staticFields);
        this.addZipEntry(zos, "RefLocation.cap", referenceLocation);
        if (export != null) {
            this.addZipEntry(zos, "Export.cap", export);
        }
        if (descriptor != null) {
            this.addZipEntry(zos, "Descriptor.cap", descriptor);
        }
        if (Globals.outputDebugData != null) {
            byte[] debugData = this.mergeDebugOffsets(classes, methods, staticFields);
            this.addZipEntry(zos, "Debug.cap", debugData);
        }
        zos.close();
    }
}

