/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JExceptionRecord;
import com.sun.javacard.classfile.instructions.JInstrIntBranch;
import com.sun.javacard.classfile.instructions.JInstrLookupSwitch;
import com.sun.javacard.classfile.instructions.JInstrNoOperands;
import com.sun.javacard.classfile.instructions.JInstrShortBranch;
import com.sun.javacard.classfile.instructions.JInstrTableSwitch;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.ClassConverter;
import com.sun.javacard.converter.converters.ExceptionTableConverter;
import com.sun.javacard.converter.converters.I2SException;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstrLoadConverter;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.LocalVariableConverter;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.converters.RecalculateIndexException;
import com.sun.javacard.converter.converters.RollBackException;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class MethodConverter {
    private JMethod java_method;
    private JcMethod jc_method;
    private ClassConverter c_converter;
    private PackageConverter p_converter;
    private InstrContainer instr_containers;
    private LocalVariableConverter local_var_converter;
    private JcLocalVariable[] jc_locals;
    private JcException[] jc_exceptions;
    private int nargs;
    private int max_locals;
    private int max_stack;

    public MethodConverter(JMethod jMethod, ClassConverter classConverter, PackageConverter packageConverter) {
        this.java_method = jMethod;
        this.c_converter = classConverter;
        this.p_converter = packageConverter;
        this.jc_method = new JcMethod(jMethod);
        if (classConverter.getJcClass().getEfClass() != null) {
            this.jc_method.setEfMethod(classConverter.getJcClass().getEfClass().getMethod(jMethod.getMethodName(), jMethod.getMethodDescriptor()));
        }
    }

    public InstrContainer getInstrContainers() {
        return this.instr_containers;
    }

    public boolean isIntSupported() {
        return this.p_converter.isIntSupported();
    }

    public JcConstantPool getJcConstantPool() {
        return this.p_converter.getJcConstantPool();
    }

    public String getClassName() {
        return this.c_converter.getJavaClass().getClassName();
    }

    public String getMethodName() {
        return this.java_method.getMethodName();
    }

    public String getMethodDescriptor() {
        return this.java_method.getMethodDescriptor();
    }

    public ClassConverter getClassConverter() {
        return this.c_converter;
    }

    public PackageConverter getPackageConverter() {
        return this.p_converter;
    }

    public JMethod getJavaMethod() {
        return this.java_method;
    }

    public JcMethod getJcMethod() {
        return this.jc_method;
    }

    public JcMethod convert() throws Exception {
        Object object;
        int n;
        if ((this.java_method.isPublic() || this.java_method.isProtected()) && this.getClassConverter().getJavaClass().isPublic()) {
            this.checkMethodSignature();
        }
        if (!this.getMethodName().equals("<init>")) {
            // empty if block
        }
        if (!this.p_converter.convertByteCode()) {
            return this.jc_method;
        }
        JInstruction jInstruction = this.java_method.getCode();
        if (jInstruction == null) {
            this.jc_exceptions = new JcException[0];
            this.jc_method.setExceptions(this.jc_exceptions);
            this.jc_locals = new JcLocalVariable[0];
            this.jc_method.setLocalVariables(this.jc_locals);
            for (int i = 0; i < this.jc_locals.length; ++i) {
                if (!"I".equals(this.jc_locals[i].getDescriptor())) continue;
                this.getPackageConverter().getJcPackage().setIntFlag(true);
            }
            this.setNargs();
            return this.jc_method;
        }
        this.jc_locals = this.computeLocals();
        this.jc_method.setLocalVariables(this.jc_locals);
        for (n = 0; n < this.jc_locals.length; ++n) {
            if (this.jc_locals[n] == null || this.jc_locals[n].getDescriptor() == null || !"I".equals(this.jc_locals[n].getDescriptor())) continue;
            this.getPackageConverter().getJcPackage().setIntFlag(true);
        }
        this.constructInstrContainers(jInstruction);
        this.constructControlFlowGraph();
        this.jc_exceptions = this.constructExceptions();
        this.jc_method.setExceptions(this.jc_exceptions);
        n = 0;
        this.instr_containers.setOperandStack(new OperandStack());
        while (n == 0) {
            n = 1;
            object = this.instr_containers;
            while (object != null) {
                int n2;
                Object object2;
                Object object3;
                try {
                    Object object4;
                    if (((InstrContainer)object).isCatchFinallyBlockLeader() && ((InstrContainer)object).getOperandStack() == null) {
                        object4 = new OperandStack();
                        ((OperandStack)object4).push(10, null);
                        ((InstrContainer)object).setOperandStack((OperandStack)object4);
                    }
                    if (((InstrContainer)object).hasChanged()) {
                        block19: {
                            n = 0;
                            ((InstrContainer)object).reset();
                            object4 = ((InstrContainer)object).getJInstr();
                            object3 = InstructionConverter.create((InstrContainer)object, this);
                            try {
                                object2 = ((InstructionConverter)object3).convert();
                                ((InstrContainer)object).setJcInstr((JcInstruction)object2);
                            }
                            catch (I2SException i2SException) {
                                ((InstrContainer)object).setJcInstr(i2SException.getJcInstruction());
                                if (i2SException.isBefore() && i2SException.getNumInstrBack() == 0 && ((InstrContainer)object).getJcInstr().getOpcode() != 94 && ((InstrContainer)object).getPrevInstrContainer() != null && ((InstrContainer)object).getPrevInstrContainer().getJcInstr().getOpcode() != 94) {
                                    this.insertI2SBefore((InstrContainer)object);
                                }
                                if (i2SException.getNumInstrBack() <= 0) break block19;
                                n2 = i2SException.getNumInstrBack();
                                Object object5 = object;
                                while (n2-- > 0) {
                                    object5 = ((InstrContainer)object5).getPrevInstrContainer();
                                }
                                if (i2SException.isBefore()) {
                                    this.insertI2SBefore((InstrContainer)object5);
                                }
                                this.insertI2SAfter((InstrContainer)object5);
                            }
                        }
                        this.checkForcedTypeAndPromote((InstrContainer)object);
                        this.propagateInfo((InstrContainer)object);
                        this.setSourceLineNumber((InstrContainer)object);
                        this.setJcInstrLabel((InstrContainer)object);
                        ((InstrContainer)object).setChangedFlag(false);
                        ((InstrContainer)object).setVisited(true);
                    }
                    object = ((InstrContainer)object).getNextInstrContainer();
                }
                catch (RollBackException rollBackException) {
                    object3 = object;
                    object = rollBackException.getRollBackPoint();
                    if (!rollBackException.isCastDownI2S()) {
                        ((InstrContainer)object).setForcedType(3);
                        ((InstrContainer)object).setChangedFlag(true);
                        if (this.local_var_converter.getDefinedLocalVariablesSize() != 0 || !((object2 = InstructionConverter.create((InstrContainer)object, this)) instanceof InstrLoadConverter) || this.local_var_converter.getJcLocalVariable(n2 = ((InstrLoadConverter)object2).getJavaLocalIndex()).isVarTypeKnown() || this.local_var_converter.getJcLocalVariable(n2).isPromoted()) continue;
                        this.local_var_converter.updateJcLocalVariable(n2, "I");
                        this.local_var_converter.getJcLocalVariable(n2).setPromoted(true);
                        this.local_var_converter.recomputeUndefIndexes(n2);
                        object = this.setAllToChangedAndRestart((InstrContainer)object);
                        ((InstrContainer)object).setChangedFlag(true);
                        continue;
                    }
                    this.insertI2SAfter((InstrContainer)object);
                    ((InstrContainer)object).setChangedFlag(true);
                    object = this.setAllToChangedAndReset((InstrContainer)object3, (InstrContainer)object);
                }
                catch (RecalculateIndexException recalculateIndexException) {
                    ((InstrContainer)object).setChangedFlag(true);
                    this.local_var_converter.recomputeUndefIndexes(recalculateIndexException.getIndex());
                    object = this.setAllToChangedAndRestart((InstrContainer)object);
                }
            }
        }
        object = this.linkJcInstructions();
        this.jc_method.setCode((JcInstruction)object);
        this.setNargs();
        this.setMaxLocals();
        this.setMaxStack();
        return this.jc_method;
    }

    private InstrContainer setAllToChangedAndRestart(InstrContainer instrContainer) {
        InstrContainer instrContainer2 = instrContainer;
        while (instrContainer.getPrevInstrContainer() != null) {
            if (instrContainer.isVisited()) {
                instrContainer.setChangedFlag(true);
            }
            instrContainer = instrContainer.getPrevInstrContainer();
        }
        if (instrContainer.isVisited()) {
            instrContainer.setChangedFlag(true);
        }
        while (instrContainer2.getNextInstrContainer() != null) {
            if (instrContainer2.isVisited()) {
                instrContainer2.setChangedFlag(true);
            }
            instrContainer2 = instrContainer2.getNextInstrContainer();
        }
        if (instrContainer2.isVisited()) {
            instrContainer2.setChangedFlag(true);
        }
        return instrContainer;
    }

    private InstrContainer setAllToChangedAndReset(InstrContainer instrContainer, InstrContainer instrContainer2) {
        InstrContainer instrContainer3 = instrContainer;
        instrContainer3.setChangedFlag(true);
        instrContainer3.resetStack();
        while (instrContainer.getPrevInstrContainer() != null && instrContainer != instrContainer2) {
            if (instrContainer.isVisited()) {
                instrContainer.setChangedFlag(true);
                instrContainer.resetStack();
            }
            instrContainer = instrContainer.getPrevInstrContainer();
        }
        if (instrContainer.isVisited()) {
            instrContainer.setChangedFlag(true);
            instrContainer.resetWorkingStack();
        }
        while (instrContainer3.getNextInstrContainer() != null) {
            if (instrContainer3.isVisited()) {
                instrContainer3.setChangedFlag(true);
                instrContainer3.resetStack();
            }
            if (instrContainer3 == instrContainer2) break;
            instrContainer3 = instrContainer3.getNextInstrContainer();
        }
        if (instrContainer3.isVisited()) {
            instrContainer3.setChangedFlag(true);
            instrContainer3.resetStack();
        }
        return instrContainer;
    }

    private void constructInstrContainers(JInstruction jInstruction) {
        InstrContainer instrContainer = this.instr_containers = new InstrContainer(jInstruction);
        while (jInstruction.getNextInstr() != null) {
            jInstruction = jInstruction.getNextInstr();
            InstrContainer instrContainer2 = new InstrContainer(jInstruction);
            instrContainer.setNextInstrContainer(instrContainer2);
            instrContainer2.setPrevInstrContainer(instrContainer);
            instrContainer = instrContainer2;
        }
    }

    private void constructControlFlowGraph() {
        this.instr_containers.setLabelFlag(true);
        this.instr_containers.setControlFlowLabelFlag(true);
        this.linkExceptions();
        for (InstrContainer instrContainer = this.instr_containers; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            InstrContainer instrContainer2;
            JInstruction jInstruction = instrContainer.getJInstr();
            if (jInstruction instanceof JInstrShortBranch) {
                this.linkShortBranchInstr(instrContainer);
                continue;
            }
            if (jInstruction instanceof JInstrIntBranch) {
                this.linkIntBranchInstr(instrContainer);
                continue;
            }
            if (jInstruction instanceof JInstrTableSwitch || jInstruction instanceof JInstrLookupSwitch) {
                this.linkSwitchInstr(instrContainer);
                continue;
            }
            if (this.isUnconditionalBranch(jInstruction)) {
                instrContainer2 = instrContainer.getNextInstrContainer();
                if (instrContainer2 == null) continue;
                instrContainer2.setLabelFlag(true);
                instrContainer2.setControlFlowLabelFlag(true);
                continue;
            }
            instrContainer2 = instrContainer.getNextInstrContainer();
            if (instrContainer2 == null) continue;
            instrContainer.link(instrContainer2);
        }
        this.linkRetInstructions();
        if (this.p_converter.getConversionProfile().debug) {
            this.setLocalVarsScope();
        }
        this.setContainerLabels();
        if (this.p_converter.getConversionProfile().debug) {
            this.setLocalVarsLabels();
        }
    }

    private void setLocalVarsScope() {
        JcLocalVariable[] jcLocalVariableArray = this.jc_locals;
        int n = jcLocalVariableArray.length;
        for (int i = 0; i < n; ++i) {
            for (JcLocalVariable jcLocalVariable = jcLocalVariableArray[i]; jcLocalVariable != null; jcLocalVariable = jcLocalVariable.getNext()) {
                this.setLocalVarScope(jcLocalVariable);
            }
        }
    }

    private void setLocalVarScope(JcLocalVariable jcLocalVariable) {
        JInstruction jInstruction;
        InstrContainer instrContainer;
        int n = jcLocalVariable.getJStartPC();
        int n2 = n + jcLocalVariable.getJLength();
        for (instrContainer = this.instr_containers; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            jInstruction = instrContainer.getJInstr();
            if (n != jInstruction.getPC()) continue;
            instrContainer.setLabelFlag(true);
            break;
        }
        for (instrContainer = this.instr_containers; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            jInstruction = instrContainer.getJInstr();
            if (n2 != jInstruction.getPC()) continue;
            instrContainer.setLabelFlag(true);
            break;
        }
    }

    private void setLocalVarsLabels() {
        JcLocalVariable[] jcLocalVariableArray = this.jc_locals;
        int n = jcLocalVariableArray.length;
        for (int i = 0; i < n; ++i) {
            for (JcLocalVariable jcLocalVariable = jcLocalVariableArray[i]; jcLocalVariable != null; jcLocalVariable = jcLocalVariable.getNext()) {
                this.setLocalVarLabel(jcLocalVariable);
            }
        }
    }

    private void setLocalVarLabel(JcLocalVariable jcLocalVariable) {
        JInstruction jInstruction;
        InstrContainer instrContainer;
        int n = jcLocalVariable.getJStartPC();
        int n2 = n + jcLocalVariable.getJLength();
        int n3 = -1;
        int n4 = -1;
        for (instrContainer = this.instr_containers; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            jInstruction = instrContainer.getJInstr();
            if (n != jInstruction.getPC()) continue;
            n3 = instrContainer.getLabel();
            break;
        }
        for (instrContainer = this.instr_containers; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            jInstruction = instrContainer.getJInstr();
            if (n2 != jInstruction.getPC()) continue;
            n4 = instrContainer.getLabel();
            break;
        }
        jcLocalVariable.setJcStartPCLabel(n3);
        jcLocalVariable.setJcEndPCLabel(n4);
    }

    private void linkShortBranchInstr(InstrContainer instrContainer) {
        JInstruction jInstruction = instrContainer.getJInstr();
        int n = ((JInstrShortBranch)jInstruction).getBranchOffset();
        InstrContainer instrContainer2 = this.findTargetInstrContainer(jInstruction.getPC(), n);
        instrContainer2.setLabelFlag(true);
        instrContainer2.setControlFlowLabelFlag(true);
        instrContainer.link(instrContainer2);
        InstrContainer instrContainer3 = instrContainer.getNextInstrContainer();
        if (instrContainer3 != null) {
            instrContainer3.setLabelFlag(true);
            instrContainer3.setControlFlowLabelFlag(true);
            if (!this.isUnconditionalBranch(jInstruction)) {
                instrContainer.link(instrContainer3);
            }
            if (jInstruction.getOpcode() == 168) {
                instrContainer.link(instrContainer3);
            }
        }
    }

    private void linkIntBranchInstr(InstrContainer instrContainer) {
        JInstruction jInstruction = instrContainer.getJInstr();
        int n = ((JInstrIntBranch)jInstruction).getBranchOffset();
        InstrContainer instrContainer2 = this.findTargetInstrContainer(jInstruction.getPC(), n);
        instrContainer2.setLabelFlag(true);
        instrContainer2.setControlFlowLabelFlag(true);
        instrContainer.link(instrContainer2);
        InstrContainer instrContainer3 = instrContainer.getNextInstrContainer();
        if (instrContainer3 != null) {
            instrContainer3.setLabelFlag(true);
            instrContainer3.setControlFlowLabelFlag(true);
            instrContainer.link(instrContainer3);
        }
    }

    private void linkSwitchInstr(InstrContainer instrContainer) {
        JInstruction jInstruction;
        InstrContainer instrContainer2 = instrContainer.getNextInstrContainer();
        if (instrContainer2 != null) {
            instrContainer2.setLabelFlag(true);
            instrContainer2.setControlFlowLabelFlag(true);
        }
        int n = (jInstruction = instrContainer.getJInstr()) instanceof JInstrTableSwitch ? ((JInstrTableSwitch)jInstruction).getDefaultBranchOffset() : ((JInstrLookupSwitch)jInstruction).getDefaultBranchOffset();
        InstrContainer instrContainer3 = this.findTargetInstrContainer(jInstruction.getPC(), n);
        if (instrContainer3 != null) {
            instrContainer3.setLabelFlag(true);
            instrContainer3.setControlFlowLabelFlag(true);
            instrContainer.link(instrContainer3);
        }
        int[] nArray = jInstruction instanceof JInstrTableSwitch ? ((JInstrTableSwitch)jInstruction).getBranchOffsets() : ((JInstrLookupSwitch)jInstruction).getMatchOffsets();
        for (int n2 : nArray) {
            instrContainer3 = this.findTargetInstrContainer(jInstruction.getPC(), n2);
            if (instrContainer3 == null) continue;
            instrContainer3.setLabelFlag(true);
            instrContainer3.setControlFlowLabelFlag(true);
            instrContainer.link(instrContainer3);
        }
    }

    private void linkRetInstructions() {
        for (InstrContainer instrContainer = this.instr_containers; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            InstrContainer instrContainer2;
            JInstruction jInstruction = instrContainer.getJInstr();
            if (jInstruction.getOpcode() != 168) continue;
            InstrContainer instrContainer3 = instrContainer.findRetInstrContainer();
            if (instrContainer3 == null) {
                // empty if block
            }
            if ((instrContainer2 = instrContainer.getNextInstrContainer()) == null) {
                throw new ConverterInternalError();
            }
            if (instrContainer3 == null) continue;
            instrContainer3.link(instrContainer2);
        }
    }

    private void linkExceptions() {
        JExceptionRecord[] jExceptionRecordArray;
        JCodeAttr jCodeAttr = this.java_method.getCodeAttr();
        for (JExceptionRecord jExceptionRecord : jExceptionRecordArray = jCodeAttr.getExceptions()) {
            int n = jExceptionRecord.getStartPc();
            InstrContainer instrContainer = this.findTargetInstrContainer(0, n);
            instrContainer.setLabelFlag(true);
            instrContainer.setControlFlowLabelFlag(true);
            int n2 = jExceptionRecord.getEndPc();
            instrContainer = this.findTargetInstrContainer(0, n2);
            instrContainer.setLabelFlag(true);
            instrContainer.setControlFlowLabelFlag(true);
            int n3 = jExceptionRecord.getHandlerPc();
            instrContainer = this.findTargetInstrContainer(0, n3);
            instrContainer.setLabelFlag(true);
            instrContainer.setControlFlowLabelFlag(true);
            instrContainer.setCatchFinallyBlockLeader(true);
        }
    }

    private void setContainerLabels() {
        int n = 0;
        for (InstrContainer instrContainer = this.instr_containers; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            if (!instrContainer.hasLabel()) continue;
            instrContainer.setLabel(n);
            ++n;
        }
    }

    private InstrContainer findTargetInstrContainer(int n, int n2) {
        int n3 = n + n2;
        for (InstrContainer instrContainer = this.instr_containers; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            if (instrContainer.getJInstr().getPC() != n3) continue;
            return instrContainer;
        }
        throw new ConverterInternalError();
    }

    private JcException[] constructExceptions() {
        ExceptionTableConverter exceptionTableConverter = new ExceptionTableConverter(this);
        return exceptionTableConverter.convert();
    }

    private JcLocalVariable[] computeLocals() throws Exception {
        this.local_var_converter = LocalVariableConverter.createIt(this);
        return this.local_var_converter.convert();
    }

    public LocalVariableConverter getLocalVariableConverter() {
        return this.local_var_converter;
    }

    public void setMaxLocals() {
        if (!this.isIntSupported()) {
            JCodeAttr jCodeAttr = this.java_method.getCodeAttr();
            this.max_locals = jCodeAttr == null ? 0 : jCodeAttr.getMaxLocals();
        } else {
            this.max_locals = this.local_var_converter.getDefinedLocalVariablesSize() + this.local_var_converter.getUndefinedLocalVariablesSize();
            if (this.max_locals < this.nargs) {
                this.max_locals = this.nargs;
            }
        }
        if (this.max_locals != 0) {
            this.max_locals -= this.nargs;
        }
        this.jc_method.setMaxLocals(this.max_locals);
    }

    private void setNargs() {
        String string = this.jc_method.getMethodDescriptor();
        this.nargs = MethodDescriptor.getParamSize(string);
        int n = this.jc_method.getAccessFlags();
        if (!Modifier.isStatic(n)) {
            ++this.nargs;
        }
        this.jc_method.setNargs(this.nargs);
    }

    private void setMaxStack() throws Exception {
        Object[] objectArray;
        int n = 0;
        for (InstrContainer instrContainer = this.instr_containers; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            objectArray = instrContainer.getOperandStack();
            if (objectArray == null || n >= objectArray.getMaxStackSize()) continue;
            n = objectArray.getMaxStackSize();
        }
        if (n > 255) {
            objectArray = new String[]{this.getMethodName(), this.getClassName().replace('/', '.')};
            Notifier.error("subset.56", objectArray);
            throw new ConversionException();
        }
        this.jc_method.setMaxStack(n);
    }

    private boolean isUnconditionalBranch(JInstruction jInstruction) {
        int n = jInstruction.getOpcode();
        switch (n) {
            case 167: 
            case 168: 
            case 169: 
            case 172: 
            case 176: 
            case 177: 
            case 191: {
                return true;
            }
        }
        return false;
    }

    private void checkForcedTypeAndPromote(InstrContainer instrContainer) {
        if (instrContainer.getForcedType() != 3) {
            return;
        }
        OperandStack operandStack = instrContainer.getOperandStack();
        OperandStackEntry operandStackEntry = operandStack.peek(1);
        if (operandStackEntry.getType() == 3) {
            return;
        }
        JcInstruction jcInstruction = instrContainer.getJcInstr();
        if (jcInstruction == null) {
            if (operandStackEntry.getType() == 2 || operandStackEntry.getType() == 1) {
                JcInstrNoOperands jcInstrNoOperands = new JcInstrNoOperands(92);
                instrContainer.setJcInstr(jcInstrNoOperands);
                operandStack.promote(1);
                return;
            }
            throw new ConverterInternalError();
        }
        switch (jcInstruction.getOpcode()) {
            case 2: {
                jcInstruction.setOpcode(9);
                break;
            }
            case 3: {
                jcInstruction.setOpcode(10);
                break;
            }
            case 4: {
                jcInstruction.setOpcode(11);
                break;
            }
            case 5: {
                jcInstruction.setOpcode(12);
                break;
            }
            case 6: {
                jcInstruction.setOpcode(13);
                break;
            }
            case 7: {
                jcInstruction.setOpcode(14);
                break;
            }
            case 8: {
                jcInstruction.setOpcode(15);
                break;
            }
            case 16: {
                jcInstruction.setOpcode(18);
                break;
            }
            case 17: {
                jcInstruction.setOpcode(19);
                break;
            }
            default: {
                JcInstrNoOperands jcInstrNoOperands = new JcInstrNoOperands(92);
                if (jcInstruction == null) {
                    jcInstruction = jcInstrNoOperands;
                    instrContainer.setJcInstr(jcInstruction);
                    break;
                }
                jcInstruction.setNextInstr(jcInstrNoOperands);
                jcInstrNoOperands.setPrevInstr(jcInstruction);
            }
        }
        operandStack.promote(1);
    }

    private void propagateInfo(InstrContainer instrContainer) {
        InstrContainer[] instrContainerArray = instrContainer.getOutInstrContainers();
        OperandStack operandStack = instrContainer.getOperandStack();
        for (InstrContainer instrContainer2 : instrContainerArray) {
            if (instrContainer2.isCatchFinallyBlockLeader()) continue;
            try {
                if (instrContainer.getJInstr().getOpcode() == 168 && instrContainer.getNextInstrContainer().getJInstr().getPC() == instrContainer2.getJInstr().getPC() && instrContainerArray.length > 1) {
                    OperandStack operandStack2 = (OperandStack)operandStack.clone();
                    operandStack2.pop();
                    instrContainer2.setOperandStack(operandStack2);
                    continue;
                }
                instrContainer2.setOperandStack((OperandStack)operandStack.clone());
            }
            catch (RollBackException rollBackException) {
                InstrContainer instrContainer3 = instrContainer2.getPrevInstrContainer();
                int n = instrContainer.getJInstr().getPC();
                int n2 = rollBackException.getRollBackPoint().getJInstr().getPC();
                int n3 = instrContainer3.getJInstr().getPC();
                if (instrContainer3 != null && n != n2 && n != n3) {
                    instrContainer3.setForcedType(3);
                    instrContainer3.setChangedFlag(true);
                }
                throw rollBackException;
            }
        }
    }

    private void setSourceLineNumber(InstrContainer instrContainer) {
        int n = instrContainer.getJInstr().getSourceLineNumber();
        for (JcInstruction jcInstruction = instrContainer.getJcInstr(); jcInstruction != null; jcInstruction = jcInstruction.getNextInstr()) {
            jcInstruction.setSourceLineNumber(n);
        }
    }

    private void setJcInstrLabel(InstrContainer instrContainer) {
        int n = instrContainer.getLabel();
        if (n == -1) {
            return;
        }
        JcInstruction jcInstruction = instrContainer.getJcInstr();
        if (jcInstruction != null) {
            jcInstruction.setLabel(n);
        }
    }

    private JcInstruction linkJcInstructions() {
        JcInstruction jcInstruction = null;
        JcInstruction jcInstruction2 = null;
        for (InstrContainer instrContainer = this.instr_containers; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            JcInstruction jcInstruction3 = instrContainer.getJcInstr();
            if (jcInstruction3 == null) continue;
            if (!instrContainer.hasLabel()) {
                InstrContainer instrContainer2 = instrContainer.getPrevInstrContainer();
                while (instrContainer2.getJcInstr() == null) {
                    if (instrContainer2.hasLabel()) {
                        jcInstruction3.setLabel(instrContainer2.getLabel());
                        break;
                    }
                    instrContainer2 = instrContainer2.getPrevInstrContainer();
                }
            }
            if (jcInstruction == null) {
                jcInstruction = jcInstruction3;
                jcInstruction2 = jcInstruction3;
            } else {
                jcInstruction2.setNextInstr(jcInstruction3);
                jcInstruction3.setPrevInstr(jcInstruction2);
            }
            jcInstruction2 = jcInstruction3;
            while (jcInstruction2.getNextInstr() != null) {
                jcInstruction2 = jcInstruction2.getNextInstr();
            }
        }
        return jcInstruction;
    }

    private void checkMethodSignature() throws Exception {
        Vector<String> vector = this.getClassesFromSignature();
        JPackage jPackage = this.getPackageConverter().getJavaPackage();
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).toString();
            JClassFile jClassFile = jPackage.getClass(string);
            if (jClassFile == null || jClassFile.isPublic()) continue;
            Object[] objectArray = new String[]{this.getMethodName(), this.getClassName().replace('/', '.'), string.replace('/', '.')};
            Notifier.error("subset.55", objectArray);
            throw new ConversionException();
        }
    }

    private Vector<String> getClassesFromSignature() {
        int n;
        Vector<String> vector = new Vector<String>();
        String string = this.getMethodDescriptor();
        while ((n = string.indexOf(76)) != -1) {
            int n2 = string.indexOf(59, n);
            if (n == -1) break;
            String string2 = string.substring(n + 1, n2);
            string = string.substring(n2 + 1);
            vector.add(string2);
        }
        return vector;
    }

    private void insertI2SBefore(InstrContainer instrContainer) {
        InstrContainer instrContainer2 = instrContainer.getPrevInstrContainer();
        JInstrNoOperands jInstrNoOperands = new JInstrNoOperands(null, 0, 147);
        InstrContainer instrContainer3 = new InstrContainer(jInstrNoOperands);
        JcInstrNoOperands jcInstrNoOperands = new JcInstrNoOperands(94);
        instrContainer3.setJcInstr(jcInstrNoOperands);
        instrContainer3.setNextInstrContainer(instrContainer);
        instrContainer3.setPrevInstrContainer(instrContainer2);
        instrContainer2.setNextInstrContainer(instrContainer3);
        instrContainer.setPrevInstrContainer(instrContainer3);
        instrContainer2.relink(instrContainer, instrContainer3);
        instrContainer3.link(instrContainer);
    }

    private void insertI2SAfter(InstrContainer instrContainer) {
        InstrContainer instrContainer2 = instrContainer.getNextInstrContainer();
        JInstrNoOperands jInstrNoOperands = new JInstrNoOperands(null, 0, 147);
        InstrContainer instrContainer3 = new InstrContainer(jInstrNoOperands);
        instrContainer3.setInserted(true);
        JcInstrNoOperands jcInstrNoOperands = new JcInstrNoOperands(94);
        instrContainer3.setJcInstr(jcInstrNoOperands);
        instrContainer3.setNextInstrContainer(instrContainer2);
        instrContainer3.setPrevInstrContainer(instrContainer);
        instrContainer2.setPrevInstrContainer(instrContainer3);
        instrContainer.setNextInstrContainer(instrContainer3);
        instrContainer.relink(instrContainer2, instrContainer3);
        instrContainer3.link(instrContainer2);
    }
}

