/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.CompareVersion;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;

class VerifyRev {
    static int verbose = 1;
    static boolean printTrace = false;

    VerifyRev() {
    }

    public static void main(String[] stringArray) {
        String string;
        int n;
        boolean bl = true;
        for (n = 0; n < stringArray.length && stringArray[n].length() > 0 && stringArray[n].charAt(0) == '-'; ++n) {
            string = stringArray[n];
            if (string.equals("-verbose")) {
                ++verbose;
                continue;
            }
            if (string.equals("-nobanner")) {
                bl = false;
                continue;
            }
            if (string.equals("-nowarn")) {
                VerifierError.noWarn = true;
                continue;
            }
            if (string.equals("-help")) {
                VerifyRev.printUsageAndExit();
                continue;
            }
            if (string.equals("-version")) {
                Messages.println("MainRev.3");
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(2);
                continue;
            }
            VerifyRev.printUsageAndExit();
        }
        if (n + 2 != stringArray.length) {
            VerifyRev.printUsageAndExit();
        }
        if (verbose >= 1 && bl) {
            Messages.println("MainRev.3", ToolsVersion.getVersion(2));
        }
        Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
        string = stringArray[n];
        String string2 = stringArray[n + 1];
        if (string.equals(string2)) {
            VerifyRev.printUsageAndExit();
        }
        if (!string.endsWith(".exp") || !string2.endsWith(".exp")) {
            VerifyRev.printUsageAndExit();
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.getName().equals(file2.getName())) {
            VerifyRev.printUsageAndExit();
        }
        if (verbose >= 1) {
            Messages.println("MainRev.4", string, (Object)string2);
        }
        try {
            ExportFile exportFile = ExportFile.readFromFile(file);
            ExportFile exportFile2 = ExportFile.readFromFile(file2);
            CompareVersion.compare(exportFile, exportFile2);
        }
        catch (VerifierError verifierError) {
            Messages.printSevere("MainRev.2", Messages.numWarning, verifierError.getMessage(), Messages.format("MainRev.7"));
            System.exit(2);
        }
        Messages.println("MainRev.5", Messages.numWarning);
    }

    private static void printUsageAndExit() {
        Messages.println("MainRev.1");
        System.exit(2);
    }
}

