/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.impl;

import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.GarbageCollector;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageMgr;
import com.sun.javacard.impl.PackedBoolean;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.MultiSelectable;
import javacard.framework.Shareable;
import javacard.framework.SystemException;

public class PrivAccess {
    public static final byte APP_FIRST = 0;
    public static final byte APPS_MAX = 16;
    public static final byte APP_NULL = -1;
    public static final byte JCRE_CONTEXTID = 0;
    public static final byte NULL_CONTEXTID = 15;
    public static final byte APPID_BITMASK = 15;
    private static final byte BASIC_CHANNEL = 0;
    public static final byte INTERFACE_PRIMARY = 0;
    public static final byte INTERFACE_SECONDARY = 1;
    static final byte APPLET_MULTISELECTED = 8;
    static final byte APPLET_ACTIVE = 4;
    static final byte PACKAGE_MULTISELECTED = 2;
    static final byte PACKAGE_ACTIVE = 1;
    private static final byte OP_CHANNEL_CLOSE = 0;
    private static final byte OP_CHANNEL_OPEN = 1;
    private static final byte OP_CHANNEL_OPEN_AUTOSELECT = 2;
    private static final byte CHANNEL_CLOSED = 0;
    private static final byte CHANNEL_DISABLED = 1;
    private static final byte CHANNEL_OPEN = 2;
    private static final byte CHANNEL_OPEN_MS = 3;
    private static final byte CHANNEL_MS_MASK = 1;
    private static final byte CHANNEL_OPEN_MASK = 2;
    public static final byte NUM_ISO_CHANNELS = 20;
    private static PackedBoolean thePackedBoolean;
    private static PrivAccess thePrivAccess;
    private static final byte NUMBER_SYSTEM_BOOLS = 24;
    private static byte selectingAppletFlag;
    private static byte processMethodFlag;
    public static final byte APP_STATE_NONE = 0;
    public static final byte APP_STATE_REGISTERED = 1;
    public static final byte APP_STATE_SELECTABLE = 2;

    public PrivAccess() {
        thePrivAccess = this;
    }

    public static PackedBoolean getPackedBoolean() {
        if (thePackedBoolean == null) {
            thePackedBoolean = new PackedBoolean(3);
        }
        return thePackedBoolean;
    }

    public static PrivAccess getPrivAccess() {
        return thePrivAccess;
    }

    public static void setSelectingAppletFlag() {
        thePackedBoolean.set(selectingAppletFlag);
    }

    public static void resetSelectingAppletFlag() {
        thePackedBoolean.reset(selectingAppletFlag);
    }

    public static void setProcessMethodFlag() {
        thePackedBoolean.set(processMethodFlag);
    }

    public static void resetProcessMethodFlag() {
        thePackedBoolean.reset(processMethodFlag);
    }

    public static byte getSelectedAppID(byte channelId, byte interfaceId) {
        byte contextId = NativeMethods.getChannelContext(channelId, interfaceId);
        if (contextId == 15) {
            return -1;
        }
        return (byte)(contextId & 0xF);
    }

    public static Applet getSelectedApplet(byte channelId, byte interfaceId) {
        return AppletMgr.theAppTable[PrivAccess.getSelectedAppID((byte)channelId, (byte)interfaceId)].theApplet;
    }

    public static void setDefaultApplet(APDU apdu) {
        byte numContactedChannels = 20;
        byte numContactlessChannels = NativeMethods.getCardInterfaceCount() == 2 ? (byte)20 : 0;
        byte[] buffer = apdu.getBuffer();
        byte channelNumber = buffer[2];
        if (buffer[3] != 0 && buffer[3] != 1) {
            ISOException.throwIt((short)27270);
        }
        if (buffer[3] == 0) {
            if (channelNumber < 0 || channelNumber >= numContactedChannels) {
                ISOException.throwIt((short)25684);
            }
        } else if (channelNumber < 0 || channelNumber >= numContactlessChannels) {
            ISOException.throwIt((short)25684);
        }
        byte defaultAppletArrayOffset = buffer[3] == 0 ? (byte)0 : numContactedChannels;
        byte aidlength = buffer[4];
        apdu.setIncomingAndReceive();
        byte appId = AppletMgr.findApplet(buffer, (short)5, aidlength);
        if (appId == -1) {
            ISOException.throwIt((short)25667);
        }
        AppletMgr.defaultApplets[(short)(defaultAppletArrayOffset + channelNumber)] = appId;
    }

    public static void powerUpContactless() {
        if (NativeMethods.getCardInterfaceCount() == 2) {
            NativeMethods.channelManage((byte)0, (byte)1, (byte)1);
            try {
                PrivAccess.selectDefaultApplet((byte)0, (byte)1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void powerDownContactless() {
        if (NativeMethods.getCardInterfaceCount() == 2) {
            for (byte i2 = 0; i2 < 20; i2 = (byte)(i2 + 1)) {
                byte channelStatus = NativeMethods.getChannelStatus(i2, (byte)1);
                if (channelStatus != 2 && channelStatus != 3) continue;
                byte appContextId = NativeMethods.getChannelContext(i2, (byte)1);
                byte contextStatus = NativeMethods.getContextStatus(appContextId);
                if ((byte)(contextStatus & 2) == 0) {
                    NativeMethods.clearTransientObjs(i2, (byte)1, (byte)2);
                }
                NativeMethods.setChannelContext(i2, (byte)1, (byte)15, false);
                NativeMethods.channelManage(i2, (byte)1, (byte)0);
            }
        }
    }

    public static void selectDefaultApplet(byte channelId, byte interfaceId) throws ISOException {
        PrivAccess.deselectOnly(channelId, interfaceId);
        byte defaultAppId = AppletMgr.defaultApplets[channelId];
        if (defaultAppId != -1) {
            PrivAccess.selectOnly(channelId, interfaceId, defaultAppId);
        }
    }

    public static boolean isMultiSelectionOK(byte channelId, byte interfaceId, byte theAppID) {
        Applet appToSelect = AppletMgr.theAppTable[theAppID].theApplet;
        if (appToSelect instanceof MultiSelectable) {
            return true;
        }
        byte theContextID = PrivAccess.getContextId(theAppID);
        byte maxChannels = NativeMethods.getMaxChannels();
        byte maxInterfaces = NativeMethods.getCardInterfaceCount();
        int appContextID = 15;
        for (byte i2 = 0; i2 < maxChannels; i2 = (byte)(i2 + 1)) {
            for (byte j2 = 0; j2 < maxInterfaces; j2 = (byte)(j2 + 1)) {
                if (i2 == channelId || j2 == interfaceId || (appContextID = (int)NativeMethods.getChannelContext(i2, j2)) == 15 || ((appContextID ^ theContextID) & 0xF0) != 0) continue;
                return false;
            }
        }
        return true;
    }

    public static void selectOnly(byte channelId, byte interfaceId, byte theAppID) throws ISOException {
        boolean success = false;
        byte appContextId = PrivAccess.getContextId(theAppID);
        boolean multiSelectFailed = false;
        byte contextStatus = 0;
        PrivAccess.setSelectingAppletFlag();
        try {
            Applet appToSelect = AppletMgr.theAppTable[theAppID].theApplet;
            contextStatus = NativeMethods.getContextStatus(appContextId);
            if (NativeMethods.setChannelContext(channelId, interfaceId, appContextId, appToSelect instanceof MultiSelectable)) {
                NativeMethods.setCurrentlySelectedChannel(channelId, interfaceId);
                if ((byte)(contextStatus & 1) != 0) {
                    MultiSelectable msApp = (MultiSelectable)((Object)PrivAccess.getSelectedApplet(channelId, interfaceId));
                    success = msApp.select((byte)(contextStatus & 4) != 0);
                } else {
                    success = PrivAccess.getSelectedApplet(channelId, interfaceId).select();
                }
            } else {
                ISOException.throwIt((short)27013);
            }
        }
        catch (ISOException isoEx) {
            if (isoEx.getReason() == 27013) {
                ISOException.throwIt(isoEx.getReason());
            }
        }
        catch (SystemException se) {
            if (se.getReason() == 5) {
                ISOException.throwIt((short)27265);
            }
        }
        catch (Throwable e2) {
            // empty catch block
        }
        NativeMethods.setCurrentlySelectedChannel(APDU.getCLAChannel(), interfaceId);
        if (JCSystem.getTransactionDepth() != 0) {
            success = false;
            JCSystem.abortTransaction();
        }
        if (success) {
            return;
        }
        NativeMethods.setChannelContext(channelId, interfaceId, (byte)15, false);
        ISOException.throwIt((short)27033);
    }

    public static void deselectOnly(byte channelId, byte interfaceId) {
        if (NativeMethods.getChannelContext(channelId, interfaceId) == 15) {
            return;
        }
        Applet theApp = PrivAccess.getSelectedApplet(channelId, interfaceId);
        if (theApp == null) {
            return;
        }
        byte appContextId = NativeMethods.getChannelContext(channelId, interfaceId);
        byte contextStatus = NativeMethods.getContextStatus(appContextId);
        try {
            NativeMethods.setCurrentlySelectedChannel(channelId, interfaceId);
            if ((byte)(contextStatus & 2) != 0) {
                MultiSelectable msApp = (MultiSelectable)((Object)PrivAccess.getSelectedApplet(channelId, interfaceId));
                msApp.deselect((byte)(contextStatus & 8) != 0);
            } else {
                theApp.deselect();
            }
        }
        catch (Throwable e2) {
            // empty catch block
        }
        NativeMethods.setCurrentlySelectedChannel(APDU.getCLAChannel(), interfaceId);
        if ((byte)(contextStatus & 2) == 0) {
            NativeMethods.clearTransientObjs(channelId, interfaceId, (byte)2);
        }
        NativeMethods.setChannelContext(channelId, interfaceId, (byte)15, false);
        if (JCSystem.getTransactionDepth() != 0) {
            JCSystem.abortTransaction();
        }
    }

    public static void selectApplet(byte channelID, byte interfaceId, byte theAppID) throws ISOException {
        PrivAccess.deselectOnly(channelID, interfaceId);
        PrivAccess.selectOnly(channelID, interfaceId, theAppID);
    }

    public static byte getAppState(AID theAID) {
        byte appID = AppletMgr.findApplet(theAID);
        if (appID != -1) {
            return AppletMgr.theAppState[appID];
        }
        return 0;
    }

    public static void setAppState(AID theAID, byte theState) {
        byte appID = AppletMgr.findApplet(theAID);
        AppletMgr.theAppState[appID] = theState;
    }

    public static byte getCurrentAppID() {
        byte contextId = NativeMethods.getCurrentContext();
        return (byte)(contextId & 0xF);
    }

    public static byte getPreviousAppID() {
        byte contextId = NativeMethods.getPreviousContext();
        return (byte)(contextId & 0xF);
    }

    public static byte getContextId(byte appID) {
        return (byte)(AppletMgr.theAppTable[appID].theContext << 4 | appID);
    }

    public static void initialize(APDU theAPDU) {
        PackageMgr.init();
        selectingAppletFlag = PrivAccess.getPackedBoolean().allocate();
        processMethodFlag = PrivAccess.getPackedBoolean().allocate();
        byte[] bArray = theAPDU.getBuffer();
        short bOffset = 0;
        byte pkgId = PackageMgr.getPkgIdForContext((byte)0);
        AID aid = PackageMgr.f_pkgTable[pkgId].applets[0].theClassAID;
        byte aidLength = aid.getBytes(bArray, (short)0);
        if (aidLength == -1) {
            return;
        }
        AppletMgr.currentAppletIndex = 0;
        AID theAID = AppletMgr.createApplet(bArray, bOffset, aidLength, (byte)0);
        if (theAID != null) {
            PrivAccess.setAppState(theAID, (byte)2);
        }
    }

    public boolean selectingApplet() {
        return thePackedBoolean.get(selectingAppletFlag);
    }

    public boolean inProcessMethod() {
        return thePackedBoolean.get(processMethodFlag);
    }

    public final void register(Applet theApplet) {
        AppletMgr.register(theApplet, null);
    }

    public final void register(Applet theApplet, byte[] bArray, short bOffset, byte bLength) {
        AID theAID = new AID(bArray, bOffset, bLength);
        NativeMethods.setJCREentry(theAID, false);
        AppletMgr.register(theApplet, theAID);
    }

    public Shareable getSharedObject(AID serverAID, byte param) {
        AID clientAID = this.getAID((byte)(NativeMethods.getPreviousContext() & 0xF));
        if (clientAID == null) {
            return null;
        }
        byte appID = AppletMgr.findApplet(serverAID);
        if (appID != -1) {
            try {
                return AppletMgr.theAppTable[appID].theApplet.getShareableInterfaceObject(clientAID, param);
            }
            catch (Exception ie) {
                // empty catch block
            }
        }
        return null;
    }

    public AID getAID(byte[] aidArray, short aidOff, byte aidLength) {
        byte appID = AppletMgr.findApplet(aidArray, aidOff, aidLength);
        if (appID != -1) {
            return AppletMgr.theAppTable[appID].theAID;
        }
        return null;
    }

    public AID getAID(byte appID) {
        return AppletMgr.theAppTable[appID].theAID;
    }

    public byte getPkgIDForAddress(int addr) {
        return PackageMgr.getPkgIDForAddress(addr);
    }

    public byte getPkgNameForClass(int classAddress, byte[] buffer, byte offset) {
        return PackageMgr.getPkgNameForClass(classAddress, buffer, offset);
    }

    public void setGCRequestedFlag(boolean flag) {
        if (flag) {
            thePackedBoolean.set(GarbageCollector.GCRequested);
        } else {
            thePackedBoolean.reset(GarbageCollector.GCRequested);
        }
    }

    public boolean isGarbageCollectionRequested() {
        return thePackedBoolean.get(GarbageCollector.GCRequested);
    }
}

