/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Cad;
import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.T0ServerClosed;
import com.sun.javacard.apduio.T0ServerOpen;
import com.sun.javacard.apduio.T0ServerState;
import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apduio.TLP224Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ServerT0Protocol {
    TLP224Message tlp224Msg;
    Cad cad;
    private T0ServerState state_;
    private Vector listeners = new Vector();

    public ServerT0Protocol(InputStream in, OutputStream out) {
        this.cad = new Cad(in, out);
        this.tlp224Msg = new TLP224Message();
        this.state_ = T0ServerClosed.instance();
    }

    public void addCadServerListener(CadServerListener listener) {
        this.listeners.addElement(listener);
    }

    void changeState(T0ServerState newState) {
        this.state_ = newState;
        Vector v = (Vector)this.listeners.clone();
        int i = 0;
        while (i < v.size()) {
            if (this.state_ instanceof T0ServerClosed) {
                ((CadServerListener)v.elementAt(i)).powerDown(new CadEvent(this));
            } else if (this.state_ instanceof T0ServerOpen) {
                ((CadServerListener)v.elementAt(i)).powerUp(new CadEvent(this));
            }
            ++i;
        }
    }

    public void removeCadServerListener(CadServerListener listener) {
        this.listeners.removeElement(listener);
    }

    public void sendATR(byte[] atr) throws IOException, TLP224Exception {
        this.state_.sendATR(this, atr);
    }

    public byte t0RcvCommand(byte[] command) {
        try {
            return (byte)this.state_.t0RcvCommand(this, command);
        }
        catch (TLP224Exception tLP224Exception) {
            return 1;
        }
        catch (IOException iOException) {
            return 1;
        }
    }

    public byte t0RcvData(byte[] buffer, short offset, short count, byte procByte) {
        try {
            return (byte)this.state_.t0RcvData(this, buffer, offset, count, procByte);
        }
        catch (TLP224Exception tLP224Exception) {
            return 1;
        }
        catch (IOException iOException) {
            return 1;
        }
    }

    public byte t0SndData(byte[] buffer, short offset, short count) {
        try {
            return (byte)this.state_.t0SndData(this, buffer, offset, count);
        }
        catch (TLP224Exception tLP224Exception) {
            return 1;
        }
        catch (IOException iOException) {
            return 1;
        }
    }

    public byte t0SndData(byte[] buffer, short offset, short count, byte procByte) {
        try {
            return (byte)this.state_.t0SndData(this, buffer, offset, count, procByte);
        }
        catch (TLP224Exception tLP224Exception) {
            return 1;
        }
        catch (IOException iOException) {
            return 1;
        }
    }

    public byte t0SndStatusRcvCommand(byte[] command, short sw1sw2) {
        try {
            return (byte)this.state_.t0SndStatusRcvCommand(this, command, sw1sw2);
        }
        catch (TLP224Exception tLP224Exception) {
            return 1;
        }
        catch (IOException iOException) {
            return 1;
        }
    }
}

