/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.ExnHandler;
import com.sun.javacard.offcardverifier.InstrLookupSwitch;
import com.sun.javacard.offcardverifier.InstrTableSwitch;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.VerifierError;

class Instr {
    int opcode;
    int arg;
    int arg2;
    int arg3;
    ExnHandler handler;
    static final int NOP = 0;
    static final int ACONST_NULL = 1;
    static final int SCONST_M1 = 2;
    static final int SCONST_0 = 3;
    static final int SCONST_1 = 4;
    static final int SCONST_2 = 5;
    static final int SCONST_3 = 6;
    static final int SCONST_4 = 7;
    static final int SCONST_5 = 8;
    static final int ICONST_M1 = 9;
    static final int ICONST_0 = 10;
    static final int ICONST_1 = 11;
    static final int ICONST_2 = 12;
    static final int ICONST_3 = 13;
    static final int ICONST_4 = 14;
    static final int ICONST_5 = 15;
    static final int BSPUSH = 16;
    static final int SSPUSH = 17;
    static final int BIPUSH = 18;
    static final int SIPUSH = 19;
    static final int IIPUSH = 20;
    static final int ALOAD = 21;
    static final int SLOAD = 22;
    static final int ILOAD = 23;
    static final int ALOAD_0 = 24;
    static final int ALOAD_1 = 25;
    static final int ALOAD_2 = 26;
    static final int ALOAD_3 = 27;
    static final int SLOAD_0 = 28;
    static final int SLOAD_1 = 29;
    static final int SLOAD_2 = 30;
    static final int SLOAD_3 = 31;
    static final int ILOAD_0 = 32;
    static final int ILOAD_1 = 33;
    static final int ILOAD_2 = 34;
    static final int ILOAD_3 = 35;
    static final int AALOAD = 36;
    static final int BALOAD = 37;
    static final int SALOAD = 38;
    static final int IALOAD = 39;
    static final int ASTORE = 40;
    static final int SSTORE = 41;
    static final int ISTORE = 42;
    static final int ASTORE_0 = 43;
    static final int ASTORE_1 = 44;
    static final int ASTORE_2 = 45;
    static final int ASTORE_3 = 46;
    static final int SSTORE_0 = 47;
    static final int SSTORE_1 = 48;
    static final int SSTORE_2 = 49;
    static final int SSTORE_3 = 50;
    static final int ISTORE_0 = 51;
    static final int ISTORE_1 = 52;
    static final int ISTORE_2 = 53;
    static final int ISTORE_3 = 54;
    static final int AASTORE = 55;
    static final int BASTORE = 56;
    static final int SASTORE = 57;
    static final int IASTORE = 58;
    static final int POP = 59;
    static final int POP2 = 60;
    static final int DUP = 61;
    static final int DUP2 = 62;
    static final int DUP_X = 63;
    static final int SWAP_X = 64;
    static final int SADD = 65;
    static final int IADD = 66;
    static final int SSUB = 67;
    static final int ISUB = 68;
    static final int SMUL = 69;
    static final int IMUL = 70;
    static final int SDIV = 71;
    static final int IDIV = 72;
    static final int SREM = 73;
    static final int IREM = 74;
    static final int SNEG = 75;
    static final int INEG = 76;
    static final int SSHL = 77;
    static final int ISHL = 78;
    static final int SSHR = 79;
    static final int ISHR = 80;
    static final int SUSHR = 81;
    static final int IUSHR = 82;
    static final int SAND = 83;
    static final int IAND = 84;
    static final int SOR = 85;
    static final int IOR = 86;
    static final int SXOR = 87;
    static final int IXOR = 88;
    static final int SINC = 89;
    static final int IINC = 90;
    static final int S2B = 91;
    static final int S2I = 92;
    static final int I2B = 93;
    static final int I2S = 94;
    static final int ICMP = 95;
    static final int IFEQ = 96;
    static final int IFNE = 97;
    static final int IFLT = 98;
    static final int IFGE = 99;
    static final int IFGT = 100;
    static final int IFLE = 101;
    static final int IFNULL = 102;
    static final int IFNONNULL = 103;
    static final int IF_ACMPEQ = 104;
    static final int IF_ACMPNE = 105;
    static final int IF_SCMPEQ = 106;
    static final int IF_SCMPNE = 107;
    static final int IF_SCMPLT = 108;
    static final int IF_SCMPGE = 109;
    static final int IF_SCMPGT = 110;
    static final int IF_SCMPLE = 111;
    static final int GOTO = 112;
    static final int JSR = 113;
    static final int RET = 114;
    static final int STABLESWITCH = 115;
    static final int ITABLESWITCH = 116;
    static final int SLOOKUPSWITCH = 117;
    static final int ILOOKUPSWITCH = 118;
    static final int ARETURN = 119;
    static final int SRETURN = 120;
    static final int IRETURN = 121;
    static final int RETURN = 122;
    static final int GETSTATIC_A = 123;
    static final int GETSTATIC_B = 124;
    static final int GETSTATIC_S = 125;
    static final int GETSTATIC_I = 126;
    static final int PUTSTATIC_A = 127;
    static final int PUTSTATIC_B = 128;
    static final int PUTSTATIC_S = 129;
    static final int PUTSTATIC_I = 130;
    static final int GETFIELD_A = 131;
    static final int GETFIELD_B = 132;
    static final int GETFIELD_S = 133;
    static final int GETFIELD_I = 134;
    static final int PUTFIELD_A = 135;
    static final int PUTFIELD_B = 136;
    static final int PUTFIELD_S = 137;
    static final int PUTFIELD_I = 138;
    static final int INVOKEVIRTUAL = 139;
    static final int INVOKESPECIAL = 140;
    static final int INVOKESTATIC = 141;
    static final int INVOKEINTERFACE = 142;
    static final int NEW = 143;
    static final int NEWARRAY = 144;
    static final int ANEWARRAY = 145;
    static final int ARRAYLENGTH = 146;
    static final int ATHROW = 147;
    static final int CHECKCAST = 148;
    static final int INSTANCEOF = 149;
    static final int SINC_W = 150;
    static final int IINC_W = 151;
    static final int IFEQ_W = 152;
    static final int IFNE_W = 153;
    static final int IFLT_W = 154;
    static final int IFGE_W = 155;
    static final int IFGT_W = 156;
    static final int IFLE_W = 157;
    static final int IFNULL_W = 158;
    static final int IFNONNULL_W = 159;
    static final int IF_ACMPEQ_W = 160;
    static final int IF_ACMPNE_W = 161;
    static final int IF_SCMPEQ_W = 162;
    static final int IF_SCMPNE_W = 163;
    static final int IF_SCMPLT_W = 164;
    static final int IF_SCMPGE_W = 165;
    static final int IF_SCMPGT_W = 166;
    static final int IF_SCMPLE_W = 167;
    static final int GOTO_W = 168;
    static final int GETFIELD_A_W = 169;
    static final int GETFIELD_B_W = 170;
    static final int GETFIELD_S_W = 171;
    static final int GETFIELD_I_W = 172;
    static final int GETFIELD_A_THIS = 173;
    static final int GETFIELD_B_THIS = 174;
    static final int GETFIELD_S_THIS = 175;
    static final int GETFIELD_I_THIS = 176;
    static final int PUTFIELD_A_W = 177;
    static final int PUTFIELD_B_W = 178;
    static final int PUTFIELD_S_W = 179;
    static final int PUTFIELD_I_W = 180;
    static final int PUTFIELD_A_THIS = 181;
    static final int PUTFIELD_B_THIS = 182;
    static final int PUTFIELD_S_THIS = 183;
    static final int PUTFIELD_I_THIS = 184;
    static final int LAST_VALID_OPCODE = 184;
    static final int T_BOOLEAN = 10;
    static final int T_BYTE = 11;
    static final int T_SHORT = 12;
    static final int T_INT = 13;
    static final int T_REFERENCE = 14;
    static final String[] instrName = new String[]{"nop", "aconst_null", "sconst_m1", "sconst_0", "sconst_1", "sconst_2", "sconst_3", "sconst_4", "sconst_5", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "bspush", "sspush", "bipush", "sipush", "iipush", "aload", "sload", "iload", "aload_0", "aload_1", "aload_2", "aload_3", "sload_0", "sload_1", "sload_2", "sload_3", "iload_0", "iload_1", "iload_2", "iload_3", "aaload", "baload", "saload", "iaload", "astore", "sstore", "istore", "astore_0", "astore_1", "astore_2", "astore_3", "sstore_0", "sstore_1", "sstore_2", "sstore_3", "istore_0", "istore_1", "istore_2", "istore_3", "aastore", "bastore", "sastore", "iastore", "pop", "pop2", "dup", "dup2", "dup_x", "swap_x", "sadd", "iadd", "ssub", "isub", "smul", "imul", "sdiv", "idiv", "srem", "irem", "sneg", "ineg", "sshl", "ishl", "sshr", "ishr", "sushr", "iushr", "sand", "iand", "sor", "ior", "sxor", "ixor", "sinc", "iinc", "s2b", "s2i", "i2b", "i2s", "icmp", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "ifnull", "ifnonnull", "if_acmpeq", "if_acmpne", "if_scmpeq", "if_scmpne", "if_scmplt", "if_scmpge", "if_scmpgt", "if_scmple", "goto", "jsr", "ret", "stableswitch", "itableswitch", "slookupswitch", "ilookupswitch", "areturn", "sreturn", "ireturn", "return", "getstatic_a", "getstatic_b", "getstatic_s", "getstatic_i", "putstatic_a", "putstatic_b", "putstatic_s", "putstatic_i", "getfield_a", "getfield_b", "getfield_s", "getfield_i", "putfield_a", "putfield_b", "putfield_s", "putfield_i", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "sinc_w", "iinc_w", "ifeq_w", "ifne_w", "iflt_w", "ifge_w", "ifgt_w", "ifle_w", "ifnull_w", "ifnonnull_w", "if_acmpeq_w", "if_acmpne_w", "if_scmpeq_w", "if_scmpne_w", "if_scmplt_w", "if_scmpge_w", "if_scmpgt_w", "if_scmple_w", "goto_w", "getfield_a_w", "getfield_b_w", "getfield_s_w", "getfield_i_w", "getfield_a_this", "getfield_b_this", "getfield_s_this", "getfield_i_this", "putfield_a_w", "putfield_b_w", "putfield_s_w", "putfield_i_w", "putfield_a_this", "putfield_b_this", "putfield_s_this", "putfield_i_this"};
    static final byte[] instrLength;
    static final boolean[] instrInt;

    static {
        byte[] byArray = new byte[185];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 1;
        byArray[8] = 1;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 1;
        byArray[12] = 1;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 1;
        byArray[16] = 2;
        byArray[17] = 3;
        byArray[18] = 2;
        byArray[19] = 3;
        byArray[20] = 5;
        byArray[21] = 2;
        byArray[22] = 2;
        byArray[23] = 2;
        byArray[24] = 1;
        byArray[25] = 1;
        byArray[26] = 1;
        byArray[27] = 1;
        byArray[28] = 1;
        byArray[29] = 1;
        byArray[30] = 1;
        byArray[31] = 1;
        byArray[32] = 1;
        byArray[33] = 1;
        byArray[34] = 1;
        byArray[35] = 1;
        byArray[36] = 1;
        byArray[37] = 1;
        byArray[38] = 1;
        byArray[39] = 1;
        byArray[40] = 2;
        byArray[41] = 2;
        byArray[42] = 2;
        byArray[43] = 1;
        byArray[44] = 1;
        byArray[45] = 1;
        byArray[46] = 1;
        byArray[47] = 1;
        byArray[48] = 1;
        byArray[49] = 1;
        byArray[50] = 1;
        byArray[51] = 1;
        byArray[52] = 1;
        byArray[53] = 1;
        byArray[54] = 1;
        byArray[55] = 1;
        byArray[56] = 1;
        byArray[57] = 1;
        byArray[58] = 1;
        byArray[59] = 1;
        byArray[60] = 1;
        byArray[61] = 1;
        byArray[62] = 1;
        byArray[63] = 2;
        byArray[64] = 2;
        byArray[65] = 1;
        byArray[66] = 1;
        byArray[67] = 1;
        byArray[68] = 1;
        byArray[69] = 1;
        byArray[70] = 1;
        byArray[71] = 1;
        byArray[72] = 1;
        byArray[73] = 1;
        byArray[74] = 1;
        byArray[75] = 1;
        byArray[76] = 1;
        byArray[77] = 1;
        byArray[78] = 1;
        byArray[79] = 1;
        byArray[80] = 1;
        byArray[81] = 1;
        byArray[82] = 1;
        byArray[83] = 1;
        byArray[84] = 1;
        byArray[85] = 1;
        byArray[86] = 1;
        byArray[87] = 1;
        byArray[88] = 1;
        byArray[89] = 3;
        byArray[90] = 3;
        byArray[91] = 1;
        byArray[92] = 1;
        byArray[93] = 1;
        byArray[94] = 1;
        byArray[95] = 1;
        byArray[96] = 2;
        byArray[97] = 2;
        byArray[98] = 2;
        byArray[99] = 2;
        byArray[100] = 2;
        byArray[101] = 2;
        byArray[102] = 2;
        byArray[103] = 2;
        byArray[104] = 2;
        byArray[105] = 2;
        byArray[106] = 2;
        byArray[107] = 2;
        byArray[108] = 2;
        byArray[109] = 2;
        byArray[110] = 2;
        byArray[111] = 2;
        byArray[112] = 2;
        byArray[113] = 3;
        byArray[114] = 2;
        byArray[119] = 1;
        byArray[120] = 1;
        byArray[121] = 1;
        byArray[122] = 1;
        byArray[123] = 3;
        byArray[124] = 3;
        byArray[125] = 3;
        byArray[126] = 3;
        byArray[127] = 3;
        byArray[128] = 3;
        byArray[129] = 3;
        byArray[130] = 3;
        byArray[131] = 2;
        byArray[132] = 2;
        byArray[133] = 2;
        byArray[134] = 2;
        byArray[135] = 2;
        byArray[136] = 2;
        byArray[137] = 2;
        byArray[138] = 2;
        byArray[139] = 3;
        byArray[140] = 3;
        byArray[141] = 3;
        byArray[142] = 5;
        byArray[143] = 3;
        byArray[144] = 2;
        byArray[145] = 3;
        byArray[146] = 1;
        byArray[147] = 1;
        byArray[148] = 4;
        byArray[149] = 4;
        byArray[150] = 4;
        byArray[151] = 4;
        byArray[152] = 3;
        byArray[153] = 3;
        byArray[154] = 3;
        byArray[155] = 3;
        byArray[156] = 3;
        byArray[157] = 3;
        byArray[158] = 3;
        byArray[159] = 3;
        byArray[160] = 3;
        byArray[161] = 3;
        byArray[162] = 3;
        byArray[163] = 3;
        byArray[164] = 3;
        byArray[165] = 3;
        byArray[166] = 3;
        byArray[167] = 3;
        byArray[168] = 3;
        byArray[169] = 3;
        byArray[170] = 3;
        byArray[171] = 3;
        byArray[172] = 3;
        byArray[173] = 2;
        byArray[174] = 2;
        byArray[175] = 2;
        byArray[176] = 2;
        byArray[177] = 3;
        byArray[178] = 3;
        byArray[179] = 3;
        byArray[180] = 3;
        byArray[181] = 2;
        byArray[182] = 2;
        byArray[183] = 2;
        byArray[184] = 2;
        instrLength = byArray;
        boolean[] blArray = new boolean[185];
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[18] = true;
        blArray[19] = true;
        blArray[20] = true;
        blArray[23] = true;
        blArray[32] = true;
        blArray[33] = true;
        blArray[34] = true;
        blArray[35] = true;
        blArray[39] = true;
        blArray[42] = true;
        blArray[51] = true;
        blArray[52] = true;
        blArray[53] = true;
        blArray[54] = true;
        blArray[58] = true;
        blArray[66] = true;
        blArray[68] = true;
        blArray[70] = true;
        blArray[72] = true;
        blArray[74] = true;
        blArray[76] = true;
        blArray[78] = true;
        blArray[80] = true;
        blArray[82] = true;
        blArray[84] = true;
        blArray[86] = true;
        blArray[88] = true;
        blArray[90] = true;
        blArray[92] = true;
        blArray[93] = true;
        blArray[94] = true;
        blArray[95] = true;
        blArray[116] = true;
        blArray[118] = true;
        blArray[121] = true;
        blArray[126] = true;
        blArray[130] = true;
        blArray[134] = true;
        blArray[138] = true;
        blArray[151] = true;
        blArray[172] = true;
        blArray[176] = true;
        blArray[180] = true;
        blArray[184] = true;
        instrInt = blArray;
    }

    Instr(int o) {
        this.opcode = o;
    }

    Instr(int o, int a) {
        this.opcode = o;
        this.arg = a;
    }

    Instr(int o, int a1, int a2) {
        this.opcode = o;
        this.arg = a1;
        this.arg2 = a2;
    }

    Instr(int o, int a1, int a2, int a3) {
        this.opcode = o;
        this.arg = a1;
        this.arg2 = a2;
        this.arg3 = a3;
    }

    static Instr instrAt(Safeptr p) {
        int op = p.u1(0);
        switch (op) {
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 41: 
            case 42: 
            case 114: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 144: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                return new Instr(op, p.u1(1));
            }
            case 16: 
            case 18: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                return new Instr(op, p.s1(1));
            }
            case 63: 
            case 64: {
                return new Instr(op, p.u1(1) >> 4, p.u1(1) & 0xF);
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 145: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                return new Instr(op, p.u2(1));
            }
            case 17: 
            case 19: 
            case 113: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                return new Instr(op, p.s2(1));
            }
            case 20: {
                return new Instr(op, p.s4(1));
            }
            case 148: 
            case 149: {
                return new Instr(op, p.u1(1), p.u2(2));
            }
            case 142: {
                return new Instr(op, p.u2(2), p.u1(4), p.u1(1));
            }
            case 89: 
            case 90: {
                return new Instr(op, p.u1(1), p.s1(2));
            }
            case 150: 
            case 151: {
                return new Instr(op, p.u1(1), p.s2(2));
            }
            case 117: {
                InstrLookupSwitch is = new InstrLookupSwitch(op);
                is.dfl = p.s2(1);
                is.ncases = p.u2(3);
                is.keys = new int[is.ncases];
                is.offsets = new int[is.ncases];
                int i = 0;
                while (i < is.ncases) {
                    is.keys[i] = p.s2(5 + i * 4);
                    is.offsets[i] = p.s2(7 + i * 4);
                    ++i;
                }
                return is;
            }
            case 118: {
                InstrLookupSwitch is = new InstrLookupSwitch(op);
                is.dfl = p.s2(1);
                is.ncases = p.u2(3);
                is.keys = new int[is.ncases];
                is.offsets = new int[is.ncases];
                int i = 0;
                while (i < is.ncases) {
                    is.keys[i] = p.s4(5 + i * 6);
                    is.offsets[i] = p.s2(9 + i * 6);
                    ++i;
                }
                return is;
            }
            case 115: {
                InstrTableSwitch is = new InstrTableSwitch(op);
                is.dfl = p.s2(1);
                is.low = p.s2(3);
                is.high = p.s2(5);
                if (is.low > is.high) {
                    throw new VerifierError("Instr.1", p);
                }
                is.offsets = new int[is.high - is.low + 1];
                int i = is.low;
                while (i <= is.high) {
                    int j = i - is.low;
                    is.offsets[j] = p.s2(7 + j * 2);
                    ++i;
                }
                return is;
            }
            case 116: {
                InstrTableSwitch is = new InstrTableSwitch(op);
                is.dfl = p.s2(1);
                is.low = p.s4(3);
                is.high = p.s4(7);
                if (is.low > is.high) {
                    throw new VerifierError("Instr.2", p);
                }
                is.offsets = new int[is.high - is.low + 1];
                int i = is.low;
                while (i <= is.high) {
                    int j = i - is.low;
                    is.offsets[j] = p.s2(11 + j * 2);
                    ++i;
                }
                return is;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new Instr(op, op - 24);
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return new Instr(op, op - 28);
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return new Instr(op, op - 32);
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new Instr(op, op - 43);
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return new Instr(op, op - 47);
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new Instr(op, op - 51);
            }
        }
        if (op > 184) {
            throw new VerifierError("Instr.3", op, (Object)p);
        }
        return new Instr(op);
    }

    static Instr[] instrsBetween(Safeptr ptr, int len) throws VerifierError {
        Instr[] res = new Instr[len];
        int i = 0;
        while (i < len) {
            Instr instr;
            res[i] = instr = Instr.instrAt(ptr.offset(i));
            i += instr.length();
        }
        if (i > len) {
            throw new VerifierError("Instr.4", ptr);
        }
        return res;
    }

    boolean isBackwardBranch() {
        switch (this.opcode) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                return this.arg < 0;
            }
            case 114: {
                return true;
            }
        }
        return false;
    }

    int length() {
        return instrLength[this.opcode];
    }
}

