/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy;

import com.oracle.javacard.jcdebugproxy.ClassFileTokens;
import com.oracle.tee.tools.util.Utils;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ClassDebugUtils {
    public static <T> String toStringAsInterface(Class<? extends T> cl, T inst, String nameMethod) {
        return ClassDebugUtils.toStringAsInterface("  ", cl, inst, nameMethod);
    }

    public static List<String> parseSignature(String value) {
        int length = value.endsWith(")") ? value.length() - 1 : value.length();
        ArrayList<String> retVal = new ArrayList<String>();
        int arrayDepth = 0;
        for (int pos = value.startsWith("(") ? 1 : 0; pos < length; ++pos) {
            char c = value.charAt(pos);
            if (c == '[') {
                ++arrayDepth;
                continue;
            }
            String name = null;
            switch (c) {
                case 'Z': {
                    name = "boolean";
                    break;
                }
                case 'B': {
                    name = "byte";
                    break;
                }
                case 'C': {
                    name = "char";
                    break;
                }
                case 'L': {
                    int newPos = value.indexOf(59, pos);
                    name = value.substring(pos + 1, newPos).replace('/', '.');
                    pos = newPos;
                    break;
                }
                case 'D': {
                    name = "double";
                    break;
                }
                case 'F': {
                    name = "float";
                    break;
                }
                case 'I': {
                    name = "int";
                    break;
                }
                case 'J': {
                    name = "long";
                    break;
                }
                case 'S': {
                    name = "short";
                    break;
                }
                default: {
                    return null;
                }
            }
            if (arrayDepth > 0) {
                StringBuilder str = new StringBuilder(name);
                for (int i = 0; i < arrayDepth; ++i) {
                    str.append("[]");
                }
                name = str.toString();
            }
            retVal.add(name);
        }
        return retVal;
    }

    private static <T> String toStringAsInterface(String prefix, Class<? extends T> cl, T inst, String nameMethod) {
        StringBuilder retVal = new StringBuilder("(").append(cl.getSimpleName());
        Method nameMth = ClassDebugUtils.getMethod(cl, nameMethod);
        if (nameMethod != null && ClassDebugUtils.isPrintable(nameMth)) {
            retVal.append(" ");
            ClassDebugUtils.add(retVal, "    ", nameMth, inst);
        }
        Method[] list = cl.getMethods();
        Arrays.sort(list, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int retVal = o1.getName().compareTo(o2.getName());
                return retVal != 0 ? retVal : o1.hashCode() - o2.hashCode();
            }
        });
        String childPrefix = "  " + prefix;
        for (Method m : list) {
            if (!ClassDebugUtils.isPrintable(m) || m.getName().equals(nameMth.getName())) continue;
            retVal.append("\n").append(prefix).append(m.getName()).append("=");
            ClassDebugUtils.add(retVal, childPrefix, m, inst);
        }
        retVal.append(")");
        return retVal.toString();
    }

    private static Class getListParameter(Type type) {
        Type[] list;
        if (type == null) {
            return Object.class;
        }
        if (type instanceof ParameterizedType && (list = ((ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return ClassDebugUtils.getListParameter(list[0]);
        }
        return Object.class;
    }

    private static Object getValue(Method meth, Object inst) {
        if (meth == null) {
            return "ERROR:Unknown-Method";
        }
        try {
            return meth.invoke(inst, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            return "Can-Not-Get:" + ex.getTargetException();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return "Can-Not-Get:" + e;
        }
    }

    private static Method getMethod(Class cl, String meth) {
        try {
            return cl.getMethod(meth, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private static boolean isPrintable(Method meth) {
        Class<?> status = meth.getReturnType();
        return meth.getParameterTypes().length == 0 && !status.equals(Void.TYPE);
    }

    private static void add(StringBuilder retVal, String prefix, Method meth, Object inst) {
        Class<?> status = meth.getReturnType();
        if (meth.getParameterTypes().length != 0 || status.equals(Void.TYPE)) {
            return;
        }
        ClassDebugUtils.add(retVal, prefix, status, meth.getGenericReturnType(), ClassDebugUtils.getValue(meth, inst));
    }

    private static <T> void add(StringBuilder retVal, String prefix, Class<? extends T> status, Type generic, T val) {
        String childPrefix = "  " + prefix;
        if (val == null) {
            retVal.append("null");
        } else if (val instanceof String) {
            retVal.append('\"').append(val).append('\"');
        } else if (val instanceof byte[]) {
            retVal.append(Utils.canonize((byte[])val));
        } else if (val instanceof int[]) {
            retVal.append("[");
            int[] ar = (int[])val;
            for (int i = 0; i < ar.length; ++i) {
                if (i != 0) {
                    retVal.append(", ");
                }
                retVal.append(ar[i]);
            }
            retVal.append("]");
        } else if (List.class.isAssignableFrom(status)) {
            Class elemType = ClassDebugUtils.getListParameter(generic);
            List asList = (List)val;
            int length = asList.size();
            retVal.append("(");
            prefix = childPrefix;
            childPrefix = "  " + prefix;
            for (int i = 0; i < length; ++i) {
                retVal.append("\n").append(prefix);
                ClassDebugUtils.add(retVal, childPrefix, elemType, null, asList.get(i));
                if (i == length - 1) continue;
                retVal.append(" ");
            }
            retVal.append(")");
        } else if (status.isArray()) {
            Class<?> elemType = status.getComponentType();
            int length = Array.getLength(val);
            retVal.append("[");
            prefix = childPrefix;
            childPrefix = "  " + prefix;
            for (int i = 0; i < length; ++i) {
                retVal.append("\n").append(prefix);
                ClassDebugUtils.add(retVal, childPrefix, elemType, null, Array.get(val, i));
                if (i == length - 1) continue;
                retVal.append(" ");
            }
            retVal.append("]");
        } else if (status.isInterface()) {
            retVal.append(ClassDebugUtils.toStringAsInterface(childPrefix, status, val, null));
        } else {
            retVal.append(val);
        }
    }

    public static void ensureHas_toString(ClassFileTokens.ClassDebugInfoImpl cdil) {
        for (ClassFileTokens.MethodDebugInfoImpl method : cdil.methods) {
            boolean isSameSignature;
            boolean isPublicInstanceMethod = Modifier.isPublic(method.access_flags) && !Modifier.isStatic(method.access_flags);
            boolean bl = isSameSignature = "toString".equals(method.name) && "()Ljava/lang/String;".equals(method.getSignatureRaw());
            if (!isSameSignature || !isPublicInstanceMethod) continue;
            return;
        }
        ClassDebugUtils.append_dummy_toString_to_class(cdil);
    }

    private static void append_dummy_toString_to_class(ClassFileTokens.ClassDebugInfoImpl cdil) {
        ClassFileTokens.MethodDebugInfoImpl[] methods1 = cdil.methods;
        int toStringIndex = cdil.methods.length;
        ClassFileTokens.MethodDebugInfoImpl dummy_toString = new ClassFileTokens.MethodDebugInfoImpl(cdil, toStringIndex, "toString", "()Ljava/lang/String;");
        dummy_toString.access_flags = 1;
        dummy_toString.line_table = new ClassFileTokens.LineInfo[0];
        ClassFileTokens.MethodDebugInfoImpl[] methods2 = new ClassFileTokens.MethodDebugInfoImpl[methods1.length + 1];
        System.arraycopy(methods1, 0, methods2, 0, methods1.length);
        methods2[methods1.length] = dummy_toString;
        cdil.methods = methods2;
        cdil.method_count = methods2.length;
    }

    public static boolean isFake_toString(ClassDebugInfo cdi, MethodDebugInfo mdi, VMClassPool pool) {
        boolean isSameSignature;
        boolean isPublicInstanceMethod = Modifier.isPublic(mdi.getAccessFlags()) && !Modifier.isStatic(mdi.getAccessFlags());
        boolean bl = isSameSignature = "toString".equals(mdi.getName()) && "()Ljava/lang/String;".equals(mdi.getSignatureRaw());
        if (!isPublicInstanceMethod || !isSameSignature) {
            return false;
        }
        if (pool.getSystemClass() == cdi) {
            return true;
        }
        ClassDebugInfo objectCdi = pool.getClassBySignature("Ljava/lang/Object;");
        while (cdi != null && cdi != objectCdi) {
            for (MethodDebugInfo meth : cdi.getAllMethodInfo()) {
                if (!meth.getName().equals(mdi.getName()) || !meth.getSignatureRaw().equals(mdi.getSignatureRaw())) continue;
                return false;
            }
            String parent = VMClassPool.getJNISignature(cdi.getSuperClass());
            cdi = pool.getClassBySignature(parent);
        }
        return true;
    }
}

