/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.capdump;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class CapDump {
    static final String eol = System.getProperty("line.separator", "\n");
    static final int BYTES_PER_LINE = 16;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: capdump filename");
            System.exit(1);
        }
        try {
            String zipFileName = new File(args[0]).getCanonicalPath();
            ZipFile zipFile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry ze = enumeration.nextElement();
                if (ze.getName().equals("META-INF/MANIFEST.MF")) continue;
                InputStream in = zipFile.getInputStream(ze);
                System.out.println(CapDump.zipEntryString(ze, in));
            }
            zipFile.close();
        }
        catch (ZipException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static String zipEntryString(ZipEntry ze, InputStream in) throws IOException {
        int length;
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(ze.getName()) + " :" + eol);
        byte[] buf = new byte[10240];
        int j = 0;
        while ((length = in.read(buf, 0, buf.length)) != -1) {
            int i = 0;
            while (i < length) {
                int data = buf[i] & 0xFF;
                if (data < 16) {
                    sb.append(" 0" + Integer.toHexString(data));
                } else {
                    sb.append(" " + Integer.toHexString(data));
                }
                if (++j % 16 == 0) {
                    sb.append(eol);
                }
                ++i;
            }
        }
        return sb.toString();
    }
}

