/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.PackageIdentifier;

public abstract class Info {
    public static final int CLASS_REF = 1;
    public static final int INSTANCE_FIELD_REF = 2;
    public static final int VIRTUAL_METHOD_REF = 3;
    public static final int SUPER_METHOD_REF = 4;
    public static final int STATIC_FIELD_REF = 5;
    public static final int STATIC_METHOD_REF = 6;
    static final int INFO_SIZE = 4;
    public int tag;
    protected boolean isPackageInternal;
    protected String name;
    protected PackageIdentifier packageIdentifier;
    protected int classToken;
    protected Member resolvedTo;
    protected int lineNumber;
    protected String descriptor;

    Info(int tag, PackageIdentifier packageIdentifier, String name, String descriptor) {
        this.tag = tag;
        this.packageIdentifier = packageIdentifier;
        this.name = name;
        this.descriptor = descriptor;
        this.isPackageInternal = true;
    }

    Info(int tag, PackageIdentifier packageIdentifier, int classToken, String descriptor) {
        this.tag = tag;
        this.packageIdentifier = packageIdentifier;
        this.classToken = classToken;
        this.descriptor = descriptor;
        this.name = packageIdentifier.toString() + " " + Integer.toString(classToken);
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void resolve(Member member) {
        assert (member != null) : "member != null";
        this.resolvedTo = member;
    }

    public Member resolve() {
        assert (this.resolvedTo != null) : "resolvedTo != null";
        return this.resolvedTo;
    }

    public boolean isResolved() {
        return this.resolvedTo != null;
    }

    public int size() {
        return 4;
    }

    public int getType() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public PackageIdentifier getPackageIdentifier() {
        return this.packageIdentifier;
    }

    public int getClassToken() {
        return this.classToken;
    }

    public boolean isPackageInternal() {
        return this.isPackageInternal;
    }

    public byte[] toByteArray(JCPackage p) {
        byte[] array = new byte[this.size()];
        array[0] = (byte)this.tag;
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.resolvedTo != null) {
            sb.append(this.resolvedTo.getName());
        } else if (this.isPackageInternal) {
            if (this.name != null) {
                sb.append(this.name);
            } else {
                sb.append("??");
            }
        } else {
            sb.append(this.packageIdentifier + " " + this.classToken);
        }
        return sb.toString();
    }
}

