/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrStackConverter
extends InstructionConverter {
    public InstrStackConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    public JcInstruction convert() {
        int java_opcode = this.java_instr.getOpcode();
        switch (java_opcode) {
            case 87: {
                OperandStackEntry entry = this.operand_stack.pop();
                this.jc_instr = entry.getType() == 3 ? new JcInstrNoOperands(60) : new JcInstrNoOperands(59);
                return this.jc_instr;
            }
            case 88: {
                OperandStackEntry entry2 = this.operand_stack.pop();
                OperandStackEntry entry1 = this.operand_stack.pop();
                if (entry1.getType() != 3 && entry2.getType() != 3) {
                    this.jc_instr = new JcInstrNoOperands(60);
                    return this.jc_instr;
                }
                this.jc_instr = entry2.getType() == 3 ? new JcInstrNoOperands(60) : new JcInstrNoOperands(59);
                JcInstrNoOperands next_instr = entry1.getType() == 3 ? new JcInstrNoOperands(60) : new JcInstrNoOperands(59);
                this.jc_instr.setNextInstr(next_instr);
                next_instr.setPrevInstr(this.jc_instr);
                return this.jc_instr;
            }
            case 89: {
                OperandStackEntry entry = this.operand_stack.peek(1);
                this.jc_instr = entry.getType() == 3 ? new JcInstrNoOperands(62) : new JcInstrNoOperands(61);
                this.operand_stack.dup(this.instr_container);
                return this.jc_instr;
            }
            case 92: {
                OperandStackEntry entry1 = this.operand_stack.peek(1);
                OperandStackEntry entry2 = this.operand_stack.peek(2);
                int num_words = entry1.getSizeInWords() + entry2.getSizeInWords();
                int mn = this.makeMN(num_words, 0);
                this.jc_instr = num_words == 2 ? new JcInstrNoOperands(62) : new JcInstrByteIndex(63, mn);
                this.operand_stack.dup2(this.instr_container);
                return this.jc_instr;
            }
            case 90: {
                OperandStackEntry entry1 = this.operand_stack.peek(1);
                OperandStackEntry entry2 = this.operand_stack.peek(2);
                int m = entry1.getSizeInWords();
                int n = entry1.getSizeInWords() + entry2.getSizeInWords();
                int mn = this.makeMN(m, n);
                this.jc_instr = new JcInstrByteIndex(63, mn);
                this.operand_stack.dup_x1(this.instr_container);
                return this.jc_instr;
            }
            case 91: {
                OperandStackEntry entry1 = this.operand_stack.peek(1);
                OperandStackEntry entry2 = this.operand_stack.peek(2);
                OperandStackEntry entry3 = this.operand_stack.peek(3);
                int m = entry1.getSizeInWords();
                int n = entry1.getSizeInWords() + entry2.getSizeInWords() + entry3.getSizeInWords();
                int mn = this.makeMN(m, n);
                this.jc_instr = new JcInstrByteIndex(63, mn);
                this.operand_stack.dup_x2(this.instr_container);
                return this.jc_instr;
            }
            case 93: {
                OperandStackEntry entry1 = this.operand_stack.peek(1);
                OperandStackEntry entry2 = this.operand_stack.peek(2);
                OperandStackEntry entry3 = this.operand_stack.peek(3);
                int m = entry1.getSizeInWords() + entry2.getSizeInWords();
                int n = entry1.getSizeInWords() + entry2.getSizeInWords() + entry3.getSizeInWords();
                int mn = this.makeMN(m, n);
                this.jc_instr = new JcInstrByteIndex(63, mn);
                this.operand_stack.dup2_x1(this.instr_container);
                return this.jc_instr;
            }
            case 94: {
                OperandStackEntry entry1 = this.operand_stack.peek(1);
                OperandStackEntry entry2 = this.operand_stack.peek(2);
                OperandStackEntry entry3 = this.operand_stack.peek(3);
                OperandStackEntry entry4 = this.operand_stack.peek(4);
                int m = entry1.getSizeInWords() + entry2.getSizeInWords();
                int n = entry1.getSizeInWords() + entry2.getSizeInWords() + entry3.getSizeInWords() + entry4.getSizeInWords();
                int mn = this.makeMN(m, n);
                this.jc_instr = new JcInstrByteIndex(63, mn);
                this.operand_stack.dup2_x2(this.instr_container);
                return this.jc_instr;
            }
            case 95: {
                OperandStackEntry entry1 = this.operand_stack.peek(1);
                OperandStackEntry entry2 = this.operand_stack.peek(2);
                int m = entry1.getSizeInWords();
                int n = entry2.getSizeInWords();
                int mn = this.makeMN(m, n);
                this.jc_instr = new JcInstrByteIndex(64, mn);
                this.operand_stack.swap(this.instr_container);
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private int makeMN(int m, int n) {
        int mn = m << 4 | n;
        return mn;
    }
}

