/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JConstantValueAttr;
import com.sun.javacard.classfile.constants.JConstant;
import com.sun.javacard.classfile.constants.JConstantInteger;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class JField
extends FieldDefinition {
    private JConstantPool constant_pool;
    private int name_index;
    private int descriptor_index;
    private JAttribute[] attributes;
    private JConstant constant;

    public JField(JConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public JConstant getConstant() {
        return this.constant;
    }

    public void parse(DataInputStream dis) throws IOException {
        this.access_flags = dis.readUnsignedShort();
        this.name_index = dis.readUnsignedShort();
        this.descriptor_index = dis.readUnsignedShort();
        int attrib_count = dis.readUnsignedShort();
        this.attributes = new JAttribute[attrib_count];
        int i = 0;
        while (i < attrib_count) {
            int index = dis.readUnsignedShort();
            this.attributes[i] = JAttribute.create(this.constant_pool, index);
            this.attributes[i].parse(dis);
            ++i;
        }
    }

    public void resolve() {
        this.field_name = this.constant_pool.getConstantUtf8(this.name_index).getString();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getString();
        if (!Modifier.isStatic(this.access_flags)) {
            return;
        }
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i] instanceof JConstantValueAttr) {
                JConstantValueAttr cva = (JConstantValueAttr)this.attributes[i];
                if (this.descriptor.length() == 1) {
                    switch (this.descriptor.charAt(0)) {
                        case 'B': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            this.value = new int[1];
                            JConstantInteger const_int = this.constant_pool.getConstantInteger(((JConstantValueAttr)this.attributes[i]).getValueIndex());
                            if (const_int == null) {
                                throw new ClassFormatError();
                            }
                            this.value[0] = const_int.getInt();
                            return;
                        }
                    }
                }
            }
            ++i;
        }
    }
}

