/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrLoadConverter
extends InstructionConverter {
    public InstrLoadConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    public JcInstruction convert() throws Exception {
        int java_local_index;
        int java_opcode = this.java_instr.getOpcode();
        switch (java_opcode) {
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                java_local_index = java_opcode - 26;
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                java_local_index = java_opcode - 42;
                break;
            }
            case 21: {
                java_local_index = ((JInstrByteIndex)this.java_instr).getIndex();
                break;
            }
            case 25: {
                java_local_index = ((JInstrByteIndex)this.java_instr).getIndex();
                break;
            }
            default: {
                throw new ConverterInternalError();
            }
        }
        JcLocalVariable local_var = this.method_converter.getLocalVariableConverter().getJcLocalVariable(java_local_index, this.java_instr);
        if (local_var == null) {
            throw new ConverterInternalError();
        }
        this.jc_instr = this.createLoadInstruction(local_var);
        int type = local_var.getType();
        this.operand_stack.push(type, this.instr_container);
        return this.jc_instr;
    }

    private JcInstruction createLoadInstruction(JcLocalVariable local_var) throws Exception {
        int type = local_var.getType();
        int new_index = local_var.getJcIndex();
        switch (type) {
            case 1: 
            case 2: {
                if (new_index < 4) {
                    return new JcInstrNoOperands(28 + new_index);
                }
                return new JcInstrByteIndex(22, new_index);
            }
            case 3: {
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.5", this.method_converter.getClassName().replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                if (new_index < 4) {
                    return new JcInstrNoOperands(32 + new_index);
                }
                return new JcInstrByteIndex(23, new_index);
            }
            case 10: {
                if (new_index < 4) {
                    return new JcInstrNoOperands(24 + new_index);
                }
                return new JcInstrByteIndex(21, new_index);
            }
        }
        throw new ConverterInternalError();
    }
}

