/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.StateEventHandler;
import java.io.DataOutputStream;
import java.io.IOException;

public class ExceptionHandler
extends StateEventHandler {
    int reportCaughtCount;
    int reportUncaughtCount;

    public ExceptionHandler() {
        super((byte)5);
    }

    @Override
    protected boolean addRequest(EventFilter filter) {
        super.addRequest(filter);
        EventFilter.ExceptionModifier mod = (EventFilter.ExceptionModifier)filter.getModifier(8);
        if (mod == null) {
            return false;
        }
        if (mod.reportCaught) {
            ++this.reportCaughtCount;
        }
        if (mod.reportUncaught) {
            ++this.reportUncaughtCount;
        }
        return true;
    }

    @Override
    protected boolean cleared(EventFilter filter) {
        EventFilter.ExceptionModifier mod = (EventFilter.ExceptionModifier)filter.getModifier(8);
        if (mod != null) {
            if (mod.reportCaught) {
                --this.reportCaughtCount;
            }
            if (mod.reportUncaught) {
                --this.reportUncaughtCount;
            }
        }
        return true;
    }

    @Override
    protected void writeClearArguments(DataOutputStream toVm, EventFilter filter) throws IOException {
        toVm.writeBoolean(this.reportCaughtCount > 0);
        toVm.writeBoolean(this.reportUncaughtCount > 0);
    }

    @Override
    protected synchronized void writeArguments(DataOutputStream toVm, EventFilter filter) throws IOException {
        super.writeArguments(toVm, filter);
        toVm.writeBoolean(this.reportCaughtCount > 0);
        toVm.writeBoolean(this.reportUncaughtCount > 0);
    }

    @Override
    public synchronized void clear() throws Exception {
        super.clear();
        this.reportCaughtCount = 0;
        this.reportUncaughtCount = 0;
    }
}

