/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic.handlers;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.VmState;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.concurrent.CountDownLatch;

public class ChangeStateHandler
extends ClassicPacketHandlerImpl {
    private VmState.State state;

    public ChangeStateHandler(VmState.State state) {
        super(VMPacketHandler.CommandCode.SET_STATE);
        this.state = state;
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
        boolean doStateChange = this.proxy.state().getState() != this.state;
        VmState.State current = this.proxy.state().getState();
        Log.LOG(4, "BP:STATE:" + (Object)((Object)current) + " -> " + (Object)((Object)this.state) + " queue=" + this.proxy.state().eventQueue());
        if (this.state == VmState.State.RUNNING && !this.proxy.state().eventQueue().isEmpty()) {
            this.proxy.events.syncQueue();
            return ClassicPacketHandler.DeliveryType.NONE;
        }
        if (this.state == VmState.State.SUSPENDED && current == VmState.State.SUSPENDED) {
            this.proxy.state().suspend();
            doStateChange = false;
        } else if (this.state == VmState.State.RUNNING) {
            doStateChange &= this.proxy.state().resume() == 0;
        }
        if (doStateChange) {
            state.lock = new CountDownLatch(1);
            this.proxy.events.requestVMStateChange(this.state, state, toVm);
            return ClassicPacketHandler.DeliveryType.IMMEDIATELY;
        }
        state.lock = null;
        return ClassicPacketHandler.DeliveryType.NONE;
    }

    @Override
    public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
        if (state.lock != null) {
            state.lock.await();
        }
    }
}

