/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcre;

import com.sun.javacard.ClassicLibraryClassLoader;
import com.sun.javacard.ExtensionLibraryClassLoader;
import com.sun.javacard.Logger;
import com.sun.javacard.appletcontainer.AppletServer;
import com.sun.javacard.cm.impl.ApplicationBundleImpl;
import com.sun.javacard.cm.impl.DeploymentUnitLoaderImpl;
import com.sun.javacard.cm.impl.IDManager;
import com.sun.javacard.cm.impl.RomizedBundle;
import com.sun.javacard.cm.impl.SecurityUtil;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.impl.CryptoInit;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jaxp.ukit.jaxp.Parser;
import com.sun.javacard.jcre.JCRuntime;
import com.sun.javacard.jcre.TaskRegistryAccessor;
import com.sun.javacard.security.BioGlobalAuthenticatorFactory;
import com.sun.javacard.security.BioSessionAuthenticatorFactory;
import com.sun.javacard.security.PINGlobalAuthenticatorFactory;
import com.sun.javacard.security.PINSessionAuthenticatorFactory;
import com.sun.javacard.security.PasswordGlobalAuthenticatorFactory;
import com.sun.javacard.security.PasswordSessionAuthenticatorFactory;
import com.sun.javacard.security.SIOUserRealm;
import com.sun.javacard.spi.security.ProtectionDomain;
import com.sun.javacard.util.JCSystemAccessor;
import com.sun.midp.io.j2me.http.Protocol;
import com.sun.midp.ssl.Handshake;
import com.sun.midp.ssl.MAC;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import javacardx.facilities.EventRegistry;
import javacardx.facilities.ServiceRegistry;
import javacardx.facilities.TaskRegistry;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.jetty.WebServer;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.util.LazyList;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public final class Card {
    public static final String CARDMANAGER_CONTEXT_PATH = "/cardmanager";
    public static final String CARDMANAGER_APP_URI = "///cardmanager";
    private static boolean CMInitialized = false;
    private static UserRealm[] userRealms;
    public static boolean quickTestingWarLoaded;
    private static ContextHandlerCollection contexts;
    private static WebServer webServer;
    private static AppletServer appletServer;
    static int CMAppFirewallContext;
    static ApplicationBundleImpl cmAppBundle;
    static Vector<RomizedBundle> romizedBundles;

    public static native boolean isInitialized();

    public static native void setInitialized();

    public static boolean isCMInitialized() {
        return CMInitialized;
    }

    public static void initialize() throws IOException {
        if (Card.isInitialized()) {
            return;
        }
        new Boolean(false);
        Logger.info("Initializing Card ...");
        Card.initClassLoaders();
        Logger.info("    ClassLoaders ... Initialized");
        JCSystemAccessor.instantiateJCSystemAccessor();
        Card.initializePlatformPolicy();
        SecurityUtil.initSecurityUtil();
        Logger.info("    Platform Policy ... Initialized");
        Card.populateServiceRegistry();
        Logger.info("    ServiceRegistry ... Initialized");
        EventRegistry.getEventRegistry();
        TaskRegistry taskRegistry = Card.initTaskRegistry();
        Logger.info("    TaskRegistry ... Initialized");
        Parser.prepareParserForFirewallOps();
        Card.initCrypto();
        Logger.info("    Crypto System ... Initialized");
        Protocol.init();
        Logger.info("    Transaction Facility - Initialized");
        Card.initWebContainer();
        Logger.info("    Web Container ... Initialized");
        Card.initAppletContainer();
        Logger.info("    Applet Container ... Initialized");
        Handshake.initHandshake();
        Logger.info("    Handshake Mechanism ... Initialized");
        Card.startWebServer();
        Logger.info("    Web Server ... Started");
        Card.startAppletServer();
        Logger.info("    APDU Dispatcher(s) ... Started");
        Card.initializeRomizedAppBundles();
        Card.setInitialized();
        Logger.info("Card Ready.");
    }

    public static void reset() {
        Logger.info("Resetting the Card ...");
        Card.restartTasks();
        Logger.info("    Restarting Restartable Tasks ... Done");
        try {
            webServer.reset();
            Logger.info("    Resetting Web container state ... Done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            appletServer.reset();
            Logger.info("    Resetting Applet container state ... Done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Card.startWebServer();
        Logger.info("    Starting Web Server ... Done");
        Card.startAppletServer();
        Logger.info("    Starting Applet Server ... Done");
        Logger.info("Card Ready.");
    }

    private static void initCrypto() {
        CryptoInit.initCryptoStorage();
        MAC.initStaticData();
    }

    private static void initClassLoaders() {
        ClassicLibraryClassLoader.getClassicLibraryClassLoader();
        ExtensionLibraryClassLoader.getExtensionLibraryClassLoader();
    }

    private static void initializePlatformPolicy() {
        ProtectionDomain.initializePlatformPolicy();
    }

    private static void initWebContainer() {
        SIOUserRealm userRealm = new SIOUserRealm("JCRealm");
        Logger.debug("REALM NAME IS:" + userRealm.getName());
        NativeMethods.setJCREentry(userRealm, false);
        SIOUserRealm transitUserRealm = new SIOUserRealm("transit");
        NativeMethods.setJCREentry(transitUserRealm, false);
        userRealms = new UserRealm[]{userRealm, transitUserRealm};
        webServer = WebServer.getWebServer();
        contexts = new ContextHandlerCollection();
        webServer.addHandler(contexts);
        webServer.setUserRealms(LazyList.array2List(userRealms));
    }

    private static void initAppletContainer() {
        appletServer = AppletServer.getAppletServer();
    }

    private static TaskRegistry initTaskRegistry() {
        return TaskRegistry.getTaskRegistry();
    }

    private static void startWebServer() {
        try {
            webServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void startAppletServer() {
        try {
            appletServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void restartTasks() {
        TaskRegistryAccessor taskRegistryAccessor = TaskRegistryAccessor.getTaskRegistryAccessor();
        Enumeration<Runnable> en = taskRegistryAccessor.list();
        while (en.hasMoreElements()) {
            taskRegistryAccessor.runIt(en.nextElement());
        }
    }

    private static void populateServiceRegistry() {
        ServiceRegistry registry = ServiceRegistry.getServiceRegistry();
        String sioURI = null;
        String className = null;
        String credential = null;
        String digest = null;
        for (int i = 0; i < Integer.MAX_VALUE && (sioURI = JCRuntime.getConfigProperty("authenticator." + i + ".uri", null)) != null; ++i) {
            className = JCRuntime.getConfigProperty("authenticator." + i + ".factory", null);
            if (className == null || (credential = JCRuntime.getConfigProperty("authenticator." + i + ".pin", null)) == null && (credential = JCRuntime.getConfigProperty("authenticator." + i + ".password", null)) == null) continue;
            digest = JCRuntime.getConfigProperty("authenticator." + i + ".digest", "false");
            String s = JCRuntime.getConfigProperty("authenticator." + i + ".trylimit", "3");
            int tryLimit = Integer.valueOf(s);
            byte[] credentialBytes = credential.getBytes();
            if (className.equalsIgnoreCase("com.sun.javacard.security.PINSessionAuthenticatorFactory")) {
                Logger.debug("Creating Session Authenticator ", sioURI, "  ", credential);
                if (digest.equals("false")) {
                    registry.register(sioURI, new PINSessionAuthenticatorFactory(credentialBytes, (byte)credentialBytes.length, tryLimit));
                    continue;
                }
                registry.register(sioURI, new PasswordSessionAuthenticatorFactory(credential, tryLimit));
                continue;
            }
            if (className.equalsIgnoreCase("com.sun.javacard.security.PINGlobalAuthenticatorFactory")) {
                Logger.debug("Creating global Authenticator ", sioURI, "  ", credential);
                if (digest.equals("false")) {
                    registry.register(sioURI, new PINGlobalAuthenticatorFactory(credentialBytes, (byte)credentialBytes.length, tryLimit));
                    continue;
                }
                registry.register(sioURI, new PasswordGlobalAuthenticatorFactory(credential, tryLimit));
                continue;
            }
            if (className.equalsIgnoreCase("com.sun.javacard.security.BioGlobalAuthenticatorFactory")) {
                Logger.debug("Creating global Authenticator ", sioURI, "  ", credential);
                registry.register(sioURI, new BioGlobalAuthenticatorFactory(credentialBytes, tryLimit));
                continue;
            }
            if (className.equalsIgnoreCase("com.sun.javacard.security.BioSessionAuthenticatorFactory")) {
                Logger.debug("Creating session Authenticator ", sioURI, "  ", credential);
                registry.register(sioURI, new BioSessionAuthenticatorFactory(credentialBytes, tryLimit));
                continue;
            }
            if (className.equalsIgnoreCase("com.sun.javacard.security.PasswordGlobalAuthenticatorFactory")) {
                Logger.debug("Creating global Authenticator ", sioURI, "  ", credential);
                registry.register(sioURI, new PasswordGlobalAuthenticatorFactory(credential, tryLimit));
                continue;
            }
            if (!className.equalsIgnoreCase("com.sun.javacard.security.PasswordSessionAuthenticatorFactory")) continue;
            Logger.debug("Creating session Authenticator ", sioURI, "  ", credential);
            registry.register(sioURI, new PasswordSessionAuthenticatorFactory(credential, tryLimit));
        }
    }

    public static void initializeRomizedAppBundles() throws IOException {
        DeploymentUnitLoaderImpl duLoaderImpl = DeploymentUnitLoaderImpl.getDeploymentUnitLoaderImpl();
        FileConnection mf = new FileConnection("/rom", "romizedAppInfo.txt");
        if (!mf.exists()) {
            return;
        }
        InputStream is = mf.openInputStream();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String bundleName = br.readLine();
            while (bundleName != null) {
                RomizedBundle newBundle = new RomizedBundle();
                newBundle.bundleName = bundleName.trim();
                Card.processRomizedBundle(duLoaderImpl, newBundle);
                romizedBundles.addElement(newBundle);
                bundleName = br.readLine();
            }
        }
        catch (Exception e) {
            System.out.println("Unexpected exception " + e);
            e.printStackTrace();
        }
        if (cmAppBundle != null) {
            Card.initCMApp();
        }
    }

    private static void processRomizedBundle(DeploymentUnitLoaderImpl duLoaderImpl, RomizedBundle newBundle) throws Exception {
        String bundleDirName = "/rom/" + newBundle.bundleName;
        int bundleType = -1;
        int classLoaderId = -1;
        int bundleFirewallId = 0;
        boolean processingCMApp = false;
        FileConnection bundleDir = new FileConnection(bundleDirName);
        FileConnection mf = new FileConnection(bundleDirName, "bundleInfo.txt");
        InputStream is = mf.openInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).startsWith("appType")) {
                String appTypeStr = line.substring(line.indexOf("=") + 1);
                if (appTypeStr.equals("extended-applet")) {
                    bundleType = 11;
                } else if (appTypeStr.equals("classic-applet")) {
                    bundleType = 12;
                } else {
                    if (appTypeStr.equalsIgnoreCase("CM")) {
                        processingCMApp = true;
                    }
                    bundleType = 10;
                }
            } else if (line.startsWith("classLoaderID")) {
                classLoaderId = Integer.parseInt(line.substring(line.indexOf("=") + 1));
            } else {
                bundleFirewallId = Integer.parseInt(line.substring(line.indexOf("=") + 1));
                IDManager.addBundleId(bundleFirewallId);
            }
            line = br.readLine();
        }
        ApplicationBundleImpl appBundle = (ApplicationBundleImpl)duLoaderImpl.loadApplicationBundle(bundleDir, (byte)bundleType, bundleDirName, bundleFirewallId);
        duLoaderImpl.addToLoadedBundlesList(appBundle);
        newBundle.appBundle = appBundle;
        Card.processBundleSigFile(appBundle, bundleFirewallId, bundleDirName, processingCMApp, bundleType, newBundle);
        if (processingCMApp) {
            cmAppBundle = appBundle;
        }
    }

    static void processBundleSigFile(ApplicationBundleImpl appBundle, int bundleId, String bundleDir, boolean cmApp, int appType, RomizedBundle newBundle) {
        ProtectionDomain pd = null;
        FileConnection fc = new FileConnection(bundleDir, "sig.txt");
        try {
            InputStream fcis = fc.openInputStream();
            BufferedReader bReader = new BufferedReader(new InputStreamReader(fcis));
            String line = bReader.readLine();
            while (line != null) {
                if ((line = line.trim()).startsWith("signature")) {
                    newBundle.signature = line.substring(line.indexOf("=") + 1);
                } else if (line.startsWith("certificate")) {
                    newBundle.signingCert = line.substring(line.indexOf("=") + 1);
                } else if (line.startsWith("selfIdServer")) {
                    newBundle.serverSelfIdCertBytes = line.substring(line.indexOf("=") + 1).getBytes();
                } else if (line.startsWith("sslPrivKeyMod")) {
                    newBundle.privateKeyModBytes = line.substring(line.indexOf("=") + 1).getBytes();
                } else if (line.startsWith("sslPrivKeyExp")) {
                    newBundle.privateKeyExpBytes = line.substring(line.indexOf("=") + 1).getBytes();
                } else if (line.startsWith("serverId")) {
                    newBundle.serverCARootCertBytes = line.substring(line.indexOf("=") + 1).getBytes();
                }
                line = bReader.readLine();
            }
        }
        catch (IOException e) {
            Logger.debug("this is a cmApp");
        }
        if (cmApp) {
            pd = ProtectionDomain.createProtectionDomain("CMProtectionDomain", "CardManagement");
            appBundle.init(pd, null, null);
        }
        appBundle.setRomized();
    }

    private static void initCMApp() {
        NativeMethods.transferOwnershiptoContext(romizedBundles, cmAppBundle.getFirewallId(), 0);
        try {
            Object initParams = null;
            cmAppBundle.newApplication("", null, CARDMANAGER_CONTEXT_PATH, null, initParams);
        }
        catch (Exception e) {
            Logger.fatal("Could not instantiate Card Manager \n" + e.toString());
            e.printStackTrace();
            JCRuntime.exit(-1);
        }
        CMInitialized = true;
    }

    public static Vector<RomizedBundle> getRomizedBundles() {
        Vector<RomizedBundle> tempRomizedBundles = romizedBundles;
        romizedBundles = null;
        return tempRomizedBundles;
    }

    static {
        quickTestingWarLoaded = false;
        romizedBundles = new Vector();
    }
}

