/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcre;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jcre.TaskWrapper;
import com.sun.javacard.util.URIUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class TaskRegistryAccessor {
    private static TaskRegistryAccessor taskRegistryAccessor = new TaskRegistryAccessor();
    private Hashtable<Runnable, String> tasks = new Hashtable();
    private TransientReference<Hashtable<Runnable, Thread>> runningTasks = new TransientReference<Object>(null);

    public static final TaskRegistryAccessor getTaskRegistryAccessor() {
        return taskRegistryAccessor;
    }

    public void register(Runnable task, boolean eager) throws SecurityException {
        if (!this.tasks.contains(task)) {
            this.tasks.put(task, URIUtils.getAppURI());
        } else if (!URIUtils.getAppURI().equals(this.tasks.get(task))) {
            throw new SecurityException();
        }
        if (this.isRunning(task) && !eager) {
            this.runningTasks.get().get(task).interrupt();
        } else if (!this.isRunning(task) && eager) {
            this.runIt(task);
        }
    }

    public void removeFromRunningList(Runnable task) {
        Hashtable<Runnable, Thread> rts = this.getRunningTasksTable();
        rts.remove(task);
    }

    public void runIt(Runnable task) {
        Hashtable<Runnable, Thread> rts = this.getRunningTasksTable();
        TaskWrapper thread = new TaskWrapper(task);
        rts.put(task, thread);
        thread.start();
    }

    private boolean isRunning(Runnable task) {
        Hashtable<Runnable, Thread> rts = this.getRunningTasksTable();
        return rts.get(task) != null;
    }

    private Hashtable<Runnable, Thread> getRunningTasksTable() {
        Hashtable<Runnable, Thread> rts = this.runningTasks.get();
        if (rts == null) {
            rts = new Hashtable();
            this.runningTasks.set(rts);
        }
        return rts;
    }

    public Enumeration<Runnable> list() {
        return this.tasks.keys();
    }

    public void unregister(Runnable task, boolean eager) throws SecurityException {
        String appURI = this.tasks.get(task);
        if (appURI == null) {
            return;
        }
        if (!URIUtils.getAppURI().equals(appURI)) {
            throw new SecurityException();
        }
        Hashtable<Runnable, Thread> rts = this.getRunningTasksTable();
        Thread thread = rts.get(task);
        if (eager && thread != null) {
            thread.interrupt();
        }
        this.tasks.remove(task);
        rts.remove(task);
    }

    public void unregister(String appUri) {
        Enumeration<Runnable> t = this.tasks.keys();
        Hashtable<Runnable, Thread> rts = this.getRunningTasksTable();
        while (t.hasMoreElements()) {
            Runnable task = t.nextElement();
            if (!this.tasks.get(task).equals(appUri)) continue;
            Thread thread = rts.get(task);
            if (thread != null) {
                thread.interrupt();
            }
            this.tasks.remove(task);
            rts.remove(task);
        }
    }

    public boolean containsDependency(short[] appList) {
        Enumeration<Runnable> t = this.tasks.keys();
        while (t.hasMoreElements()) {
            Runnable task = t.nextElement();
            if (!this.contains(appList, NativeMethods.objectOwner(task))) continue;
            return true;
        }
        return false;
    }

    private boolean contains(short[] appList, int appId) {
        if (appList != null) {
            for (int i = 0; i < appList.length; ++i) {
                if (appList[i] != appId) continue;
                return true;
            }
        }
        return false;
    }

    static {
        NativeMethods.setJCREentry(taskRegistryAccessor, false);
    }
}

