/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.sun.javacard.impl.JCCryptoAccessor;
import javacard.security.CryptoException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class Checksum {
    public static final String SERVICE_NAME = "checksum";
    public static final byte ALG_ISO3309_CRC16 = 1;
    public static final byte ALG_ISO3309_CRC32 = 2;
    private static JCCryptoAccessor cryptoAccessorInstance = JCCryptoAccessor.getInstance();

    public static final Checksum getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        Checksum instance = null;
        switch (algorithm) {
            case 1: {
                instance = Checksum.getInstance("ISO3309_CRC16", externalAccess);
                break;
            }
            case 2: {
                instance = Checksum.getInstance("ISO3309_CRC32", externalAccess);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public static final Checksum getInstance(String algorithm, boolean externalAccess) throws CryptoException {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (Checksum)o;
    }

    public static final Checksum getInstance(String algorithm, String provider, boolean externalAccess) throws CryptoException {
        if (algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), provider, externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (Checksum)o;
    }

    protected Checksum() {
    }

    public abstract void init(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract byte getAlgorithm();

    public abstract String getAlgorithmName();

    public abstract short doFinal(byte[] var1, short var2, short var3, byte[] var4, short var5);

    public abstract void update(byte[] var1, short var2, short var3);
}

