/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import com.sun.javacard.Logger;
import java.io.IOException;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;
import javax.microedition.io.SocketConnection;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.component.LifeCycle;
import org.mortbay.io.Buffer;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.WebConnector;
import org.mortbay.jetty.WebServer;
import org.mortbay.thread.ThreadPool;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class AbstractConnector
extends AbstractLifeCycle
implements WebConnector {
    private int headerBufferSize = 1024;
    private int requestBufferSize = 1024;
    private int responseBufferSize = 2048;
    private String name;
    private ThreadPool threadPool;
    private String host;
    private int port = 0;
    private String integralScheme = "https";
    private int integralPort = 0;
    private String confidentialScheme = "https";
    private int confidentialPort = 0;
    private int acceptQueueSize = 0;
    private int acceptors = 1;
    private boolean useDNS;
    protected int maxIdleTime = 30000;
    protected int lowResourceMaxIdleTime = -1;
    protected int soLingerTime = 1000;
    private Vector<Buffer> headerBuffers;
    private Vector<Buffer> requestBuffers;
    private Vector<Buffer> responseBuffers;
    TransientReference<Vector<Thread>> acceptorThreads = new TransientReference<Object>(null);
    Object statsLock = new Object();
    long statsStartedAt = -1L;
    int requests;
    int connections;
    int connectionsOpen;
    int connectionsOpenMin;
    int connectionsOpenMax;
    long connectionsDurationMin;
    long connectionsDurationMax;
    long connectionsDurationTotal;
    int connectionsRequestsMin;
    int connectionsRequestsMax;

    @Override
    public abstract void open() throws IOException;

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        this.threadPool = pool;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getHeaderBufferSize() {
        return this.headerBufferSize;
    }

    @Override
    public void setHeaderBufferSize(int headerBufferSize) {
        this.headerBufferSize = headerBufferSize;
    }

    @Override
    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public int getLowResourceMaxIdleTime() {
        return this.lowResourceMaxIdleTime;
    }

    @Override
    public void setLowResourceMaxIdleTime(int maxIdleTime) {
        this.lowResourceMaxIdleTime = maxIdleTime;
    }

    @Override
    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    @Override
    public void setRequestBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    @Override
    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    @Override
    public void setResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public long getSoLingerTime() {
        return this.soLingerTime;
    }

    public int getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this.acceptQueueSize = acceptQueueSize;
    }

    public int getAcceptors() {
        return this.acceptors;
    }

    public void setAcceptors(int acceptors) {
        this.acceptors = acceptors;
    }

    public void setSoLingerTime(int soLingerTime) {
        this.soLingerTime = soLingerTime;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.open();
        if (this.headerBuffers != null) {
            this.headerBuffers.removeAllElements();
        } else {
            this.headerBuffers = new Vector();
        }
        if (this.requestBuffers != null) {
            this.requestBuffers.removeAllElements();
        } else {
            this.requestBuffers = new Vector();
        }
        if (this.responseBuffers != null) {
            this.responseBuffers.removeAllElements();
        } else {
            this.responseBuffers = new Vector();
        }
        if (this.threadPool == null) {
            this.threadPool = WebServer.getWebServer().getThreadPool();
        }
        if (this.threadPool != WebServer.getWebServer().getThreadPool() && this.threadPool instanceof LifeCycle) {
            ((LifeCycle)((Object)this.threadPool)).start();
        }
        this.acceptorThreads.set(new Vector());
        for (int i = 0; i < this.getAcceptors(); ++i) {
            if (this.threadPool.dispatch(new Acceptor(i))) continue;
            Logger.debug("insufficient maxThreads configured for {}");
            break;
        }
        Logger.debug("Started {}");
    }

    @Override
    protected void doStop() throws Exception {
        if (this.threadPool != WebServer.getWebServer().getThreadPool() && this.threadPool instanceof LifeCycle) {
            ((LifeCycle)((Object)this.threadPool)).stop();
        }
        try {
            this.close();
        }
        catch (IOException e) {
            Logger.debug(e);
        }
        super.doStop();
    }

    public void join() throws InterruptedException {
        Vector<Thread> threads = this.acceptorThreads.get();
        if (threads != null) {
            for (Thread element : threads) {
                if (element == null) continue;
                element.join();
            }
        }
    }

    protected void configure(SocketConnection socket) {
        try {
            socket.setSocketOption((byte)0, 0);
            if (this.soLingerTime >= 0) {
                socket.setSocketOption((byte)1, this.soLingerTime / 1000);
            } else {
                socket.setSocketOption((byte)1, 0);
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
    }

    @Override
    public void customize(EndPoint endpoint, Request request) throws IOException {
    }

    protected abstract Buffer newBuffer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer getBuffer(int size) {
        if (size == this.headerBufferSize) {
            Vector<Buffer> vector = this.headerBuffers;
            synchronized (vector) {
                if (this.headerBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                Buffer o = this.headerBuffers.elementAt(this.headerBuffers.size() - 1);
                this.headerBuffers.removeElementAt(this.headerBuffers.size() - 1);
                return o;
            }
        }
        if (size == this.responseBufferSize) {
            Vector<Buffer> vector = this.responseBuffers;
            synchronized (vector) {
                if (this.responseBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                Buffer o = this.responseBuffers.elementAt(this.responseBuffers.size() - 1);
                this.responseBuffers.removeElementAt(this.responseBuffers.size() - 1);
                return o;
            }
        }
        if (size == this.requestBufferSize) {
            Vector<Buffer> vector = this.requestBuffers;
            synchronized (vector) {
                if (this.requestBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                Buffer o = this.requestBuffers.elementAt(this.requestBuffers.size() - 1);
                this.requestBuffers.removeElementAt(this.requestBuffers.size() - 1);
                return o;
            }
        }
        return this.newBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        if (!buffer.isVolatile() && !buffer.isImmutable()) {
            int c = buffer.capacity();
            if (c == this.headerBufferSize) {
                Vector<Buffer> vector = this.headerBuffers;
                synchronized (vector) {
                    this.headerBuffers.addElement(buffer);
                }
            }
            if (c == this.responseBufferSize) {
                Vector<Buffer> vector = this.responseBuffers;
                synchronized (vector) {
                    this.responseBuffers.addElement(buffer);
                }
            }
            if (c == this.requestBufferSize) {
                Vector<Buffer> vector = this.requestBuffers;
                synchronized (vector) {
                    this.requestBuffers.addElement(buffer);
                }
            }
        }
    }

    @Override
    public int getConfidentialPort() {
        return this.confidentialPort;
    }

    @Override
    public String getConfidentialScheme() {
        return this.confidentialScheme;
    }

    @Override
    public boolean isIntegral(Request request) {
        return false;
    }

    @Override
    public int getIntegralPort() {
        return this.integralPort;
    }

    @Override
    public String getIntegralScheme() {
        return this.integralScheme;
    }

    @Override
    public boolean isConfidential(Request request) {
        return false;
    }

    public void setConfidentialPort(int confidentialPort) {
        this.confidentialPort = confidentialPort;
    }

    public void setConfidentialScheme(String confidentialScheme) {
        this.confidentialScheme = confidentialScheme;
    }

    public void setIntegralPort(int integralPort) {
        this.integralPort = integralPort;
    }

    public void setIntegralScheme(String integralScheme) {
        this.integralScheme = integralScheme;
    }

    protected abstract void accept(int var1) throws IOException, InterruptedException;

    @Override
    public boolean getResolveNames() {
        return this.useDNS;
    }

    public void setResolveNames(boolean resolve) {
        this.useDNS = resolve;
    }

    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            name = name.substring(dot + 1);
        }
        return name + " @ " + (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getRequests() {
        return this.requests;
    }

    @Override
    public long getConnectionsDurationMin() {
        return this.connectionsDurationMin;
    }

    @Override
    public long getConnectionsDurationTotal() {
        return this.connectionsDurationTotal;
    }

    @Override
    public int getConnectionsOpenMin() {
        return this.connectionsOpenMin;
    }

    @Override
    public int getConnectionsRequestsMin() {
        return this.connectionsRequestsMin;
    }

    @Override
    public int getConnections() {
        return this.connections;
    }

    @Override
    public int getConnectionsOpen() {
        return this.connectionsOpen;
    }

    @Override
    public int getConnectionsOpenMax() {
        return this.connectionsOpenMax;
    }

    @Override
    public long getConnectionsDurationAve() {
        return this.connections == 0 ? 0L : this.connectionsDurationTotal / (long)this.connections;
    }

    @Override
    public long getConnectionsDurationMax() {
        return this.connectionsDurationMax;
    }

    @Override
    public int getConnectionsRequestsAve() {
        return this.connections == 0 ? 0 : this.requests / this.connections;
    }

    @Override
    public int getConnectionsRequestsMax() {
        return this.connectionsRequestsMax;
    }

    @Override
    public void statsReset() {
        this.statsStartedAt = this.statsStartedAt == -1L ? -1L : System.currentTimeMillis();
        this.connections = 0;
        this.connectionsOpenMin = this.connectionsOpen;
        this.connectionsOpenMax = this.connectionsOpen;
        this.connectionsOpen = 0;
        this.connectionsDurationMin = 0L;
        this.connectionsDurationMax = 0L;
        this.connectionsDurationTotal = 0L;
        this.requests = 0;
        this.connectionsRequestsMin = 0;
        this.connectionsRequestsMax = 0;
    }

    @Override
    public void setStatsOn(boolean on) {
        if (on && this.statsStartedAt != -1L) {
            return;
        }
        Logger.debug("Statistics on = " + on + " for " + this);
        this.statsReset();
        this.statsStartedAt = on ? System.currentTimeMillis() : -1L;
    }

    @Override
    public boolean getStatsOn() {
        return this.statsStartedAt != -1L;
    }

    @Override
    public long getStatsOnMs() {
        return this.statsStartedAt != -1L ? System.currentTimeMillis() - this.statsStartedAt : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionOpened(HttpConnection connection) {
        if (this.statsStartedAt == -1L) {
            return;
        }
        Object object = this.statsLock;
        synchronized (object) {
            ++this.connectionsOpen;
            if (this.connectionsOpen > this.connectionsOpenMax) {
                this.connectionsOpenMax = this.connectionsOpen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(HttpConnection connection) {
        if (this.statsStartedAt >= 0L) {
            Object object = this.statsLock;
            synchronized (object) {
                int requests = connection.getRequests();
                this.requests += requests;
                long duration = System.currentTimeMillis() - connection.getTimeStamp();
                ++this.connections;
                --this.connectionsOpen;
                this.connectionsDurationTotal += duration;
                if (this.connectionsOpen < 0) {
                    this.connectionsOpen = 0;
                }
                if (this.connectionsOpen < this.connectionsOpenMin) {
                    this.connectionsOpenMin = this.connectionsOpen;
                }
                if (this.connectionsDurationMin == 0L || duration < this.connectionsDurationMin) {
                    this.connectionsDurationMin = duration;
                }
                if (duration > this.connectionsDurationMax) {
                    this.connectionsDurationMax = duration;
                }
                if (this.connectionsRequestsMin == 0 || requests < this.connectionsRequestsMin) {
                    this.connectionsRequestsMin = requests;
                }
                if (requests > this.connectionsRequestsMax) {
                    this.connectionsRequestsMax = requests;
                }
            }
        }
        connection.destroy();
    }

    private class Acceptor
    implements Runnable {
        int id = 0;

        Acceptor(int id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread current = Thread.currentThread();
            AbstractConnector.this.acceptorThreads.get().insertElementAt(current, this.id);
            Logger.debug("Starting " + this);
            try {
                current.setPriority(current.getPriority() - 1);
                while (AbstractConnector.this.isRunning() && (!(AbstractConnector.this.getThreadPool() instanceof LifeCycle) || ((LifeCycle)((Object)AbstractConnector.this.getThreadPool())).isRunning())) {
                    try {
                        AbstractConnector.this.accept(this.id);
                    }
                    catch (IOException e) {
                        Logger.debug(e);
                    }
                    catch (Exception e) {
                        Logger.debug(e);
                    }
                }
            }
            catch (Throwable throwable) {
                Logger.debug("Stopping " + this);
                current.setPriority(current.getPriority() + 1);
                try {
                    if (this.id == 0) {
                        AbstractConnector.this.close();
                    }
                }
                catch (IOException e) {
                    Logger.debug(e);
                }
                throw throwable;
            }
            Logger.debug("Stopping " + this);
            current.setPriority(current.getPriority() + 1);
            try {
                if (this.id == 0) {
                    AbstractConnector.this.close();
                }
            }
            catch (IOException e) {
                Logger.debug(e);
            }
        }
    }
}

