/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import com.sun.javacard.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.View;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceFactory;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ResourceCache
extends AbstractLifeCycle {
    private int maxCachedFileSize = 0x100000;
    private int maxCachedFiles = 2048;
    private int maxCacheSize = 0x1000000;
    MimeTypes mimeTypes;
    protected transient Hashtable<String, Content> cache;
    protected transient int cacheSize;
    protected transient int cachedFiles;
    protected transient Content mostRecentlyUsed;
    protected transient Content leastRecentlyUsed;

    public ResourceCache(MimeTypes mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public int getMaxCachedFileSize() {
        return this.maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int maxCachedFileSize) {
        this.maxCachedFileSize = maxCachedFileSize;
        this.flushCache();
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.flushCache();
    }

    public int getMaxCachedFiles() {
        return this.maxCachedFiles;
    }

    public void setMaxCachedFiles(int maxCachedFiles) {
        this.maxCachedFiles = maxCachedFiles;
    }

    public void flushCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content lookup(String pathInContext, ResourceFactory factory) throws IOException {
        Logger.debug("lookup {}" + pathInContext);
        Content content = null;
        Hashtable<String, Content> hashtable = this.cache;
        synchronized (hashtable) {
            content = this.cache.get(pathInContext);
            if (content != null) {
                if (!content.isValid()) {
                    content = null;
                } else {
                    Logger.debug("CACHE HIT: {}" + content);
                }
            }
            if (content == null) {
                Resource resource = factory.getResource(pathInContext);
                if (resource == null) {
                    return null;
                }
                long len = resource.length();
                if (resource.exists()) {
                    if (resource.isDirectory()) {
                        return null;
                    }
                    content = new Content(resource);
                    if (len > 0L && len < (long)this.maxCachedFileSize && len < (long)this.maxCacheSize) {
                        int needed = this.maxCacheSize - (int)len;
                        while (this.cacheSize > needed || this.maxCachedFiles > 0 && this.cachedFiles > this.maxCachedFiles) {
                            this.leastRecentlyUsed.invalidate();
                        }
                        this.fill(content);
                        content.cache(pathInContext);
                        Logger.debug("CACHED: {}" + resource);
                    }
                }
            }
        }
        return content;
    }

    @Override
    public synchronized void doStart() throws Exception {
        this.cache = new Hashtable();
        this.cacheSize = 0;
        this.cachedFiles = 0;
    }

    @Override
    public void doStop() {
        this.flushCache();
        this.cache = null;
    }

    protected void fill(Content content) throws IOException {
        InputStream in = content.getResource().getInputStream();
        int len = (int)content.getResource().length();
        ByteArrayBuffer buffer = new ByteArrayBuffer(len);
        buffer.readFrom(in, len);
        in.close();
        content.setBuffer(buffer);
    }

    public class Content
    implements HttpContent {
        String key;
        Resource resource;
        long lastModified;
        Content prev;
        Content next;
        Buffer lastModifiedBytes;
        Buffer contentType;
        Buffer buffer;

        Content(Resource resource) {
            this.resource = resource;
            this.lastModified = resource.lastModified();
            this.next = this;
            this.prev = this;
            this.contentType = ResourceCache.this.mimeTypes.getMimeByExtension(this.resource.toString());
        }

        void cache(String pathInContext) {
            this.key = pathInContext;
            this.next = ResourceCache.this.mostRecentlyUsed;
            ResourceCache.this.mostRecentlyUsed = this;
            if (this.next != null) {
                this.next.prev = this;
            }
            this.prev = null;
            if (ResourceCache.this.leastRecentlyUsed == null) {
                ResourceCache.this.leastRecentlyUsed = this;
            }
            ResourceCache.this.cache.put(this.key, this);
            ResourceCache.this.cacheSize = (int)((long)ResourceCache.this.cacheSize + this.resource.length());
            ++ResourceCache.this.cachedFiles;
            this.lastModifiedBytes = new ByteArrayBuffer(HttpFields.formatDate(this.resource.lastModified(), false));
        }

        public String getKey() {
            return this.key;
        }

        public boolean isCached() {
            return this.key != null;
        }

        @Override
        public Resource getResource() {
            return this.resource;
        }

        boolean isValid() {
            if (this.lastModified == this.resource.lastModified()) {
                if (ResourceCache.this.mostRecentlyUsed != this) {
                    Content tp = this.prev;
                    Content tn = this.next;
                    this.next = ResourceCache.this.mostRecentlyUsed;
                    ResourceCache.this.mostRecentlyUsed = this;
                    if (this.next != null) {
                        this.next.prev = this;
                    }
                    this.prev = null;
                    if (tp != null) {
                        tp.next = tn;
                    }
                    if (tn != null) {
                        tn.prev = tp;
                    }
                    if (ResourceCache.this.leastRecentlyUsed == this && tp != null) {
                        ResourceCache.this.leastRecentlyUsed = tp;
                    }
                }
                return true;
            }
            this.invalidate();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            Content content = this;
            synchronized (content) {
                ResourceCache.this.cache.remove(this.key);
                this.key = null;
                ResourceCache.this.cacheSize -= (int)this.resource.length();
                --ResourceCache.this.cachedFiles;
                if (ResourceCache.this.mostRecentlyUsed == this) {
                    ResourceCache.this.mostRecentlyUsed = this.next;
                } else {
                    this.prev.next = this.next;
                }
                if (ResourceCache.this.leastRecentlyUsed == this) {
                    ResourceCache.this.leastRecentlyUsed = this.prev;
                } else {
                    this.next.prev = this.prev;
                }
                this.prev = null;
                this.next = null;
                this.resource = null;
            }
        }

        @Override
        public Buffer getLastModified() {
            return this.lastModifiedBytes;
        }

        @Override
        public Buffer getContentType() {
            return this.contentType;
        }

        public void setContentType(Buffer type) {
            this.contentType = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            Content content = this;
            synchronized (content) {
                if (this.key == null) {
                    this.resource.release();
                }
            }
        }

        @Override
        public Buffer getBuffer() {
            if (this.buffer == null) {
                return null;
            }
            return new View(this.buffer);
        }

        public void setBuffer(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public long getContentLength() {
            if (this.buffer == null) {
                return -1L;
            }
            return this.buffer.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.resource.getInputStream();
        }
    }
}

