/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import com.sun.javacard.Logger;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.jcre.JCRuntime;
import com.sun.javacard.net.MalformedURLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.resource.Resource;
import org.mortbay.util.URIUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class FileResource
extends Resource {
    private static boolean checkAliases;
    private FileConnection fileConnection;
    private String urlString;
    private transient String alias = null;
    private transient boolean aliasChecked = false;

    public static void setCheckAliases(boolean checkAliases) {
        FileResource.checkAliases = checkAliases;
    }

    public static boolean getCheckAliases() {
        return checkAliases;
    }

    FileResource(String urlString, FileConnection file) {
        this.fileConnection = file;
        this.urlString = urlString;
        Logger.debug("url=" + urlString);
        Logger.debug("file=" + file);
        try {
            Logger.debug("file.isDirectory=" + file.isDirectory());
            if (this.fileConnection.isDirectory() && !this.urlString.endsWith("/")) {
                this.urlString = this.urlString + "/";
            }
        }
        catch (IOException e) {
            Logger.debug("FileConnection.isDirectory threw an IOException");
        }
        Logger.debug("done");
    }

    @Override
    public Resource addPath(String path) throws IOException, MalformedURLException {
        FileResource r = null;
        if (!this.isDirectory()) {
            if (path == null) {
                return null;
            }
            path = URIUtil.canonicalPath(path);
            r = (FileResource)Resource.newResource(URIUtil.addPaths(this.urlString, path));
        } else {
            if ((path = URIUtil.canonicalPath(path)) == null) {
                throw new MalformedURLException();
            }
            String rel = path;
            if (path.startsWith("/")) {
                rel = path.substring(1);
            }
            r = (FileResource)Resource.newResource(URIUtil.addPaths(this.urlString, URIUtil.encodePath(rel)));
        }
        String encoded = URIUtil.encodePath(path);
        int expected = r.toString().length() - encoded.length();
        int index = FileResource.lastIndexOf(r.urlString, encoded, expected);
        if (expected != index && (expected - 1 != index || path.endsWith("/") || !r.isDirectory())) {
            r.alias = this.urlString;
            r.aliasChecked = true;
        }
        return r;
    }

    private static int lastIndexOf(String str, String find, int beginIndex) {
        int index = -1;
        while ((beginIndex = str.indexOf(find, beginIndex)) != -1) {
            index = beginIndex++;
        }
        return index;
    }

    @Override
    public String getAlias() {
        if (checkAliases && !this.aliasChecked) {
            try {
                String abs = this.fileConnection.getAbsolutePath();
                String can = this.fileConnection.getCanonicalPath();
                if (abs.length() != can.length() || !abs.equals(can)) {
                    this.alias = new FileConnection(can).toString();
                }
                this.aliasChecked = true;
                if (this.alias != null) {
                    Logger.debug("ALIAS abs=" + abs);
                    Logger.debug("ALIAS can=" + can);
                }
            }
            catch (Exception e) {
                Logger.debug(e);
                return this.getURL();
            }
        }
        return this.alias;
    }

    @Override
    public boolean exists() {
        boolean exists = false;
        try {
            exists = this.fileConnection.exists();
        }
        catch (IOException e) {
            Logger.debug("FileConnection.exists threw IOException");
        }
        return exists;
    }

    @Override
    public long lastModified() {
        return this.fileConnection.lastModified();
    }

    @Override
    public boolean isDirectory() {
        boolean is = false;
        try {
            is = this.fileConnection.isDirectory();
        }
        catch (IOException e) {
            Logger.debug("fileConnection.isDirectory() threw IOException");
        }
        return is;
    }

    @Override
    public long length() {
        return this.fileConnection.length();
    }

    public String toString() {
        return this.urlString;
    }

    @Override
    public String getURL() {
        return this.urlString;
    }

    @Override
    public void release() {
    }

    @Override
    public String getName() {
        return this.fileConnection.getAbsolutePath();
    }

    @Override
    public FileConnection getFile() {
        return this.fileConnection;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fileConnection.openInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws SecurityException, IOException {
        return this.fileConnection.openOutputStream();
    }

    @Override
    public boolean delete() throws SecurityException {
        boolean deleted = false;
        try {
            deleted = this.fileConnection.delete();
        }
        catch (IOException e) {
            Logger.debug("fileConnection.delete() threw IOException");
        }
        return deleted;
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        boolean done = false;
        if (dest instanceof FileResource) {
            try {
                done = this.fileConnection.renameTo(((FileResource)dest).fileConnection.getAbsolutePath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return done;
    }

    @Override
    public String[] list() {
        Vector<String> files = new Vector<String>();
        try {
            Enumeration<String> list = this.fileConnection.list();
            while (list.hasMoreElements()) {
                String fileName = list.nextElement();
                if (new FileConnection(this.fileConnection, fileName).isDirectory() && !fileName.endsWith("/")) {
                    files.addElement(fileName + "/");
                    continue;
                }
                files.addElement(fileName);
            }
        }
        catch (IOException e) {
            Logger.debug("fileConnection.list threw an IOException");
        }
        Object[] resourceArray = new String[files.size()];
        files.copyInto(resourceArray);
        return resourceArray;
    }

    @Override
    public String encode(String uri) {
        return uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || !(o instanceof FileResource)) {
            return false;
        }
        FileResource f = (FileResource)o;
        return f.fileConnection == this.fileConnection || null != this.fileConnection && this.fileConnection.equals(f.fileConnection);
    }

    public int hashCode() {
        return null == this.fileConnection ? this.urlString.hashCode() : this.fileConnection.hashCode();
    }

    static {
        Logger.debug("org.mortbay.jetty.FileResource.STATIC() -> ");
        checkAliases = "true".equalsIgnoreCase(JCRuntime.getProperty("org.mortbay.util.FileResource.checkAliases", "true"));
        if (checkAliases) {
            Logger.debug("Checking Resource aliases");
        }
    }
}

