/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.Iterator;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.util.EmptyLists;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class LazyList<T>
implements Iterable<T> {
    private T justObject;
    private Vector<T> vector;

    private LazyList(T justObject) {
        this.justObject = justObject;
    }

    @Override
    public Iterator<T> iterator() {
        return LazyList.iterator(this);
    }

    public static <T> LazyList<T> add(LazyList<T> list, T item) {
        if (item == null) {
            return list;
        }
        if (list == null) {
            LazyList<T> l = new LazyList<T>(item);
            return l;
        }
        if (list.vector == null) {
            list.vector = new Vector();
            list.vector.addElement(list.justObject);
            list.justObject = null;
        }
        list.vector.addElement(item);
        return list;
    }

    public static <T> LazyList<T> addCollection(LazyList<T> list, Vector<T> collection) {
        Iterator<T> i = collection.iterator();
        while (i.hasNext()) {
            list = LazyList.add(list, i.next());
        }
        return list;
    }

    public static <T> LazyList<T> addArray(LazyList<T> list, T[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            list = LazyList.add(list, array[i]);
        }
        return list;
    }

    public static <T> LazyList<T> ensureSize(LazyList<T> list, int initialSize) {
        if (list == null) {
            list = new LazyList<Object>(null);
            list.vector = new Vector(initialSize);
        }
        list.vector.ensureCapacity(initialSize);
        return list;
    }

    public static <T> LazyList<T> remove(LazyList<T> list, T o) {
        if (list == null) {
            return null;
        }
        if (list.justObject != null) {
            list.justObject = null;
            return null;
        }
        list.vector.removeElement(o);
        if (list.vector.size() == 0) {
            return null;
        }
        return list;
    }

    public static <T> LazyList<T> remove(LazyList<T> list, int index) {
        if (list == null) {
            return null;
        }
        if (list.justObject != null) {
            list.justObject = null;
            return null;
        }
        if (list.vector != null) {
            list.vector.removeElementAt(index);
            if (list.vector.size() <= 0) {
                return null;
            }
        }
        return list;
    }

    public static <T> Vector<T> getList(LazyList<T> list) {
        return LazyList.getList(list, false);
    }

    public static <T> Vector<T> getList(LazyList<T> list, boolean nullForEmpty) {
        if (list == null) {
            return nullForEmpty ? null : EmptyLists.EMPTY_VECTOR;
        }
        if (list.vector == null) {
            list.vector = new Vector();
            list.vector.addElement(list.justObject);
            list.justObject = null;
        }
        return list.vector;
    }

    public static <T> int size(LazyList<T> list) {
        if (list == null) {
            return 0;
        }
        if (list.vector != null) {
            return list.vector.size();
        }
        return 1;
    }

    public static <T> T get(LazyList<T> list, int i) {
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        if (list.vector != null) {
            return list.vector.elementAt(i);
        }
        if (i == 0) {
            return list.justObject;
        }
        throw new IndexOutOfBoundsException();
    }

    public static <T> boolean contains(LazyList<T> list, T item) {
        if (list == null) {
            return false;
        }
        if (list.vector != null) {
            return list.vector.contains(item);
        }
        return list.equals(item);
    }

    public static <T> LazyList<T> duplicate(LazyList<T> list) {
        if (list == null) {
            return null;
        }
        LazyList<Object> l = new LazyList<Object>(null);
        l.justObject = list.justObject;
        if (list.vector != null) {
            l.vector = new Vector();
            for (T vo : list.vector) {
                l.vector.addElement(vo);
            }
        }
        return l;
    }

    public static <T> Iterator<T> iterator(LazyList<T> list) {
        if (list == null) {
            return EmptyLists.EMPTY_VECTOR.iterator();
        }
        if (list.vector != null) {
            return list.vector.iterator();
        }
        return LazyList.getList(list).iterator();
    }

    public static <T> LazyList<T> array2List(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        LazyList<Object> list = new LazyList<Object>(null);
        if (array.length == 0) {
            list.justObject = array[0];
        } else {
            list.vector = new Vector();
            for (T a : array) {
                list.vector.addElement(a);
            }
        }
        return list;
    }
}

