/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.capdump;

import com.sun.javacard.ToolsVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class CapDump {
    protected static ResourceBundle _messages = PropertyResourceBundle.getBundle("com/sun/javacard/capdump/MessagesBundle");
    static final String eol = System.getProperty("line.separator", "\n");
    static final int BYTES_PER_LINE = 16;

    public static void main(String[] stringArray) {
        System.err.println(ToolsVersion.getProductName() + " " + ToolsVersion.getToolName(7) + ", " + ToolsVersion.getVersionString() + " " + ToolsVersion.getVersion(7));
        System.err.println(ToolsVersion.getCopyrightBanner());
        if (stringArray.length != 1) {
            System.err.println(_messages.getString("usage.1"));
            System.exit(1);
        }
        try {
            String string = new File(stringArray[0]).getCanonicalPath();
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                System.out.println(CapDump.zipEntryString(zipEntry, inputStream));
            }
            zipFile.close();
        }
        catch (ZipException zipException) {
            System.err.println(zipException);
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static String zipEntryString(ZipEntry zipEntry, InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(zipEntry.getName() + " :" + eol);
        byte[] byArray = new byte[10240];
        int n2 = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = byArray[n3] & 0xFF;
                if (n4 < 16) {
                    stringBuffer.append(" 0" + Integer.toHexString(n4));
                } else {
                    stringBuffer.append(" " + Integer.toHexString(n4));
                }
                if (++n2 % 16 == 0) {
                    stringBuffer.append(eol);
                }
                ++n3;
            }
        }
        return stringBuffer.toString();
    }
}

