/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.validator.AttributedItem;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.ValidValues;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.Manifest;

public abstract class ModuleJCRD
extends AttributedItem {
    protected static final String MAPPED_TO_CLIENT_URI = "-Mapped-To-Client-URI";
    protected static final String MAPPED_TO_DOMAIN_NAME = "-Mapped-To-Domain-Name";
    protected static final String MAPPED_TO_AUTH_CREDENTIAL = "-Mapped-To-Auth-Credential";
    protected static final String CLIENT_CREDENTIAL_AUTH_TYPE = "-Credential-Auth-Type";
    protected static final String CLIENT_CREDENTIAL_AUTH_DURATION = "-Credential-Auth-Duration";
    protected static final String MAPPED_TO_AUTH_URI = "-Mapped-To-Auth-URI";
    protected static final String[] CLIENT_MAPPING_ATTRIBUTES_LIST = new String[]{"-Mapped-To-Client-URI", "-Mapped-To-Domain-Name", "-Mapped-To-Auth-Credential", "-Credential-Auth-Type", "-Credential-Auth-Duration"};
    protected Module module;
    protected File file;
    protected Vector<String> oncardClientRoleList = new Vector();
    protected Vector<String> userRoleList = new Vector();
    protected String oncardClientsCredentialAuthType;
    protected String oncardClientsCredentialAuthDuration;
    protected Hashtable<String, Vector<String>> clientRoleMappedToClientURI = new Hashtable();
    protected Hashtable<String, Vector<String>> clientRoleMappedToDomainName = new Hashtable();
    protected Hashtable<String, Vector<String>> clientRoleMappedToAuthCredential = new Hashtable();
    protected Hashtable<String, String> clientRoleCredentialAuthType = new Hashtable();
    protected Hashtable<String, String> clientRoleCredentialAuthDuration = new Hashtable();
    protected Hashtable<String, Vector<String>> userRoleMappedToAuthURI = new Hashtable();
    protected String applicationType;
    private String runtimeDescriptorVersion;

    public ModuleJCRD(Module module, File file) {
        this.module = module;
        this.file = file;
    }

    @Override
    public void initialize() {
        if (!this.file.exists()) {
            this.addError(ErrorKey.DoesNotExists, this.file.getAbsolutePath());
            this.proceed = false;
            return;
        }
        Manifest manifest = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            manifest = new Manifest(fis);
            fis.close();
        }
        catch (Exception e) {
            this.addError(ErrorKey.UnableToParseManifestFile, new Object[0]);
            this.proceed = false;
            return;
        }
        this.attributes = manifest.getMainAttributes();
        Object[] manifestKeysObjArray = this.attributes.keySet().toArray();
        for (int i = 0; i < manifestKeysObjArray.length; ++i) {
            this.jcrdKeyList.add(manifestKeysObjArray[i].toString());
        }
        this.runtimeDescriptorVersion = this.getAttributeValue("Runtime-Descriptor-Version");
        if (this.runtimeDescriptorVersion == null) {
            this.addError(ErrorKey.MissingAttribute, "Runtime-Descriptor-Version");
        }
        this.applicationType = this.getAttributeValue("Application-Type");
        if (this.applicationType == null || this.applicationType.trim().length() <= 0) {
            this.addError(ErrorKey.MissingAttribute, "Application-Type");
        }
        String listString = null;
        this.oncardClientsCredentialAuthType = this.getAttributeValue("On-Card-Clients-Credential-Auth-Type", false);
        if (this.oncardClientsCredentialAuthType == null) {
            this.oncardClientsCredentialAuthType = "client-only";
        } else if (!ValidValues.isValidCredentialAuthType(this.oncardClientsCredentialAuthType)) {
            this.addError(ErrorKey.InvalidAttributeValue, this.oncardClientsCredentialAuthType, "On-Card-Clients-Credential-Auth-Type");
            this.oncardClientsCredentialAuthType = "client-only";
        }
        this.oncardClientsCredentialAuthDuration = this.getAttributeValue("On-Card-Clients-Credential-Auth-Duration", false);
        if (this.oncardClientsCredentialAuthDuration == null) {
            this.oncardClientsCredentialAuthDuration = "card-session";
        } else if (!ValidValues.isValidCredentialAuthDuration(this.oncardClientsCredentialAuthDuration)) {
            this.addError(ErrorKey.InvalidAttributeValue, this.oncardClientsCredentialAuthDuration, "On-Card-Clients-Credential-Auth-Duration");
            this.oncardClientsCredentialAuthDuration = "card-session";
        }
        listString = this.getAttributeValue("On-Card-Client-Role-List");
        if (listString != null) {
            this.oncardClientRoleList = this.splitNames(listString);
        }
        if ((listString = this.getAttributeValue("User-Role-List")) != null) {
            this.userRoleList = this.splitNames(listString);
        }
        StringBuffer duplicates = new StringBuffer();
        for (String str : this.userRoleList) {
            if (!this.oncardClientRoleList.contains(str)) continue;
            if (duplicates.length() > 0) {
                duplicates.append(", ");
            }
            duplicates.append(str);
        }
        if (duplicates.length() > 0) {
            this.addError(ErrorKey.DuplicateRoleNames, duplicates);
        }
        for (String str : this.oncardClientRoleList) {
            listString = this.getAttributeValue(str + MAPPED_TO_CLIENT_URI);
            if (listString != null && !this.isClientRoleALreadyMapped(str)) {
                this.clientRoleMappedToClientURI.put(str, this.splitNames(listString));
            }
            if ((listString = this.getAttributeValue(str + MAPPED_TO_DOMAIN_NAME)) != null && !this.isClientRoleALreadyMapped(str)) {
                this.clientRoleMappedToDomainName.put(str, this.splitNames(listString));
            }
            if ((listString = this.getAttributeValue(str + MAPPED_TO_AUTH_CREDENTIAL)) != null && !this.isClientRoleALreadyMapped(str)) {
                this.clientRoleMappedToAuthCredential.put(str, this.splitNames(listString));
            }
            if ((listString = this.getAttributeValue(str + CLIENT_CREDENTIAL_AUTH_TYPE)) == null) {
                this.clientRoleCredentialAuthType.put(str, this.oncardClientsCredentialAuthType);
            } else {
                this.clientRoleCredentialAuthType.put(str, listString);
            }
            listString = this.getAttributeValue(str + CLIENT_CREDENTIAL_AUTH_DURATION);
            if (listString == null) {
                this.clientRoleCredentialAuthDuration.put(str, this.oncardClientsCredentialAuthDuration);
                continue;
            }
            this.clientRoleCredentialAuthDuration.put(str, listString);
        }
        for (String str : this.userRoleList) {
            listString = this.getAttributeValue(str + MAPPED_TO_AUTH_URI);
            if (listString == null) continue;
            this.userRoleMappedToAuthURI.put(str, this.splitNames(listString));
        }
    }

    @Override
    public void processInternal() {
        if (this.runtimeDescriptorVersion != null && !this.runtimeDescriptorVersion.equals("3.0")) {
            this.addError(ErrorKey.InvalidVersion, this.runtimeDescriptorVersion);
        }
        if (this.applicationType != null && !ValidValues.isValidAppType(this.applicationType)) {
            this.addError(ErrorKey.InvliadAttributeApplicationType, this.applicationType);
        }
        if (this.applicationType != null && this.applicationType.equals("classic-applet")) {
            return;
        }
        this.verifyClientRolesMapping();
        this.verifyUserRolesMapping();
        for (String key : this.jcrdKeyList) {
            if (key.endsWith(MAPPED_TO_AUTH_URI)) {
                String role = key.substring(0, key.indexOf(MAPPED_TO_AUTH_URI));
                if (this.userRoleList.contains(role)) continue;
                this.addError(ErrorKey.RoleOfMappingAttributeIsNotListed, key, "User-Role-List");
                continue;
            }
            for (String clientMappedAttr : CLIENT_MAPPING_ATTRIBUTES_LIST) {
                String role;
                if (!key.endsWith(clientMappedAttr) || (role = key.substring(0, key.indexOf(clientMappedAttr))).equalsIgnoreCase("on-card-clients") || this.oncardClientRoleList.contains(role)) continue;
                this.addError(ErrorKey.RoleOfMappingAttributeIsNotListed, key, "On-Card-Client-Role-List");
            }
        }
        for (String keyValue : this.jcrdKeyList) {
            String value;
            String keyWord = "";
            if (keyValue.endsWith(MAPPED_TO_CLIENT_URI)) {
                keyWord = MAPPED_TO_CLIENT_URI;
                value = this.getAttributeValue(keyValue).trim();
                if (value.equals("") || !value.startsWith("/")) {
                    this.addError(ErrorKey.InvalidClientURI, value);
                    continue;
                }
            } else if (keyValue.endsWith(MAPPED_TO_DOMAIN_NAME)) {
                keyWord = MAPPED_TO_DOMAIN_NAME;
                value = this.getAttributeValue(keyValue).trim();
                if (value.equals("") || !value.startsWith("pd:")) {
                    this.addError(ErrorKey.InvalidProtectionDomainName, value);
                    continue;
                }
            } else if (keyValue.endsWith(MAPPED_TO_AUTH_CREDENTIAL)) {
                keyWord = MAPPED_TO_AUTH_CREDENTIAL;
                value = this.getAttributeValue(keyValue).trim();
                if (value.equals("")) {
                    this.addError(ErrorKey.InvalidAuthCredential, value);
                    continue;
                }
            } else if (keyValue.endsWith(CLIENT_CREDENTIAL_AUTH_TYPE)) {
                keyWord = CLIENT_CREDENTIAL_AUTH_TYPE;
                value = this.getAttributeValue(keyValue);
                if (!ValidValues.isValidCredentialAuthType(value)) {
                    this.addError(ErrorKey.InvalidAttributeValue, value, keyValue);
                }
            } else if (keyValue.endsWith(CLIENT_CREDENTIAL_AUTH_DURATION)) {
                keyWord = CLIENT_CREDENTIAL_AUTH_DURATION;
                value = this.getAttributeValue(keyValue);
                if (!ValidValues.isValidCredentialAuthDuration(value)) {
                    this.addError(ErrorKey.InvalidAttributeValue, value, keyValue);
                }
            } else if (keyValue.endsWith(MAPPED_TO_AUTH_URI)) {
                keyWord = MAPPED_TO_AUTH_URI;
            }
            if (keyWord.equals("")) continue;
            String roleName = keyValue.substring(0, keyWord.length());
            if (keyWord.equals(MAPPED_TO_AUTH_URI)) {
                if (this.userRoleList.contains(roleName)) continue;
                continue;
            }
            if (this.oncardClientRoleList.contains(roleName)) continue;
        }
    }

    void verifyUserRolesMapping() {
        for (String userRole : this.userRoleList) {
            Vector<String> mappedRoles = this.userRoleMappedToAuthURI.get(userRole);
            if (mappedRoles == null) {
                this.addError(ErrorKey.UserRoleNotMappedToAuthURI, userRole);
                continue;
            }
            for (String authURI : mappedRoles) {
                this.validateAuthenticatorURI(authURI, userRole);
            }
        }
    }

    boolean isClientRoleALreadyMapped(String roleName) {
        if (this.clientRoleMappedToClientURI.containsKey(roleName) || this.clientRoleMappedToDomainName.containsKey(roleName) || this.clientRoleMappedToAuthCredential.containsKey(roleName)) {
            this.addError(ErrorKey.ClientRoleMappedMoreThanOnce, roleName);
            return true;
        }
        if (this.clientRoleMappedToDomainName.containsKey(roleName)) {
            this.addError(ErrorKey.ClientRoleMappedMoreThanOnce, roleName);
            return true;
        }
        return false;
    }

    void verifyClientRolesMapping() {
        for (String clientRole : this.oncardClientRoleList) {
            if (this.jcrdKeyList.contains(clientRole + MAPPED_TO_CLIENT_URI) || this.jcrdKeyList.contains(clientRole + MAPPED_TO_DOMAIN_NAME) || this.jcrdKeyList.contains(clientRole + MAPPED_TO_AUTH_CREDENTIAL)) continue;
            this.addError(ErrorKey.ClientNotMappedtoAnyAttributes, clientRole);
        }
    }

    void validateAuthenticatorURI(String authURI, String userRole) {
        String holderGlobalURIStart = "sio:///standard/auth/holder/global/";
        String holderSessionURIStart = "sio:///standard/auth/holder/session/";
        String userSessionURIStart = "sio:///standard/auth/user/session/";
        int prefixSize = 0;
        if (authURI.startsWith(holderGlobalURIStart)) {
            prefixSize = holderGlobalURIStart.length();
        } else if (authURI.startsWith(holderSessionURIStart)) {
            prefixSize = holderSessionURIStart.length();
        } else if (authURI.startsWith(userSessionURIStart)) {
            prefixSize = userSessionURIStart.length();
        } else {
            this.addError(ErrorKey.InvalidAuthURIStart, authURI);
            return;
        }
        String subURI = authURI.substring(prefixSize);
        int lastSlashIndex = subURI.lastIndexOf("/");
        if (lastSlashIndex == -1) {
            this.addError(ErrorKey.InvalidAuthURIMissingScheme, authURI);
            return;
        }
        String scheme = subURI.substring(lastSlashIndex + 1);
        if (scheme.trim().equals("")) {
            this.addError(ErrorKey.InvalidAuthURIMissingScheme, authURI);
            return;
        }
        String user = subURI.substring(0, lastSlashIndex);
        if ((lastSlashIndex = user.lastIndexOf("/")) > -1) {
            user = user.substring(lastSlashIndex + 1);
        }
    }

    @Override
    public String getItemDisplayName() {
        return "JCRD";
    }

    public Vector<String> getOncardClientRoleList() {
        return this.oncardClientRoleList;
    }

    public Vector<String> getUserRoleList() {
        return this.userRoleList;
    }

    public Hashtable<String, Vector<String>> getUserRoleAuthURIMappings() {
        return this.userRoleMappedToAuthURI;
    }
}

