/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.impl;

import javacard.framework.JCSystem;

public class PackedBoolean {
    protected byte[] container;
    protected byte nextId;
    private byte bOff;
    private byte bitMask;

    public PackedBoolean(byte maxBytes) {
        this.container = JCSystem.makeTransientByteArray(maxBytes, (byte)1);
        this.nextId = 0;
    }

    public byte allocate() {
        byte by = this.nextId;
        this.nextId = (byte)(by + 1);
        return by;
    }

    protected void compute(byte identifier) {
        this.bOff = (byte)(identifier >> 3);
        byte bitNum = (byte)(identifier & 7);
        this.bitMask = (byte)(128 >> bitNum);
    }

    public boolean get(byte identifier) {
        this.compute(identifier);
        return (this.container[this.bOff] & this.bitMask) != 0;
    }

    public void put(byte identifier, boolean value) {
        if (value) {
            this.set(identifier);
        } else {
            this.reset(identifier);
        }
    }

    public void reset(byte identifier) {
        this.compute(identifier);
        byte by = this.bOff;
        this.container[by] = (byte)(this.container[by] & ~this.bitMask);
    }

    public void set(byte identifier) {
        this.compute(identifier);
        byte by = this.bOff;
        this.container[by] = (byte)(this.container[by] | this.bitMask);
    }
}

