/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.instructions;

import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstrByteValue;
import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.classfile.instructions.JInstrCpByteRef;
import com.sun.javacard.classfile.instructions.JInstrCpShortRef;
import com.sun.javacard.classfile.instructions.JInstrFieldRef;
import com.sun.javacard.classfile.instructions.JInstrIinc;
import com.sun.javacard.classfile.instructions.JInstrIntBranch;
import com.sun.javacard.classfile.instructions.JInstrInterfaceRef;
import com.sun.javacard.classfile.instructions.JInstrLookupSwitch;
import com.sun.javacard.classfile.instructions.JInstrMethodRef;
import com.sun.javacard.classfile.instructions.JInstrMultiArray;
import com.sun.javacard.classfile.instructions.JInstrNoOperands;
import com.sun.javacard.classfile.instructions.JInstrShortBranch;
import com.sun.javacard.classfile.instructions.JInstrShortValue;
import com.sun.javacard.classfile.instructions.JInstrTableSwitch;
import com.sun.javacard.classfile.instructions.JInstrWide;
import com.sun.javacard.classfile.instructions.JavaByteCode;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class JInstruction {
    protected JConstantPool cp;
    protected int pc;
    protected int opcode;
    protected boolean basic_block_leader;
    protected boolean catch_finally_block_leader;
    protected JInstruction next_instr = null;
    protected JInstruction prev_instr = null;
    protected int source_line_number = -1;
    protected boolean label_mark;
    protected int label;

    public int getOpcode() {
        return this.opcode;
    }

    public int getPC() {
        return this.pc;
    }

    public String getMnemonic() {
        return JavaByteCode.getMnemonic(this.opcode);
    }

    public void setBasicBlockLeader(boolean flag) {
        this.basic_block_leader = flag;
    }

    public boolean isBasicBlockLeader() {
        return this.basic_block_leader;
    }

    public boolean isCatchFinallyBlockLeader() {
        return this.catch_finally_block_leader;
    }

    public void setCatchFinallyBlockLeader(boolean flag) {
        this.catch_finally_block_leader = flag;
    }

    public JInstruction getNextInstr() {
        return this.next_instr;
    }

    public void setNextInstr(JInstruction next_instr) {
        this.next_instr = next_instr;
    }

    public JInstruction getPrevInstr() {
        return this.prev_instr;
    }

    public void setPrevInstr(JInstruction prev_instr) {
        this.prev_instr = prev_instr;
    }

    public abstract int getSizeInBytes();

    public int getSourceLineNumber() {
        return this.source_line_number;
    }

    public void setSournceLineNumber(int number) {
        this.source_line_number = number;
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int label) {
        this.label = label;
    }

    public JInstruction(JConstantPool cp, int pc, int opcode) {
        this.cp = cp;
        this.pc = pc;
        this.opcode = opcode;
    }

    public void resolve() {
    }

    public void parse(DataInputStream dis) throws IOException {
    }

    public static final JInstruction create(JConstantPool cp, int pc, int opcode) {
        switch (JavaByteCode.getLoadCategory(opcode)) {
            case 1: {
                return new JInstrNoOperands(cp, pc, opcode);
            }
            case 16: {
                return new JInstrByteIndex(cp, pc, opcode);
            }
            case 32: {
                return new JInstrByteValue(cp, pc, opcode);
            }
            case 48: {
                return new JInstrIinc(cp, pc, opcode);
            }
            case 64: {
                return new JInstrCpByteRef(cp, pc, opcode);
            }
            case 256: {
                return new JInstrShortValue(cp, pc, opcode);
            }
            case 512: {
                return new JInstrShortBranch(cp, pc, opcode);
            }
            case 768: {
                return new JInstrCpShortRef(cp, pc, opcode);
            }
            case 1024: {
                return new JInstrFieldRef(cp, pc, opcode);
            }
            case 1280: {
                return new JInstrMethodRef(cp, pc, opcode);
            }
            case 1536: {
                return new JInstrClassRef(cp, pc, opcode);
            }
            case 1792: {
                return new JInstrInterfaceRef(cp, pc, opcode);
            }
            case 4096: {
                return new JInstrTableSwitch(cp, pc, opcode);
            }
            case 8192: {
                return new JInstrLookupSwitch(cp, pc, opcode);
            }
            case 12288: {
                return new JInstrIntBranch(cp, pc, opcode);
            }
            case 16384: {
                return new JInstrWide(cp, pc, opcode);
            }
            case 20480: {
                return new JInstrMultiArray(cp, pc, opcode);
            }
        }
        return null;
    }
}

