/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.AttributeInfo;
import com.sun.javacard.components.caputils.BCConverter;
import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.Util;
import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JavaInstruction;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class CodeAttribute
extends AttributeInfo {
    private ClassConstantPool constantPool;
    private static final String attributeName = "Code";
    private short attributeNameIndex = (short)-1;
    private static final short attributeCount = 0;
    Safeptr byteCodesFromCAP;
    MethodDescriptor md;
    short maxStack;
    short maxLocals;
    int codeLength;
    Vector<ExceptionInfo> exceptionTable;
    Vector<Instruction> byteCodeVector;

    public CodeAttribute(ClassConstantPool cp) {
        this.constantPool = cp;
        this.exceptionTable = new Vector();
        this.attributeNameIndex = (short)this.constantPool.addConstantUtf8Info(attributeName);
        this.setNameIndex(this.attributeNameIndex);
    }

    public CodeAttribute(ClassConstantPool cp, MethodDescriptor md) {
        this(cp);
        boolean isExtended;
        this.md = md;
        MethodInfo mi = Cap.Method.methodInfo(md.methodOffset());
        int methodFlagFromCap = mi.flags();
        boolean bl = isExtended = (methodFlagFromCap & 8) == 8;
        if (isExtended) {
            this.maxStack = (short)mi.maxStackExtended();
            this.maxLocals = (short)(mi.maxLocalsExtended() + mi.numArgsExtended());
            this.byteCodesFromCAP = mi.bytecodeExtended();
        } else {
            this.maxStack = (short)mi.maxStackCompact();
            this.maxLocals = (short)(mi.maxLocalsCompact() + mi.numArgsCompact());
            this.byteCodesFromCAP = mi.bytecodeCompact();
        }
        this.byteCodeVector = BCConverter.convert(md, isExtended, cp);
        BCConverter.fixOffsets(this.byteCodeVector);
        this.createExceptionList(md);
        this.length = this.getAttributeSize();
    }

    public CodeAttribute(Vector<Instruction> javaByteCodeVector, int maxStack, int maxLocals, ClassConstantPool cp) {
        this(cp);
        this.byteCodeVector = javaByteCodeVector;
        this.maxStack = (short)maxStack;
        this.maxLocals = (short)maxLocals;
        this.length = this.getAttributeSize();
    }

    private void createExceptionList(MethodDescriptor md) {
        int codeStartOffset = md.methodOffset();
        int byteCodeCount = md.bytecodeCount();
        int codeEndOffset = codeStartOffset + md.bytecodeCount();
        int numExcHandlers = Cap.Method.handlerCount();
        for (int i = 0; i < numExcHandlers; ++i) {
            ExnHandlerInfo exnHandler = Cap.Method.exceptionHandler(i);
            short handlerStartOffset = (short)exnHandler.startOffset();
            short handlerEndOffset = (short)exnHandler.endOffset();
            if (handlerStartOffset < codeStartOffset || handlerStartOffset >= codeEndOffset || handlerEndOffset >= codeEndOffset) continue;
            short handlerOffset = (short)exnHandler.handlerOffset();
            int handlerType = exnHandler.catchType();
            short exnClassRef = 0;
            if (handlerType != 0) {
                ConstantPoolEntry entry = Cap.ConstantPool.entry(handlerType);
                int classRef = entry.classRef();
                String refName = CAPUtil.getRefName(classRef);
                exnClassRef = this.constantPool.getClassRefIndex(refName);
            }
            short co = (short)(handlerStartOffset - codeStartOffset - 2);
            handlerStartOffset = BCConverter.translateOffset(this.byteCodeVector, co);
            co = (short)(handlerEndOffset - codeStartOffset - 2);
            handlerEndOffset = BCConverter.translateOffset(this.byteCodeVector, co);
            co = (short)(handlerOffset - codeStartOffset - 2);
            handlerOffset = BCConverter.translateOffset(this.byteCodeVector, co);
            this.exceptionTable.add(new ExceptionInfo(handlerStartOffset, handlerEndOffset, handlerOffset, exnClassRef));
        }
    }

    private int getAttributeSize() {
        int i;
        int size = 12;
        this.codeLength = 0;
        for (i = 0; i < this.byteCodeVector.size(); ++i) {
            Instruction instr = this.byteCodeVector.elementAt(i);
            Vector<JavaInstruction> javaInstrs = instr.getJavaInstructions();
            for (int j = 0; j < javaInstrs.size(); ++j) {
                JavaInstruction javaInstr = javaInstrs.elementAt(j);
                size += javaInstr.getSize();
                this.codeLength += javaInstr.getSize();
            }
        }
        for (i = 0; i < this.exceptionTable.size(); ++i) {
            size += 8;
        }
        return size;
    }

    @Override
    void write(ByteArrayOutputStream bos) {
        byte[] buff = Util.getShortBytes(this.nameIndex);
        bos.write(buff, 0, buff.length);
        byte[] lengthBytes = Util.getIntBytes(this.length);
        bos.write(lengthBytes, 0, 4);
        byte[] maxStackBytes = Util.getShortBytes(this.maxStack);
        bos.write(maxStackBytes, 0, 2);
        byte[] maxLocalsBytes = Util.getShortBytes(this.maxLocals);
        bos.write(maxLocalsBytes, 0, 2);
        byte[] codeLengthBytes = Util.getIntBytes(this.codeLength);
        bos.write(codeLengthBytes, 0, 4);
        for (int i = 0; i < this.byteCodeVector.size(); ++i) {
            Instruction instr = this.byteCodeVector.elementAt(i);
            Vector<JavaInstruction> javaInstrs = instr.getJavaInstructions();
            for (int j = 0; j < javaInstrs.size(); ++j) {
                javaInstrs.elementAt(j).write(bos);
            }
        }
        byte[] excTableLengthBytes = Util.getShortBytes((short)this.exceptionTable.size());
        bos.write(excTableLengthBytes, 0, 2);
        for (int i = 0; i < this.exceptionTable.size(); ++i) {
            this.exceptionTable.elementAt(i).write(bos);
        }
        byte[] attrsCountBytes = Util.getShortBytes((short)0);
        bos.write(attrsCountBytes, 0, 2);
    }

    @Override
    public void print(String str) {
        System.out.println(str + "Code Attribute");
        byte[] buff = Util.getShortBytes(this.nameIndex);
        Util.printArray(str + "\tAttribute Name Index: ", buff, buff.length);
        byte[] lengthBytes = Util.getIntBytes(this.length);
        Util.printArray(str + "\tAttribute Length: ", lengthBytes, lengthBytes.length);
        byte[] maxStackBytes = Util.getShortBytes(this.maxStack);
        Util.printArray(str + "\tMax Stack: ", maxStackBytes, maxStackBytes.length);
        byte[] maxLocalsBytes = Util.getShortBytes(this.maxLocals);
        Util.printArray(str + "\tMax Locals: ", maxLocalsBytes, maxLocalsBytes.length);
        byte[] codeLengthBytes = Util.getIntBytes(this.codeLength);
        Util.printArray(str + "\tCode Length: ", codeLengthBytes, codeLengthBytes.length);
        for (int i = 0; i < this.byteCodeVector.size(); ++i) {
            Instruction instr = this.byteCodeVector.elementAt(i);
            Vector<JavaInstruction> javaInstrs = instr.getJavaInstructions();
            for (int j = 0; j < javaInstrs.size(); ++j) {
                javaInstrs.elementAt(j).print(str + "\t");
            }
        }
        byte[] excTableLengthBytes = Util.getShortBytes((short)this.exceptionTable.size());
        Util.printArray(str + "\tException Table Length: ", excTableLengthBytes, excTableLengthBytes.length);
        for (int i = 0; i < this.exceptionTable.size(); ++i) {
            this.exceptionTable.elementAt(i).print(str);
        }
        byte[] attrsCountBytes = Util.getShortBytes((short)0);
        Util.printArray(str + "\tAttribute Count: ", attrsCountBytes, attrsCountBytes.length);
    }

    class ExceptionInfo {
        static final int size = 8;
        short startPC;
        short endPC;
        short handlerPC;
        short catchType;

        ExceptionInfo(short startPC, short endPC, short handlerPC, short catchType) {
            this.startPC = startPC;
            this.endPC = endPC;
            this.handlerPC = handlerPC;
            this.catchType = catchType;
        }

        void write(ByteArrayOutputStream bos) {
            byte[] startPCBytes = Util.getShortBytes(this.startPC);
            bos.write(startPCBytes, 0, 2);
            byte[] endPCBytes = Util.getShortBytes(this.endPC);
            bos.write(endPCBytes, 0, 2);
            byte[] handlerPCBytes = Util.getShortBytes(this.handlerPC);
            bos.write(handlerPCBytes, 0, 2);
            byte[] catchTypeBytes = Util.getShortBytes(this.catchType);
            bos.write(catchTypeBytes, 0, 2);
        }

        void print(String str) {
            byte[] startPCBytes = Util.getShortBytes(this.startPC);
            Util.printArray(str + "\tStart PC: ", startPCBytes, startPCBytes.length);
            byte[] endPCBytes = Util.getShortBytes(this.endPC);
            Util.printArray(str + "\tEnd PC: ", endPCBytes, endPCBytes.length);
            byte[] handlerPCBytes = Util.getShortBytes(this.handlerPC);
            Util.printArray(str + "\tEnd PC: ", handlerPCBytes, handlerPCBytes.length);
            byte[] catchTypeBytes = Util.getShortBytes(this.catchType);
            Util.printArray(str + "\tEnd PC: ", catchTypeBytes, catchTypeBytes.length);
        }
    }
}

